/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.serializer.impl;

import com.supermap.jsuperpy.serializer.DataSerializer;

public class BooleanArraySerializer
extends DataSerializer {
    @Override
    public Class getValueClass() {
        return boolean[].class;
    }

    @Override
    public String getTypeName() {
        return "bL";
    }

    @Override
    public byte[] encode(Object value) {
        if (value instanceof boolean[]) {
            boolean[] values = (boolean[])value;
            byte[] bys = new byte[values.length];
            for (int i = 0; i < values.length; ++i) {
                bys[i] = values[i] ? (byte)1 : 0;
            }
            return bys;
        }
        if (value instanceof Boolean[]) {
            Boolean[] values = (Boolean[])value;
            byte[] bys = new byte[values.length];
            for (int i = 0; i < values.length; ++i) {
                bys[i] = values[i] != false ? (byte)1 : 0;
            }
            return bys;
        }
        return new byte[0];
    }

    public boolean[] decode(byte[] bys) {
        if (bys != null) {
            boolean[] values = new boolean[bys.length];
            for (int i = 0; i < bys.length; ++i) {
                values[i] = bys[i] != 0;
            }
            return values;
        }
        return new boolean[0];
    }
}

