/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialstatistics;

import com.supermap.analyst.spatialstatistics.DistanceMethod;
import com.supermap.analyst.spatialstatistics.EllipseSize;
import com.supermap.analyst.spatialstatistics.InternalEnum;
import com.supermap.analyst.spatialstatistics.InternalHandleDisposable;
import com.supermap.analyst.spatialstatistics.InternalResource;
import com.supermap.analyst.spatialstatistics.MeasureParameterNative;
import com.supermap.analyst.spatialstatistics.StatisticsType;
import java.util.ArrayList;

public class MeasureParameter
extends InternalHandleDisposable {
    private double m_dPrecisionl = 0.0;
    private String m_sWeightFieldName;
    private String m_sSelfWeightFieldName;
    private EllipseSize m_ellipseSize = EllipseSize.SINGLE;
    private String m_sGroupFieldName;
    private ArrayList m_sStatisticsFieldNames;
    private ArrayList m_StatisticsTypes;
    private DistanceMethod m_distanceMethod = DistanceMethod.EUCLIDEAN;
    private boolean m_bOrientation;

    public MeasureParameter() {
        long l = MeasureParameterNative.jni_New();
        this.setHandle(l, true);
        this.Reset();
    }

    void Reset() {
        long l = super.getHandle();
        if (l != 0L) {
            MeasureParameterNative.jni_Reset(l);
        }
    }

    public MeasureParameter(MeasureParameter measureParameter) {
        if (measureParameter == null) {
            String string = InternalResource.loadString("measureParameter", "Global_ArgumentNull", "spatialstatistics_resources");
            throw new NullPointerException(string);
        }
        long l = MeasureParameterNative.jni_New();
        this.setHandle(l, true);
        this.Reset();
        this.setWeightFieldName(measureParameter.getWeightFieldName());
        this.setSelfWeightFieldName(measureParameter.getSelfWeightFieldName());
        this.setEllipseSize(measureParameter.getEllipseSize());
        this.setGroupFieldName(measureParameter.getGroupFieldName());
        this.setStatisticsFieldNames(measureParameter.getStatisticsFieldNames());
        this.setStatisticsTypes(measureParameter.getStatisticsTypes());
        this.setDistanceMethod(measureParameter.getDistanceMethod());
        this.m_bOrientation = measureParameter.m_bOrientation;
    }

    protected long getHandle() {
        long l = super.getHandle();
        if (l != 0L) {
            int n;
            Object[] objectArray;
            int n2;
            MeasureParameterNative.jni_SetWeightField(l, this.m_sWeightFieldName);
            MeasureParameterNative.jni_SetSelfWeightField(l, this.m_sSelfWeightFieldName);
            int n3 = InternalEnum.getUGCValue(this.m_ellipseSize);
            MeasureParameterNative.jni_SetEllipseSize(l, n3);
            MeasureParameterNative.jni_SetGroupField(l, this.m_sGroupFieldName);
            int n4 = InternalEnum.getUGCValue(this.m_distanceMethod);
            MeasureParameterNative.jni_SetDistanceMethod(l, n4);
            if (this.m_sStatisticsFieldNames != null) {
                n2 = this.m_sStatisticsFieldNames.size();
                objectArray = new String[n2];
                for (n = 0; n < n2; ++n) {
                    objectArray[n] = this.m_sStatisticsFieldNames.get(n).toString();
                }
                MeasureParameterNative.jni_SetStatisticsFieldNames(l, objectArray);
            } else {
                MeasureParameterNative.jni_SetStatisticsFieldNames(l, new String[0]);
            }
            if (this.m_StatisticsTypes != null) {
                n2 = this.m_StatisticsTypes.size();
                objectArray = new int[n2];
                for (n = 0; n < n2; ++n) {
                    objectArray[n] = (String)InternalEnum.getUGCValue((StatisticsType)((Object)this.m_StatisticsTypes.get(n)));
                }
                MeasureParameterNative.jni_SetStatisticsTypes(l, (int[])objectArray);
            } else {
                MeasureParameterNative.jni_SetStatisticsTypes(l, new int[0]);
            }
        }
        return l;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            MeasureParameterNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    private double getPrecisionl() {
        return this.m_dPrecisionl;
    }

    private void setPrecisionl(double value) {
        this.m_dPrecisionl = value;
    }

    public String getWeightFieldName() {
        return this.m_sWeightFieldName;
    }

    public void setWeightFieldName(String value) {
        this.m_sWeightFieldName = value;
    }

    public String getSelfWeightFieldName() {
        return this.m_sSelfWeightFieldName;
    }

    public void setSelfWeightFieldName(String value) {
        this.m_sSelfWeightFieldName = value;
    }

    public EllipseSize getEllipseSize() {
        return this.m_ellipseSize;
    }

    public void setEllipseSize(EllipseSize value) {
        this.m_ellipseSize = value;
    }

    public String getGroupFieldName() {
        return this.m_sGroupFieldName;
    }

    public void setGroupFieldName(String value) {
        this.m_sGroupFieldName = value;
    }

    public String[] getStatisticsFieldNames() {
        if (this.m_sStatisticsFieldNames == null) {
            return null;
        }
        int n = this.m_sStatisticsFieldNames.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.m_sStatisticsFieldNames.get(i).toString();
        }
        return stringArray;
    }

    public void setStatisticsFieldNames(String[] value) {
        if (value == null) {
            this.m_sStatisticsFieldNames = null;
        } else {
            int n;
            int n2 = value.length;
            for (n = 0; n < n2; ++n) {
                if (value[n] != null && !value[n].trim().equalsIgnoreCase("")) continue;
                String string = InternalResource.loadString("value[" + n + "]", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
                throw new IllegalArgumentException(string);
            }
            if (this.m_sStatisticsFieldNames != null) {
                this.m_sStatisticsFieldNames.clear();
            } else {
                this.m_sStatisticsFieldNames = new ArrayList();
            }
            for (n = 0; n < n2; ++n) {
                this.m_sStatisticsFieldNames.add(value[n]);
            }
        }
    }

    public StatisticsType[] getStatisticsTypes() {
        if (this.m_StatisticsTypes == null) {
            return null;
        }
        int n = this.m_StatisticsTypes.size();
        StatisticsType[] statisticsTypeArray = new StatisticsType[n];
        for (int i = 0; i < n; ++i) {
            statisticsTypeArray[i] = (StatisticsType)((Object)this.m_StatisticsTypes.get(i));
        }
        return statisticsTypeArray;
    }

    public void setStatisticsTypes(StatisticsType[] value) {
        if (value == null) {
            this.m_StatisticsTypes = null;
        } else {
            int n;
            int n2 = value.length;
            for (n = 0; n < n2; ++n) {
                if (value[n] != null) continue;
                String string = InternalResource.loadString("value[" + n + "]", "Global_StringIsNullOrEmpty", "spatialstatistics_resources");
                throw new IllegalArgumentException(string);
            }
            if (this.m_StatisticsTypes != null) {
                this.m_StatisticsTypes.clear();
            } else {
                this.m_StatisticsTypes = new ArrayList();
            }
            for (n = 0; n < n2; ++n) {
                this.m_StatisticsTypes.add(value[n]);
            }
        }
    }

    public DistanceMethod getDistanceMethod() {
        return this.m_distanceMethod;
    }

    public void setDistanceMethod(DistanceMethod value) {
        this.m_distanceMethod = value;
    }

    public boolean isOrientation() {
        return this.m_bOrientation;
    }

    public void setOrientation(boolean value) {
        this.m_bOrientation = value;
    }
}

