/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.DatasetType;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.conversion.FileType;
import com.supermap.data.conversion.ImportDataInfo;
import com.supermap.data.conversion.ImportDataInfoCSVNative;
import com.supermap.data.conversion.InternalEnum;
import com.supermap.data.conversion.InternalFieldInfos;
import com.supermap.data.conversion.InternalResource;

public class ImportDataInfoCSV
extends ImportDataInfo {
    private boolean m_bIsSetTargetFieldInfoByUse = false;
    private boolean m_bIsSetDatasetTypeByUse = false;

    ImportDataInfoCSV(long handle, String filePath, FileType fileType, String prefixName) {
        super(handle, filePath, fileType, prefixName);
    }

    public DatasetType getDatasetType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDatasetType()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        int n = ImportDataInfoCSVNative.jni_GetDatasetType(this.getHandle());
        DatasetType datasetType = (DatasetType)InternalEnum.parse(DatasetType.class, (int)n);
        return datasetType;
    }

    public void setDatasetType(DatasetType dataType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDatasetType()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        int n = dataType.value();
        ImportDataInfoCSVNative.jni_SetDatasetType(this.getHandle(), n);
        this.m_bIsSetDatasetTypeByUse = true;
    }

    public int getRecordCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRecordCount()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportDataInfoCSVNative.jni_GetRecordCount(this.getHandle());
    }

    public FieldInfos getTargetFieldInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetFieldInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_targetFieldInfos;
    }

    public void setTargetFieldInfos(FieldInfos fieldinfos) {
        if (fieldinfos == null) {
            String string = InternalResource.loadString("fieldInfos", "Global_InvalidConstructorArgument", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetFieldInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_bIsSetTargetFieldInfoByUse = true;
        long l = InternalFieldInfos.getHandle(fieldinfos);
        ImportDataInfoCSVNative.jni_SetTargetFieldInfos(this.getHandle(), l);
        this.Init();
    }

    public FieldInfos getSourceFieldInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSourceFieldInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_sourceFieldInfos;
    }

    public boolean changeFieldName(String oldName, String newName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ChangeFieldName(String oldName, String newName)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.changeFieldName_base(oldName, newName);
    }

    public boolean setImportFieldState(String fieldName, boolean excludeField) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportFieldState(String fieldname,Boolean excludeField)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.setImportFieldState_base(fieldName, excludeField);
    }

    public boolean exchangeFieldOrder(String fieldName1, String fieldName2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("exchangeFieldOrder(String fieldName1, String fieldName2)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.exchangeFieldOrder_base(fieldName1, fieldName2);
    }

    public boolean changeFieldType(String oldName, FieldType fieldType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ChangeFieldName(String oldName, String newName)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.changeFieldType_base(oldName, fieldType);
    }

    public boolean getImportFieldState(String fieldName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportFieldState(String fieldname)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.getImportFieldState_base(fieldName);
    }

    boolean GetTargetFieldInfosByUse() {
        return this.m_bIsSetTargetFieldInfoByUse;
    }

    boolean GetIsSetDatasetTypeByUse() {
        return this.m_bIsSetDatasetTypeByUse;
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }
}

