/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.SpatialIndexInfo;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingCSVNative;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;
import com.supermap.data.conversion.InternalSpatialIndexInfo;

public class ImportSettingCSV
extends ImportSetting {
    private SpatialIndexInfo m_spatialIndexInfo;

    public ImportSettingCSV() {
        long l = ImportSettingCSVNative.jni_New();
        this.setHandle(l, true);
        super.setDataType(DataType.VECTOR);
        this.setSpatialIndex(null);
    }

    public ImportSettingCSV(ImportSettingCSV ImportSettingCSV2) {
        if (ImportSettingCSV2 == null) {
            String string = InternalResource.loadString("ImportSettingCSV", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)ImportSettingCSV2);
        if (l == 0L) {
            String string = InternalResource.loadString("ImportSettingCSV", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingCSVNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(ImportSettingCSV2.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(ImportSettingCSV2.getTargetDatasource());
        this.setTargetPrjCoordSys(ImportSettingCSV2.getTargetPrjCoordSys());
        super.setDataType(DataType.VECTOR);
        this.setSpatialIndex(ImportSettingCSV2.getSpatialIndex());
        this.setImportEmptyDataset(ImportSettingCSV2.isImportEmptyDataset());
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)ImportSettingCSV2));
    }

    public ImportSettingCSV(String sourceFilePath, Datasource targetDatasource) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasource(targetDatasource);
    }

    public ImportSettingCSV(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
    }

    public SpatialIndexInfo getSpatialIndex() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSpatialIndex()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_spatialIndexInfo == null) {
            long l = ImportSettingCSVNative.jni_GetSpatialIndex(this.getHandle());
            this.m_spatialIndexInfo = InternalSpatialIndexInfo.createInstance(l);
        }
        return this.m_spatialIndexInfo;
    }

    public void setSpatialIndex(SpatialIndexInfo value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpatialIndex(SpatialIndexInfo value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = value == null ? 0L : com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)value);
        ImportSettingCSVNative.jni_SetSpatialIndex(this.getHandle(), l);
        this.m_spatialIndexInfo = null;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)value);
    }

    public String getSeparator() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSeparator()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingCSVNative.jni_GetSeparator(this.getHandle());
    }

    public void setSeparator(String separator) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSeparator()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (separator == null || separator.trim().length() == 0) {
            String string = InternalResource.loadString("path", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingCSVNative.jni_SetSeparator(this.getHandle(), separator);
    }

    public boolean getFirstRowIsField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("HasFieldNameInFirstLine()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingCSVNative.jni_GetHasFieldNameInFirstRow(this.getHandle());
    }

    public void setFirstRowIsField(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAttributeIgnored(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingCSVNative.jni_SetHasFieldNameInFirstRow(this.getHandle(), value);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingCSVNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }

    public void setImportEmptyDataset(boolean bImportEmptyDT) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingCSVNative.jni_SetImportEmptyDT(this.getHandle(), bImportEmptyDT);
    }

    public boolean isImportEmptyDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImportEmptyDataset()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingCSVNative.jni_IsImportEmptyDT(this.getHandle());
    }

    public void setFieldsAsPoint(String[] fieldNames) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFieldsAsPoint()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingCSVNative.jni_SetFieldsAsPoint(this.getHandle(), fieldNames);
    }

    public void setIndexsAsPoint(int[] fieldIndexs) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIndexsAsPoint", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingCSVNative.jni_SetIndexsAsPoint(this.getHandle(), fieldIndexs);
    }

    public void setIndexAsGeometry(int geometryIndex) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIndexAsGeometry", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingCSVNative.jni_SetIndexAsGeometry(this.getHandle(), geometryIndex);
    }

    public void setIsFixedFieldLength(boolean bIsFixedFieldLength) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsFixedFieldLength()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingCSVNative.jni_SetIsFixedFieldLength(this.getHandle(), bIsFixedFieldLength);
    }

    public boolean getIsFixedFieldLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsFixedFieldLength()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingCSVNative.jni_GetIsFixedFieldLength(this.getHandle());
    }
}

