/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingMAPGISNative;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;

public class ImportSettingMAPGIS
extends ImportSetting {
    public ImportSettingMAPGIS() {
        long l = ImportSettingMAPGISNative.jni_New();
        this.setHandle(l, true);
        super.setDataType(DataType.VECTOR);
    }

    public ImportSettingMAPGIS(ImportSettingMAPGIS importsettingMAPGIS) {
        if (importsettingMAPGIS == null) {
            String string = InternalResource.loadString("ImportSettingMAPGIS", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = importsettingMAPGIS.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("ImportSettingMAPGIS", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingMAPGISNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importsettingMAPGIS.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importsettingMAPGIS.getTargetDatasource());
        this.setColorIndexFilePath(importsettingMAPGIS.getColorIndexFilePath());
        this.setImportingAsCAD(importsettingMAPGIS.isImportingAsCAD());
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importsettingMAPGIS));
    }

    public ImportSettingMAPGIS(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
    }

    public ImportSettingMAPGIS(String sourceFilePath, Datasource targetDatasource, boolean importingAsCAD) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasource(targetDatasource);
        this.setImportingAsCAD(importingAsCAD);
        super.setDataType(DataType.VECTOR);
    }

    public ImportSettingMAPGIS(String sourceFilePath, DatasourceConnectionInfo targetConnectionInfo, boolean importingAsCAD) {
        this();
        this.setSourceFilePath(sourceFilePath);
        this.setTargetDatasourceConnectionInfo(targetConnectionInfo);
        this.setImportingAsCAD(importingAsCAD);
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)targetConnectionInfo);
    }

    public void setImportingAsCAD(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsCAD(boolean value)", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingMAPGISNative.jni_SetImportingAsCAD(this.getHandle(), value);
    }

    public boolean isImportingAsCAD() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingAsCAD()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingMAPGISNative.jni_IsImportingAsCAD(this.getHandle());
    }

    public String getColorIndexFilePath() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVisibleFlag()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingMAPGISNative.jni_GetColorIndexFilePath(this.getHandle());
    }

    public void setColorIndexFilePath(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisibleFlag()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingMAPGISNative.jni_SetColorIndexFilePath(this.getHandle(), value);
    }

    public boolean isImportNetworkTopology() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportNetworkTopology()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingMAPGISNative.jni_GetImportNetworkTopology(this.getHandle());
    }

    public void setImportNetworkTopology(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsCAD(boolean value)", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingMAPGISNative.jni_SetImportNetworkTopology(this.getHandle(), value);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingMAPGISNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }
}

