/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Colors;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetMosaicNative;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.MosaicSteppedEvent;
import com.supermap.data.MosaicSteppedListener;
import com.supermap.data.PixelFormat;
import com.supermap.data.PyramidResampleType;
import com.supermap.data.StatisticsResult;
import com.supermap.data.TiffCompressType;
import com.supermap.data.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class DatasetMosaic
extends Dataset {
    private Colors m_colors;
    private DatasetVector m_footprintDataset;
    private DatasetVector m_boundaryDataset;
    private DatasetVector m_clipDataset;
    protected static CopyOnWriteArrayList<MosaicSteppedListener> m_mosaicsteppedListeners;

    protected DatasetMosaic() {
    }

    DatasetMosaic(long handle, Datasource datasource) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("datasource", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle);
        this.m_datasource = datasource;
    }

    @Override
    protected void clearHandle() {
        if (this.m_footprintDataset != null) {
            this.m_footprintDataset.clearHandle();
            this.m_footprintDataset = null;
        }
        if (this.m_colors != null) {
            this.m_colors.clearHandle();
            this.m_colors = null;
        }
        if (this.m_boundaryDataset != null) {
            this.m_boundaryDataset.clearHandle();
            this.m_boundaryDataset = null;
        }
        if (this.m_clipDataset != null) {
            this.m_clipDataset.clearHandle();
            this.m_clipDataset = null;
        }
        this.setHandle(0L);
    }

    public synchronized void addMosaicSteppedListener(MosaicSteppedListener l) {
        if (m_mosaicsteppedListeners == null) {
            m_mosaicsteppedListeners = new CopyOnWriteArrayList();
        }
        if (!m_mosaicsteppedListeners.contains(l)) {
            m_mosaicsteppedListeners.add(l);
        }
    }

    public synchronized void removeMosaicSteppedListener(MosaicSteppedListener l) {
        if (m_mosaicsteppedListeners != null && m_mosaicsteppedListeners.contains(l)) {
            m_mosaicsteppedListeners.remove(l);
        }
    }

    protected static void fireStepped(MosaicSteppedEvent event) {
        if (m_mosaicsteppedListeners != null) {
            CopyOnWriteArrayList<MosaicSteppedListener> copyOnWriteArrayList = m_mosaicsteppedListeners;
            for (MosaicSteppedListener mosaicSteppedListener : copyOnWriteArrayList) {
                mosaicSteppedListener.mosaicStepped(event);
            }
        }
    }

    protected static void mosaicSteppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        Object object = new Object();
        boolean bl = Toolkit.getHandleBooleanValue(cancelHandle);
        MosaicSteppedEvent mosaicSteppedEvent = new MosaicSteppedEvent(object, title, message, percent, bl, remainTime);
        DatasetMosaic.fireStepped(mosaicSteppedEvent);
        Toolkit.setHandleBooleanValue(cancelHandle, mosaicSteppedEvent.getCancel());
        mosaicSteppedEvent = null;
    }

    public int getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetMosaicNative.jni_GetWidth(this.getHandle());
    }

    public int getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetMosaicNative.jni_GetHeight(this.getHandle());
    }

    public int getBandCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBandCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetMosaicNative.jni_GetBandCount(this.getHandle());
    }

    public PixelFormat getPixelFormat() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPixelFormat()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetMosaicNative.jni_GetPixelFormat(this.getHandle());
        return (PixelFormat)Enum.parseUGCValue(PixelFormat.class, n);
    }

    public DatasetVector getFootprintDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFootprintDataset()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_footprintDataset == null) {
            long l = DatasetMosaicNative.jni_GetFootprintDataset(this.getHandle());
            if (l == 0L) {
                return null;
            }
            this.m_footprintDataset = new DatasetVector(l, this.getDatasource());
        }
        return this.m_footprintDataset;
    }

    public DatasetVector getBoundaryDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBoundaryDataset()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_boundaryDataset == null) {
            long l = DatasetMosaicNative.jni_GetBoundaryDataset(this.getHandle());
            if (l == 0L) {
                return null;
            }
            this.m_boundaryDataset = new DatasetVector(l, this.getDatasource());
        }
        return this.m_boundaryDataset;
    }

    public DatasetVector getClipDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getClipDataset()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_clipDataset == null) {
            long l = DatasetMosaicNative.jni_GetClipDataset(this.getHandle());
            if (l == 0L) {
                return null;
            }
            this.m_clipDataset = new DatasetVector(l, this.getDatasource());
        }
        return this.m_clipDataset;
    }

    public boolean addFiles(String directoryPath, String extension, String clipFileExtension) {
        Object object;
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addFiles()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (directoryPath == null || directoryPath.trim().length() == 0) {
            String string = InternalResource.loadString("directoryPath", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (extension == null || directoryPath.trim().length() == 0) {
            String string = InternalResource.loadString("extension", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (clipFileExtension == null) {
            clipFileExtension = "";
        }
        if (!directoryPath.endsWith("/") && !directoryPath.endsWith("\\")) {
            directoryPath = directoryPath.indexOf(47) >= 0 ? directoryPath + "/" : directoryPath + "\\";
        }
        if ((n = extension.indexOf(46)) >= 0) {
            extension = extension.substring(n);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        File file = new File(directoryPath);
        if (file.isDirectory()) {
            object = null;
            for (File file2 : file.listFiles()) {
                object = file2.getName();
                if (!((String)object).endsWith(extension)) continue;
                object = directoryPath + (String)object;
                arrayList.add(object);
            }
        }
        if (arrayList.size() < 1) {
            object = InternalResource.loadString("extension", "Global_FileNotExists", "data_resources");
            throw new IllegalArgumentException((String)object);
        }
        object = new String[arrayList.size()];
        arrayList.toArray((T[])object);
        DatasetMosaicNative.jni_AddFiles1(this.getHandle(), (String[])object, clipFileExtension);
        return true;
    }

    public boolean addFiles(String[] directoryPaths, String clipFileExtension) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("noReturn");
        boolean bl = this.addFiles(directoryPaths, clipFileExtension, stringBuilder);
        return bl;
    }

    public String addFilesWithReport(String[] directoryPaths, String clipFileExtension) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = this.addFiles(directoryPaths, clipFileExtension, stringBuilder);
        return stringBuilder.toString();
    }

    private boolean addFiles(String[] directoryPaths, String clipFileExtension, StringBuilder stringBuilder) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addFiles()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = directoryPaths.length;
        if (n < 1) {
            String string = InternalResource.loadString("extension", "Global_FileNotExists", "data_resources");
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = new String[]{stringBuilder.toString()};
        int n2 = DatasetMosaicNative.jni_AddFilesWithReport(this.getHandle(), directoryPaths, clipFileExtension, stringArray);
        stringBuilder.delete(0, stringBuilder.length());
        stringBuilder.append(stringArray[0]);
        return n2 == 0;
    }

    public boolean buildOverview(String path, int maxWidth, int maxHeight, int ratio, Boolean hasNoValue, Double noValue) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildOverview()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (path == null || path.length() < 1) {
            String string = InternalResource.loadString("path", "Global_PathIsNotValid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (maxWidth <= 0) {
            String string = InternalResource.loadString("maxWidth", "DatasetGrid_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (maxHeight <= 0) {
            String string = InternalResource.loadString("maxHeight", "Argument_ShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (ratio <= 0) {
            String string = InternalResource.loadString("ratio", "Argument_ShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!(path = path.replace('\\', '/')).endsWith("/")) {
            path = path + "/";
        }
        return (n = DatasetMosaicNative.jni_BuildOverview(this.getHandle(), path, maxWidth, maxHeight, ratio, hasNoValue, noValue)) == 0;
    }

    public boolean buildStatistics() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildStatistics()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = DatasetMosaicNative.jni_BuildStatistics(this.getHandle());
        return n == 0;
    }

    public HashMap<Integer, StatisticsResult> getStatistics() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStatistics()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getBandCount();
        int[] nArray = new int[n];
        long[] lArray = new long[n];
        if (DatasetMosaicNative.jni_getStatistics(this.getHandle(), nArray, lArray)) {
            HashMap<Integer, StatisticsResult> hashMap = new HashMap<Integer, StatisticsResult>();
            for (int i = 0; i < n; ++i) {
                StatisticsResult statisticsResult = new StatisticsResult(lArray[i]);
                hashMap.put(nArray[i], statisticsResult);
            }
            InternalHandleDisposable.makeSureNativeObjectLive(hashMap);
            return hashMap;
        }
        return null;
    }

    public boolean buildPyramid(PyramidResampleType type, Boolean skipExists) {
        return this.buildPyramid(type, TiffCompressType.LZW, skipExists);
    }

    public boolean buildPyramid(PyramidResampleType type, TiffCompressType compressType, Boolean skipExists) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildPyramid()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (type == null) {
            String string = InternalResource.loadString("type", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (compressType == null) {
            String string = InternalResource.loadString("compressType", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return DatasetMosaicNative.jni_BuildPyramid(this.getHandle(), type.getUGCValue(), compressType.getUGCValue(), skipExists);
    }

    public boolean removePyramid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removePyramid()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetMosaicNative.jni_RemovePyramid(this.getHandle());
    }

    public int clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetMosaicNative.jni_Clear(this.getHandle());
    }

    public int removeOverview() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeOverview()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetMosaicNative.jni_RemoveOverview(this.getHandle());
    }

    public int rebuild(boolean isRebuildFootprint, boolean isRebuildBoundary, GeoRegion exRegion, boolean isRebuildClip, String postfix, boolean isAutoContour, boolean isExactClip, boolean isComplexShape, int tolerance, int clipPixelLength) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("rebuild", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (tolerance < 0) {
            String string = InternalResource.loadString("tolerance", "Argument_ShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (clipPixelLength < 0) {
            String string = InternalResource.loadString("clipPixelLength", "Argument_ShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        if (exRegion != null) {
            l = DatasetMosaic.getHandle(exRegion);
        }
        return DatasetMosaicNative.jni_Rebuild(this.getHandle(), isRebuildFootprint, isRebuildBoundary, l, isRebuildClip, postfix, isAutoContour, isExactClip, isComplexShape, tolerance, clipPixelLength);
    }

    @Deprecated
    public int rebuild(boolean isRebuildFootprint, boolean isRebuildBoundary, GeoRegion exRegion, boolean isRebuildClip, String postfix, boolean isAutoContour, boolean isExactClip) {
        return this.rebuild(isRebuildFootprint, isRebuildBoundary, exRegion, isRebuildClip, postfix, false, false, false, 0, 0);
    }

    @Deprecated
    public int rebuild(boolean isRebuildFootprint, boolean isRebuildBoundary, GeoRegion exRegion, boolean isRebuildClip, String postfix) {
        return this.rebuild(isRebuildFootprint, isRebuildBoundary, exRegion, isRebuildClip, postfix, false, false);
    }
}

