/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.InternalResource;
import com.supermap.data.LayoutAddedEvent;
import com.supermap.data.LayoutAddedListener;
import com.supermap.data.LayoutClearedEvent;
import com.supermap.data.LayoutClearedListener;
import com.supermap.data.LayoutClearingEvent;
import com.supermap.data.LayoutClearingListener;
import com.supermap.data.LayoutRemovedEvent;
import com.supermap.data.LayoutRemovedListener;
import com.supermap.data.LayoutRemovingEvent;
import com.supermap.data.LayoutRemovingListener;
import com.supermap.data.LayoutRenamedEvent;
import com.supermap.data.LayoutRenamedListener;
import com.supermap.data.LayoutRenamingEvent;
import com.supermap.data.LayoutRenamingListener;
import com.supermap.data.LayoutsNative;
import com.supermap.data.Workspace;
import java.util.concurrent.CopyOnWriteArrayList;

public class Layouts {
    private Workspace m_workspace;
    transient CopyOnWriteArrayList<LayoutRenamingListener> m_layoutRenamingListeners;
    transient CopyOnWriteArrayList<LayoutRenamedListener> m_layoutRenamedListeners;
    transient CopyOnWriteArrayList<LayoutRemovingListener> m_layoutRemovingListeners;
    transient CopyOnWriteArrayList<LayoutRemovedListener> m_layoutRemovedListeners;
    transient CopyOnWriteArrayList<LayoutAddedListener> m_layoutAddedListeners;
    transient CopyOnWriteArrayList<LayoutClearingListener> m_layoutClearingListeners;
    transient CopyOnWriteArrayList<LayoutClearedListener> m_layoutClearedListeners;

    Layouts(Workspace workspace) {
        this.m_workspace = workspace;
    }

    public int getCount() {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return LayoutsNative.jni_GetCount(this.m_workspace.getHandle());
    }

    public String get(int index) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return LayoutsNative.jni_GetItem(this.m_workspace.getHandle(), index);
    }

    public int add(String name, String xml) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if (this.indexOf(name) >= 0) {
            String string = InternalResource.loadString("name", "Layouts_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        n = LayoutsNative.jni_Add(this.m_workspace.getHandle(), name, xml);
        if (n > -1) {
            LayoutAddedEvent layoutAddedEvent = new LayoutAddedEvent(this, name);
            this.fireAdded(layoutAddedEvent);
        }
        return n;
    }

    public boolean insert(int index, String name, String xml) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index > this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if (this.indexOf(name) >= 0) {
            String string = InternalResource.loadString("name", "Layouts_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return LayoutsNative.jni_Insert(this.m_workspace.getHandle(), index, name, xml);
    }

    public boolean setLayoutXML(int index, String xml) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (xml == null) {
            xml = "";
        }
        return LayoutsNative.jni_SetLayoutXML(this.m_workspace.getHandle(), index, xml);
    }

    public boolean setLayoutXML(String name, String xml) {
        int n;
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (xml == null) {
            xml = "";
        }
        if ((n = this.indexOf(name)) == -1) {
            String string = InternalResource.loadString("name", "Layouts_NameIsNotInLayouts", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return this.setLayoutXML(n, xml);
    }

    public String getLayoutXML(int index) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return LayoutsNative.jni_GetLayoutXML(this.m_workspace.getHandle(), index);
    }

    public String getLayoutXML(String name) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null || name.trim().length() == 0) {
            String string = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.indexOf(name);
        if (n == -1) {
            String string = InternalResource.loadString("name", "Layouts_NameIsNotInLayouts", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return LayoutsNative.jni_GetLayoutXML(this.m_workspace.getHandle(), n);
    }

    public boolean remove(int index) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        String string = this.get(index);
        LayoutRemovingEvent layoutRemovingEvent = new LayoutRemovingEvent(this, string);
        this.fireRemoving(layoutRemovingEvent);
        if (layoutRemovingEvent.isCancel()) {
            return false;
        }
        boolean bl = false;
        bl = LayoutsNative.jni_Remove(this.m_workspace.getHandle(), index);
        if (bl) {
            LayoutRemovedEvent layoutRemovedEvent = new LayoutRemovedEvent(this, string);
            this.fireRemoved(layoutRemovedEvent);
        }
        return bl;
    }

    public boolean remove(String name) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        int n = this.indexOf(name);
        if (n != -1) {
            bl = this.remove(n);
        }
        return bl;
    }

    public void clear() {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        LayoutClearingEvent layoutClearingEvent = new LayoutClearingEvent(this);
        this.fireClearing(layoutClearingEvent);
        if (layoutClearingEvent.isCancel()) {
            return;
        }
        int n = this.getCount();
        LayoutsNative.jni_Clear(this.m_workspace.getHandle());
        LayoutClearedEvent layoutClearedEvent = new LayoutClearedEvent(this, n);
        this.fireCleared(layoutClearedEvent);
    }

    public int indexOf(String name) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (name != null && name.trim().length() != 0) {
            n = LayoutsNative.jni_IndexOf(this.m_workspace.getHandle(), name);
        }
        return n;
    }

    public String getAvailableLayoutName(String name) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (name == null) {
            name = "";
        }
        return LayoutsNative.jni_GetUnoccupiedLayoutName(this.m_workspace.getHandle(), name);
    }

    public boolean rename(String oldName, String newName) {
        if (this.m_workspace == null || this.m_workspace.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (oldName == null || oldName.trim().length() == 0) {
            String string = InternalResource.loadString("oldName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (newName == null || newName.trim().length() == 0) {
            String string = InternalResource.loadString("newName", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.indexOf(oldName) == -1) {
            String string = InternalResource.loadString("oldName", "Layouts_NameIsNotInLayouts", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (newName.equalsIgnoreCase(oldName)) {
            return false;
        }
        if (this.indexOf(newName) >= 0) {
            String string = InternalResource.loadString("newName", "Layouts_NameIsOcuupied", "data_resources");
            throw new IllegalArgumentException(string);
        }
        LayoutRenamingEvent layoutRenamingEvent = new LayoutRenamingEvent(this, oldName, newName);
        this.fireRenaming(layoutRenamingEvent);
        if (layoutRenamingEvent.isCancel()) {
            return false;
        }
        boolean bl = false;
        bl = LayoutsNative.jni_Rename(this.m_workspace.getHandle(), oldName, newName);
        if (bl) {
            LayoutRenamedEvent layoutRenamedEvent = new LayoutRenamedEvent(this, oldName, newName);
            this.fireRenamed(layoutRenamedEvent);
        }
        return bl;
    }

    protected void clearHandle() {
        this.m_workspace = null;
    }

    public synchronized void addRenamingListener(LayoutRenamingListener l) {
        if (this.m_layoutRenamingListeners == null) {
            this.m_layoutRenamingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_layoutRenamingListeners.contains(l)) {
            this.m_layoutRenamingListeners.add(l);
        }
    }

    public void removeRenamingListener(LayoutRenamingListener l) {
        if (this.m_layoutRenamingListeners != null && this.m_layoutRenamingListeners.contains(l)) {
            this.m_layoutRenamingListeners.remove(l);
        }
    }

    protected void fireRenaming(LayoutRenamingEvent event) {
        if (this.m_layoutRenamingListeners != null) {
            CopyOnWriteArrayList<LayoutRenamingListener> copyOnWriteArrayList = this.m_layoutRenamingListeners;
            for (LayoutRenamingListener layoutRenamingListener : copyOnWriteArrayList) {
                layoutRenamingListener.layoutRenaming(event);
            }
        }
    }

    public synchronized void addRenamedListener(LayoutRenamedListener l) {
        if (this.m_layoutRenamedListeners == null) {
            this.m_layoutRenamedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_layoutRenamedListeners.contains(l)) {
            this.m_layoutRenamedListeners.add(l);
        }
    }

    public void removeRenamedListener(LayoutRenamedListener l) {
        if (this.m_layoutRenamedListeners != null && this.m_layoutRenamedListeners.contains(l)) {
            this.m_layoutRenamedListeners.remove(l);
        }
    }

    protected void fireRenamed(LayoutRenamedEvent event) {
        if (this.m_layoutRenamedListeners != null) {
            CopyOnWriteArrayList<LayoutRenamedListener> copyOnWriteArrayList = this.m_layoutRenamedListeners;
            for (LayoutRenamedListener layoutRenamedListener : copyOnWriteArrayList) {
                layoutRenamedListener.layoutRenamed(event);
            }
        }
    }

    public synchronized void addRemovingListener(LayoutRemovingListener l) {
        if (this.m_layoutRemovingListeners == null) {
            this.m_layoutRemovingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_layoutRemovingListeners.contains(l)) {
            this.m_layoutRemovingListeners.add(l);
        }
    }

    public void removeRemovingListener(LayoutRemovingListener l) {
        if (this.m_layoutRemovingListeners != null && this.m_layoutRemovingListeners.contains(l)) {
            this.m_layoutRemovingListeners.remove(l);
        }
    }

    protected void fireRemoving(LayoutRemovingEvent event) {
        if (this.m_layoutRemovingListeners != null) {
            CopyOnWriteArrayList<LayoutRemovingListener> copyOnWriteArrayList = this.m_layoutRemovingListeners;
            for (LayoutRemovingListener layoutRemovingListener : copyOnWriteArrayList) {
                layoutRemovingListener.layoutRemoving(event);
            }
        }
    }

    public synchronized void addRemovedListener(LayoutRemovedListener l) {
        if (this.m_layoutRemovedListeners == null) {
            this.m_layoutRemovedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_layoutRemovedListeners.contains(l)) {
            this.m_layoutRemovedListeners.add(l);
        }
    }

    public void removeRemovedListener(LayoutRemovedListener l) {
        if (this.m_layoutRemovedListeners != null && this.m_layoutRemovedListeners.contains(l)) {
            this.m_layoutRemovedListeners.remove(l);
        }
    }

    protected void fireRemoved(LayoutRemovedEvent event) {
        if (this.m_layoutRemovedListeners != null) {
            CopyOnWriteArrayList<LayoutRemovedListener> copyOnWriteArrayList = this.m_layoutRemovedListeners;
            for (LayoutRemovedListener layoutRemovedListener : copyOnWriteArrayList) {
                layoutRemovedListener.layoutRemoved(event);
            }
        }
    }

    public synchronized void addAddedListener(LayoutAddedListener l) {
        if (this.m_layoutAddedListeners == null) {
            this.m_layoutAddedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_layoutAddedListeners.contains(l)) {
            this.m_layoutAddedListeners.add(l);
        }
    }

    public void removeAddedListener(LayoutAddedListener l) {
        if (this.m_layoutAddedListeners != null && this.m_layoutAddedListeners.contains(l)) {
            this.m_layoutAddedListeners.remove(l);
        }
    }

    protected void fireAdded(LayoutAddedEvent event) {
        if (this.m_layoutAddedListeners != null) {
            CopyOnWriteArrayList<LayoutAddedListener> copyOnWriteArrayList = this.m_layoutAddedListeners;
            for (LayoutAddedListener layoutAddedListener : copyOnWriteArrayList) {
                layoutAddedListener.layoutAdded(event);
            }
        }
    }

    public synchronized void addClearingListener(LayoutClearingListener l) {
        if (this.m_layoutClearingListeners == null) {
            this.m_layoutClearingListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_layoutClearingListeners.contains(l)) {
            this.m_layoutClearingListeners.add(l);
        }
    }

    public void removeClearingListener(LayoutClearingListener l) {
        if (this.m_layoutClearingListeners != null && this.m_layoutClearingListeners.contains(l)) {
            this.m_layoutClearingListeners.remove(l);
        }
    }

    protected void fireClearing(LayoutClearingEvent event) {
        if (this.m_layoutClearingListeners != null) {
            CopyOnWriteArrayList<LayoutClearingListener> copyOnWriteArrayList = this.m_layoutClearingListeners;
            for (LayoutClearingListener layoutClearingListener : copyOnWriteArrayList) {
                layoutClearingListener.layoutClearing(event);
            }
        }
    }

    public synchronized void addClearedListener(LayoutClearedListener l) {
        if (this.m_layoutClearedListeners == null) {
            this.m_layoutClearedListeners = new CopyOnWriteArrayList();
        }
        if (!this.m_layoutClearedListeners.contains(l)) {
            this.m_layoutClearedListeners.add(l);
        }
    }

    public void removeClearedListener(LayoutClearedListener l) {
        if (this.m_layoutClearedListeners != null && this.m_layoutClearedListeners.contains(l)) {
            this.m_layoutClearedListeners.remove(l);
        }
    }

    protected void fireCleared(LayoutClearedEvent event) {
        if (this.m_layoutClearedListeners != null) {
            CopyOnWriteArrayList<LayoutClearedListener> copyOnWriteArrayList = this.m_layoutClearedListeners;
            for (LayoutClearedListener layoutClearedListener : copyOnWriteArrayList) {
                layoutClearedListener.layoutCleared(event);
            }
        }
    }
}

