/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.GroupMode;
import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.TransportationAnalystParameterNative;
import com.supermap.data.Point2Ds;

public class GroupAnalystParameter
extends InternalHandleDisposable {
    private String m_weightName = "";
    private int[] m_barrierNodes = null;
    private int[] m_barrierEdges = null;
    private Point2Ds m_barrierPoints = null;
    private String m_turnWeightField = "";
    private Point2Ds m_points = null;
    private boolean m_bAlongRoad = false;
    private GroupMode m_groupMode = GroupMode.MINGROUPS;

    public GroupAnalystParameter() {
        long l = TransportationAnalystParameterNative.jni_New();
        this.setHandle(l, true);
    }

    public GroupAnalystParameter(GroupAnalystParameter analystParameter) {
        long l = TransportationAnalystParameterNative.jni_New();
        this.setHandle(l, true);
        this.copyFrom(analystParameter);
    }

    void copyFrom(GroupAnalystParameter value) {
        if (value != null) {
            this.setWeightName(value.getWeightName());
            this.setBarrierNodes(value.getBarrierNodes());
            this.setBarrierEdges(value.getBarrierEdges());
            this.setBarrierPoints(value.getBarrierPoints());
            this.setTurnWeightField(value.getTurnWeightField());
        }
    }

    protected long getHandle() {
        long l = super.getHandle();
        if (l != 0L) {
            int n;
            double[] dArray;
            double[] dArray2;
            int n2;
            if (this.m_points != null && this.m_points.getCount() != 0) {
                n2 = this.m_points.getCount();
                dArray2 = new double[n2];
                dArray = new double[n2];
                for (n = 0; n < n2; ++n) {
                    dArray2[n] = this.m_points.getItem(n).getX();
                    dArray[n] = this.m_points.getItem(n).getY();
                }
                TransportationAnalystParameterNative.jni_SetPoints(l, dArray2, dArray);
            }
            TransportationAnalystParameterNative.jni_SetWeightName(l, this.m_weightName);
            if (this.m_barrierNodes != null) {
                TransportationAnalystParameterNative.jni_SetBarrierNodes(l, this.m_barrierNodes);
            } else {
                TransportationAnalystParameterNative.jni_SetBarrierNodes(l, new int[0]);
            }
            if (this.m_barrierEdges != null) {
                TransportationAnalystParameterNative.jni_SetBarrierEdges(l, this.m_barrierEdges);
            } else {
                TransportationAnalystParameterNative.jni_SetBarrierEdges(l, new int[0]);
            }
            if (this.m_barrierPoints != null && this.m_barrierPoints.getCount() != 0) {
                n2 = this.m_barrierPoints.getCount();
                dArray2 = new double[n2];
                dArray = new double[n2];
                for (n = 0; n < n2; ++n) {
                    dArray2[n] = this.m_barrierPoints.getItem(n).getX();
                    dArray[n] = this.m_barrierPoints.getItem(n).getY();
                }
                TransportationAnalystParameterNative.jni_SetBarrierPoints(l, dArray2, dArray);
            }
            TransportationAnalystParameterNative.jni_SetTurnWeightField(l, this.m_turnWeightField);
        }
        return l;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            TransportationAnalystParameterNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    public Point2Ds getPoints() {
        if (this.m_points != null) {
            return this.m_points.clone();
        }
        return null;
    }

    public void setPoints(Point2Ds value) {
        if (value == null) {
            this.m_points = null;
        } else {
            if (this.m_points == null) {
                this.m_points = new Point2Ds();
            }
            this.m_points.clear();
            this.m_points.addRange(value.toArray());
        }
    }

    public String getWeightName() {
        return this.m_weightName;
    }

    public void setWeightName(String value) {
        this.m_weightName = value;
    }

    public int[] getBarrierNodes() {
        if (this.m_barrierNodes != null) {
            return this.m_barrierNodes;
        }
        return null;
    }

    public void setBarrierNodes(int[] value) {
        if (value == null) {
            this.m_barrierNodes = null;
        } else {
            int n = value.length;
            this.m_barrierNodes = new int[n];
            for (int i = 0; i < n; ++i) {
                this.m_barrierNodes[i] = value[i];
            }
        }
    }

    public int[] getBarrierEdges() {
        if (this.m_barrierEdges != null) {
            return (int[])this.m_barrierEdges.clone();
        }
        return null;
    }

    public Point2Ds getBarrierPoints() {
        if (this.m_barrierPoints != null) {
            return this.m_barrierPoints.clone();
        }
        return null;
    }

    public void setBarrierPoints(Point2Ds value) {
        if (value == null) {
            this.m_barrierPoints = null;
        } else {
            if (this.m_barrierPoints == null) {
                this.m_barrierPoints = new Point2Ds();
            }
            this.m_barrierPoints.clear();
            this.m_barrierPoints.addRange(value.toArray());
        }
    }

    public void setBarrierEdges(int[] value) {
        if (value == null) {
            this.m_barrierEdges = null;
        } else {
            int n = value.length;
            this.m_barrierEdges = new int[n];
            for (int i = 0; i < n; ++i) {
                this.m_barrierEdges[i] = value[i];
            }
        }
    }

    public String getTurnWeightField() {
        return this.m_turnWeightField;
    }

    public void setTurnWeightField(String value) {
        this.m_turnWeightField = value;
    }

    public void setAlongRoad(boolean value) {
        this.m_bAlongRoad = value;
    }

    public boolean isAlongRoad() {
        return this.m_bAlongRoad;
    }

    void setGroupMode(GroupMode value) {
        this.m_groupMode = value;
    }

    GroupMode getGroupMode() {
        return this.m_groupMode;
    }
}

