/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.InternalGeometry;
import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.PathGuide;
import com.supermap.analyst.networkanalyst.TransportationAnalystResultNative;
import com.supermap.data.GeoLineM;
import java.util.Calendar;
import java.util.Date;

public class VRPAnalystResult
extends InternalHandleDisposable {
    private GeoLineM[] m_routes = null;
    private int[][] m_nodes = null;
    private int[][] m_edges = null;
    private int[][] m_stops = null;
    private PathGuide[] m_pathGuides = null;
    private double[] m_weights = null;
    private double[] m_demandValues = null;
    private double[][] m_stopWeights = null;
    private Date[][] m_times = null;
    private double[][] m_vrpDemand = null;
    private int[] m_indexs = null;

    VRPAnalystResult(long handle) {
        this.setHandle(handle, true);
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            TransportationAnalystResultNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    public GeoLineM[] getRoutes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRoutes()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_routes == null) {
            int n = TransportationAnalystResultNative.jni_GetRouteCount(this.getHandle());
            if (n > 0) {
                long[] lArray = new long[n];
                TransportationAnalystResultNative.jni_GetRouteHandles(this.getHandle(), lArray);
                this.m_routes = new GeoLineM[n];
                for (int i = 0; i < n; ++i) {
                    if (lArray[i] == 0L) continue;
                    this.m_routes[i] = (GeoLineM)InternalGeometry.createInstance(lArray[i]);
                    InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)this.m_routes[i], false);
                }
            } else {
                this.m_routes = new GeoLineM[0];
            }
        }
        return this.m_routes;
    }

    public int[][] getNodes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNodes()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_nodes == null) {
            int n = TransportationAnalystResultNative.jni_GetNodeCount(this.getHandle());
            if (n > 0) {
                this.m_nodes = new int[n][];
                int[] nArray = new int[n];
                TransportationAnalystResultNative.jni_GetNodeCounts(this.getHandle(), nArray);
                for (int i = 0; i < n; ++i) {
                    this.m_nodes[i] = new int[nArray[i]];
                }
                TransportationAnalystResultNative.jni_GetNodes(this.getHandle(), this.m_nodes);
            } else {
                this.m_nodes = new int[0][0];
            }
        }
        return this.m_nodes;
    }

    public int[][] getEdges() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEdges()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_edges == null) {
            int n = TransportationAnalystResultNative.jni_GetEdgeCount(this.getHandle());
            if (n > 0) {
                this.m_edges = new int[n][];
                int[] nArray = new int[n];
                TransportationAnalystResultNative.jni_GetEdgeCounts(this.getHandle(), nArray);
                for (int i = 0; i < n; ++i) {
                    this.m_edges[i] = new int[nArray[i]];
                }
                TransportationAnalystResultNative.jni_GetEdges(this.getHandle(), this.m_edges);
            } else {
                this.m_edges = new int[0][0];
            }
        }
        return this.m_edges;
    }

    public int[][] getStopIndexes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStops()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_stops == null) {
            int n = TransportationAnalystResultNative.jni_GetStopCount(this.getHandle());
            if (n > 0) {
                this.m_stops = new int[n][];
                int[] nArray = new int[n];
                TransportationAnalystResultNative.jni_GetStopCounts(this.getHandle(), nArray);
                for (int i = 0; i < n; ++i) {
                    this.m_stops[i] = new int[nArray[i]];
                }
                TransportationAnalystResultNative.jni_GetStops(this.getHandle(), this.m_stops);
            } else {
                this.m_stops = new int[0][0];
            }
        }
        return this.m_stops;
    }

    public double[][] getStopWeights() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStopWeights()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_stopWeights == null) {
            this.m_stopWeights = TransportationAnalystResultNative.jni_GetStopWeights(this.getHandle());
        }
        return this.m_stopWeights;
    }

    public PathGuide[] getPathGuides() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPathGuides()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_pathGuides == null) {
            int n = TransportationAnalystResultNative.jni_GetPathGuideCount(this.getHandle());
            if (n > 0) {
                long[] lArray = new long[n];
                TransportationAnalystResultNative.jni_GetPathGuideHandles(this.getHandle(), lArray);
                this.m_pathGuides = new PathGuide[n];
                for (int i = 0; i < n; ++i) {
                    this.m_pathGuides[i] = new PathGuide(lArray[i]);
                }
            } else {
                this.m_pathGuides = new PathGuide[0];
            }
        }
        return this.m_pathGuides;
    }

    public double[] getWeights() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWeights()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_weights == null) {
            int n = TransportationAnalystResultNative.jni_GetWeightCount(this.getHandle());
            if (n > 0) {
                this.m_weights = new double[n];
                TransportationAnalystResultNative.jni_GetWeights(this.getHandle(), this.m_weights);
            } else {
                this.m_weights = new double[0];
            }
        }
        return this.m_weights;
    }

    public Date[][] getTimes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTimes()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_times == null) {
            int n = TransportationAnalystResultNative.jni_GetStopCount(this.getHandle());
            if (n > 0) {
                int n2;
                double[][] dArrayArray = new double[n][];
                int[] nArray = new int[n];
                TransportationAnalystResultNative.jni_GetTimeCounts(this.getHandle(), nArray);
                for (n2 = 0; n2 < n; ++n2) {
                    dArrayArray[n2] = new double[nArray[n2]];
                }
                TransportationAnalystResultNative.jni_GetTimes(this.getHandle(), dArrayArray);
                this.m_times = new Date[n][];
                for (n2 = 0; n2 < dArrayArray.length; ++n2) {
                    this.m_times[n2] = new Date[nArray[n2]];
                    for (int i = 0; i < this.m_times[n2].length; ++i) {
                        int n3 = (int)(dArrayArray[n2][i] / 60.0);
                        int n4 = (int)(dArrayArray[n2][i] % 60.0);
                        double d = dArrayArray[n2][i] - (double)(n3 * 60 + n4);
                        int n5 = (int)(d * 60.0);
                        Calendar calendar = Calendar.getInstance();
                        calendar.set(11, n3);
                        calendar.set(12, n4);
                        calendar.set(13, n5);
                        this.m_times[n2][i] = calendar.getTime();
                    }
                }
            } else {
                return null;
            }
        }
        return this.m_times;
    }

    public double[][] getVRPDemandValues() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVRPDemandValue()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_vrpDemand == null) {
            int n = TransportationAnalystResultNative.jni_GetVRPRouteCount(this.getHandle());
            if (n > 0) {
                int n2 = TransportationAnalystResultNative.jni_GetDemandCount(this.getHandle());
                if (n2 > 0) {
                    this.m_vrpDemand = new double[n][];
                    for (int i = 0; i < n; ++i) {
                        this.m_vrpDemand[i] = new double[n2];
                    }
                    TransportationAnalystResultNative.jni_GetDemandNodes(this.getHandle(), this.m_vrpDemand);
                } else {
                    this.m_vrpDemand = new double[0][0];
                }
            } else {
                this.m_vrpDemand = new double[0][0];
            }
        }
        return this.m_vrpDemand;
    }

    public int[] getVehicleIndexs() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIDs()", "Handle_ObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_indexs == null) {
            int n = TransportationAnalystResultNative.jni_GetVRPRouteCount(this.getHandle());
            if (n > 0) {
                this.m_indexs = new int[n];
                TransportationAnalystResultNative.jni_GetVRPRouteIDs(this.getHandle(), this.m_indexs);
            } else {
                this.m_indexs = new int[0];
            }
        }
        return this.m_indexs;
    }
}

