/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.FacilityAnalystSetting;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.TransportationAnalystSetting;
import com.supermap.analyst.networkanalyst.WeightFieldInfo;
import java.util.ArrayList;

public class WeightFieldInfos {
    private ArrayList m_weightFields = new ArrayList();
    private TransportationAnalystSetting m_owner = null;
    private FacilityAnalystSetting m_owner2 = null;

    public WeightFieldInfos() {
    }

    void setOwner(TransportationAnalystSetting value) {
        this.m_owner = value;
    }

    void setOwnerNeedSetTrue() {
        if (this.m_owner != null) {
            this.m_owner.setNeedSet(true);
            this.m_owner.setNeedLoadModel(true);
        }
    }

    void copyFrom(WeightFieldInfos weightFieldInfos) {
        if (weightFieldInfos != null && !this.equals(weightFieldInfos)) {
            this.clear();
            int n = weightFieldInfos.getCount();
            for (int i = 0; i < n; ++i) {
                this.add(weightFieldInfos.get(i));
            }
            this.setOwnerNeedSetTrue();
        }
    }

    public WeightFieldInfos(WeightFieldInfos weightFieldInfos) {
        if (weightFieldInfos != null && !this.equals(weightFieldInfos)) {
            this.clear();
            int n = weightFieldInfos.getCount();
            for (int i = 0; i < n; ++i) {
                this.add(weightFieldInfos.get(i));
            }
            this.setOwnerNeedSetTrue();
        }
    }

    public void clear() {
        this.m_weightFields.clear();
        this.setOwnerNeedSetTrue();
    }

    public int add(WeightFieldInfo value) {
        int n = -1;
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (this.indexOf(value.getName()) >= 0) {
            String string = InternalResource.loadString("value.getName()", "Global_SpecifiedNameAlreadyExist", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_weightFields.add(value);
        n = this.getCount() - 1;
        value.setOwner(this);
        this.setOwnerNeedSetTrue();
        return n;
    }

    public boolean remove(String value) {
        boolean bl = false;
        int n = this.indexOf(value);
        if (n > -1) {
            bl = this.remove(n);
        }
        return bl;
    }

    public boolean remove(int index) {
        boolean bl = false;
        this.m_weightFields.remove(index);
        this.setOwnerNeedSetTrue();
        bl = true;
        return bl;
    }

    public int indexOf(String name) {
        int n = -1;
        if (name != null && name.trim().length() != 0) {
            int n2 = this.getCount();
            for (int i = 0; i < n2; ++i) {
                WeightFieldInfo weightFieldInfo = this.get(i);
                if (!name.equalsIgnoreCase(weightFieldInfo.getName())) continue;
                return i;
            }
        }
        return n;
    }

    public int getCount() {
        return this.m_weightFields.size();
    }

    public WeightFieldInfo get(int value) {
        return (WeightFieldInfo)this.m_weightFields.get(value);
    }

    public WeightFieldInfo get(String value) {
        WeightFieldInfo weightFieldInfo = null;
        int n = this.indexOf(value);
        if (n > -1) {
            weightFieldInfo = this.get(n);
        }
        return weightFieldInfo;
    }

    void setOwner2(FacilityAnalystSetting value) {
        this.m_owner2 = value;
    }
}

