/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.trafficanalyst;

import com.supermap.analyst.trafficanalyst.InternalResource;
import com.supermap.analyst.trafficanalyst.RelationSetting;
import com.supermap.analyst.trafficanalyst.RelationSettingsNative;
import com.supermap.data.Datasource;
import java.util.ArrayList;

class RelationSettings {
    private ArrayList<RelationSetting> m_settings = new ArrayList();

    public RelationSettings() {
    }

    public RelationSettings(RelationSettings relationSettings) {
        RelationSetting[] relationSettingArray = relationSettings.toArray();
        this.addRange(relationSettingArray);
    }

    public int getCount() {
        return this.m_settings.size();
    }

    public RelationSetting get(int index) {
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.m_settings.get(index);
    }

    public void set(int index, RelationSetting transferRelationSetting) {
        if (transferRelationSetting == null) {
            String string = InternalResource.loadString("transferRelationSetting", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        this.m_settings.set(index, transferRelationSetting);
    }

    public int add(RelationSetting transferRelationSetting) {
        if (transferRelationSetting == null) {
            String string = InternalResource.loadString("transferRelationSetting", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this.m_settings.add(transferRelationSetting);
        return this.m_settings.size();
    }

    public int addRange(RelationSetting[] transferRelationSettings) {
        int n;
        if (transferRelationSettings == null) {
            String string = InternalResource.loadString("transferRelationSettings", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        boolean bl = false;
        for (n = 0; n < transferRelationSettings.length; ++n) {
            if (transferRelationSettings[n] != null) continue;
            bl = true;
            break;
        }
        if (bl) {
            String string = InternalResource.loadString("transferRelationSettings", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        for (n = 0; n < transferRelationSettings.length; ++n) {
            this.m_settings.add(transferRelationSettings[n]);
        }
        return transferRelationSettings.length;
    }

    public boolean remove(int index) {
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        this.m_settings.remove(index);
        return true;
    }

    public int removeRange(int index, int count) {
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n = index + count;
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index+count", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        for (int i = n - 1; i >= index; --i) {
            this.m_settings.remove(i);
        }
        return count;
    }

    public void clear() {
        this.m_settings.clear();
    }

    public RelationSetting[] toArray() {
        int n = this.m_settings.size();
        RelationSetting[] relationSettingArray = new RelationSetting[n];
        for (int i = 0; i < relationSettingArray.length; ++i) {
            relationSettingArray[i] = new RelationSetting(this.m_settings.get(i));
        }
        return relationSettingArray;
    }

    long setRelationToUGC() {
        int n = this.m_settings.size();
        long l = RelationSettingsNative.jni_RelationNew();
        for (int i = 0; i < n; ++i) {
            this.m_settings.get(i).setRelationToUGC(l);
        }
        return l;
    }

    long setStopExitToUGC() {
        int n = this.m_settings.size();
        long l = RelationSettingsNative.jni_StopAndExitNew();
        for (int i = 0; i < n; ++i) {
            this.m_settings.get(i).setStopExitToUGC(l);
        }
        return l;
    }

    long setNetworkToUGC() {
        int n = this.m_settings.size();
        long l = RelationSettingsNative.jni_NetworkNew();
        for (int i = 0; i < n; ++i) {
            this.m_settings.get(i).setNetworkToUGC(l);
        }
        return l;
    }

    void getRelationFromUGC(Datasource ds, long handle) {
        long[] lArray = RelationSettingsNative.jni_GetRelationHandls(handle);
        this.m_settings = new ArrayList();
        for (int i = 0; i < lArray.length; ++i) {
            RelationSetting relationSetting = new RelationSetting();
            relationSetting.getRelationFromUGC(ds, lArray[i]);
            this.m_settings.add(relationSetting);
        }
    }

    void getStopExitFromUGC(Datasource ds, long handle) {
        long[] lArray = RelationSettingsNative.jni_GetStopAndExitHandls(handle);
        this.m_settings = new ArrayList();
        for (int i = 0; i < lArray.length; ++i) {
            RelationSetting relationSetting = new RelationSetting();
            relationSetting.getStopExitFromUGC(ds, lArray[i]);
            this.m_settings.add(relationSetting);
        }
    }

    void getNetworkFromUGC(Datasource ds, long handle) {
        long[] lArray = RelationSettingsNative.jni_GetNetworkHandls(handle);
        this.m_settings = new ArrayList();
        for (int i = 0; i < lArray.length; ++i) {
            RelationSetting relationSetting = new RelationSetting();
            relationSetting.getNetworkFromUGC(ds, lArray[i]);
            this.m_settings.add(relationSetting);
        }
    }
}

