/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.processing.ClassificationInfos;
import com.supermap.data.processing.ClassificationOperatorNative;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalResource;

public class ClassificationOperator
extends InternalHandleDisposable {
    public ClassificationOperator() {
        long l = ClassificationOperatorNative.jni_New();
        this.setHandle(l, true);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ClassificationOperatorNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public static ClassificationInfos extractInfos(String strFileName) {
        if ("".equals(strFileName)) {
            String string = InternalResource.loadString("strFileName", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ClassificationOperatorNative.jni_ExtractInfos(strFileName);
        double[] dArray = ClassificationOperatorNative.jni_GetArrVertices(l);
        double[] dArray2 = ClassificationOperatorNative.jni_GetArrNormals(l);
        int[] nArray = ClassificationOperatorNative.jni_GetLables(l);
        return new ClassificationInfos(dArray, dArray2, nArray);
    }

    public static ClassificationInfos generateTrainingSet(String filePathName) {
        if ("".equals(filePathName)) {
            String string = InternalResource.loadString("filePathName", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ClassificationOperatorNative.jni_GenerateTrainingSet(filePathName);
        double[] dArray = ClassificationOperatorNative.jni_GetArrVertices(l);
        double[] dArray2 = ClassificationOperatorNative.jni_GetArrNormals(l);
        int[] nArray = ClassificationOperatorNative.jni_GetLables(l);
        return new ClassificationInfos(dArray, dArray2, nArray);
    }

    public static void addLabelsToS3MFile(String osgbFilePath, String outputFolder, int[] labelsArray) {
        if ("".equals(outputFolder)) {
            String string = InternalResource.loadString("outputFolder", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if ("".equals(osgbFilePath)) {
            String string = InternalResource.loadString("osgbFilePath", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (labelsArray.length == 0) {
            String string = InternalResource.loadString("labelsArray.leng = 0", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        ClassificationOperatorNative.jni_AddLabelsToS3MFile(osgbFilePath, outputFolder, labelsArray);
    }
}

