/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing.cache;

import com.supermap.data.CursorType;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.EngineType;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldType;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Workspace;
import com.supermap.data.processing.CacheWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class TaskTileBuilder {
    public static final int BundleSize = 128;

    public static void main(String[] args) throws Exception {
        boolean bl;
        File file;
        Object object;
        Object object2;
        Object object3;
        File file2;
        if (args.length < 2) {
            System.out.println("input style: sciFile targetFolder listCount[option]");
            return;
        }
        String string = args[0];
        String string2 = args[1] + "/task";
        int n = 1;
        if (args.length > 2) {
            n = Integer.valueOf(args[2]);
        }
        int n2 = 2;
        if (args.length > 3) {
            n2 = Integer.valueOf(args[3]);
        }
        String string3 = "";
        if (args.length > 4) {
            string3 = args[4];
        }
        if (!(file2 = new File(string)).exists()) {
            System.out.println(string + " not exist!");
            return;
        }
        Workspace workspace = null;
        Datasource datasource = null;
        if (n2 > 0) {
            object3 = "cache";
            object2 = args[1] + "/udb/" + (String)object3 + ".udb";
            object = new File((String)object2);
            if (((File)object).exists()) {
                System.out.println((String)object2 + " is exists!");
                return;
            }
            ((File)object).getParentFile().mkdirs();
            file = new DatasourceConnectionInfo();
            file.setServer((String)object2);
            file.setAlias((String)object3);
            file.setEngineType(EngineType.UDB);
            workspace = new Workspace();
            datasource = workspace.getDatasources().create((DatasourceConnectionInfo)file);
        }
        object3 = new CacheWriter();
        ((CacheWriter)object3).FromConfigFile(string);
        object2 = new File(string2);
        if (!((File)object2).exists()) {
            ((File)object2).mkdirs();
        }
        object = string2 + "/allTask.list";
        file = new File((String)object);
        OutputStreamWriter outputStreamWriter = null;
        if (!file.exists() && !(bl = file.createNewFile())) {
            System.out.println("create Failed!");
        }
        outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        HashMap<Double, String> hashMap = new HashMap<Double, String>(((CacheWriter)object3).getCacheScaleCaptions());
        Rectangle2D rectangle2D = ((CacheWriter)object3).getCacheBounds();
        Rectangle2D rectangle2D2 = ((CacheWriter)object3).getIndexBounds();
        Set<Double> set = hashMap.keySet();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.addAll(set);
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n3;
            double d;
            int n4;
            double d2 = (Double)iterator.next();
            double d3 = ((CacheWriter)object3).getTileResolustion(d2);
            HashMap<Double, String> hashMap2 = new HashMap<Double, String>();
            String string4 = hashMap.get(d2);
            hashMap2.put(d2, string4);
            ((CacheWriter)object3).setCacheScaleCaptions(hashMap2);
            Recordset recordset = null;
            Recordset.BatchEditor batchEditor = null;
            if (n2 > 0) {
                String string5 = "L" + string4 + "_S" + Math.round(1.0 / d2);
                DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo(string5, DatasetType.REGION);
                DatasetVector datasetVector = datasource.getDatasets().create(datasetVectorInfo);
                FieldInfo fieldInfo = new FieldInfo("tiletype", FieldType.INT32);
                FieldInfo fieldInfo2 = new FieldInfo("tilerow", FieldType.INT32);
                FieldInfo fieldInfo3 = new FieldInfo("tilecol", FieldType.INT32);
                FieldInfo fieldInfo4 = new FieldInfo("errortype", FieldType.INT32);
                FieldInfo fieldInfo5 = new FieldInfo("errordesc", FieldType.TEXT);
                datasetVector.getFieldInfos().add(fieldInfo);
                datasetVector.getFieldInfos().add(fieldInfo2);
                datasetVector.getFieldInfos().add(fieldInfo3);
                datasetVector.getFieldInfos().add(fieldInfo4);
                datasetVector.getFieldInfos().add(fieldInfo5);
                recordset = datasetVector.getRecordset(false, CursorType.DYNAMIC);
                batchEditor = recordset.getBatch();
                batchEditor.setMaxRecordCount(100);
                batchEditor.begin();
            }
            double d4 = d3 / (double)((CacheWriter)object3).getTileSize().value();
            double d5 = (rectangle2D.getLeft() - rectangle2D2.getLeft()) / d3 + 1.0E-8;
            int n5 = (int)Math.floor(d5);
            double d6 = -(rectangle2D.getTop() - rectangle2D2.getTop()) / d3 + 1.0E-8;
            int n6 = (int)Math.floor(d6);
            double d7 = (rectangle2D.getRight() - rectangle2D2.getLeft()) / d3 + 1.0E-8;
            if (d7 - (double)(n4 = (int)Math.floor(d7)) < d4) {
                --n4;
            }
            if ((d = -(rectangle2D.getBottom() - rectangle2D2.getTop()) / d3 + 1.0E-8) - (double)(n3 = (int)Math.floor(d)) < d4) {
                --n3;
            }
            int n7 = n6;
            while (n7 <= n3) {
                int n8 = n7;
                int n9 = n7;
                int n10 = n5;
                while (n10 <= n4) {
                    int n11 = n10;
                    int n12 = n10;
                    double d8 = rectangle2D2.getLeft() + (double)n10 * d3;
                    double d9 = rectangle2D2.getLeft() + (double)(n12 + 1) * d3;
                    double d10 = rectangle2D2.getTop() - (double)n7 * d3;
                    double d11 = rectangle2D2.getTop() - (double)(n9 + 1) * d3;
                    if (d9 - d8 > d4 && Math.abs(d11 - d10) > d4) {
                        String string6;
                        Point2Ds point2Ds;
                        if (n2 < 2) {
                            point2Ds = new Rectangle2D(d8, d11, d9, d10);
                            ((CacheWriter)object3).setCacheBounds((Rectangle2D)point2Ds);
                            string6 = String.format("%s/L%s_R%d_C%d.sci", string2, string4, n8, n11);
                            TaskTileBuilder.wirteOneSci((CacheWriter)object3, string6, outputStreamWriter);
                        }
                        if (n2 > 0) {
                            point2Ds = new Point2Ds();
                            point2Ds.add(new Point2D(d8, d11));
                            point2Ds.add(new Point2D(d8, d10));
                            point2Ds.add(new Point2D(d9, d10));
                            point2Ds.add(new Point2D(d9, d11));
                            string6 = new GeoRegion(point2Ds);
                            HashMap<String, Integer> hashMap3 = new HashMap<String, Integer>();
                            hashMap3.put("tiletype", 1);
                            hashMap3.put("tilerow", n8);
                            hashMap3.put("tilecol", n11);
                            recordset.addNew((Geometry)string6, hashMap3);
                        }
                    }
                    n10 = n12 + 1;
                }
                n7 = n9 + 1;
            }
            if (n2 > 0) {
                if (batchEditor != null) {
                    batchEditor.update();
                }
                if (recordset != null) {
                    recordset.close();
                    recordset.dispose();
                }
            }
            ((CacheWriter)object3).setCacheScaleCaptions(hashMap);
            ((CacheWriter)object3).setCacheBounds(rectangle2D);
        }
        outputStreamWriter.close();
        if (n2 > 0) {
            datasource.close();
            workspace.close();
            workspace.dispose();
        }
        if (n2 < 2) {
            TaskTileBuilder.splitList((String)object, n);
        }
    }

    public static void splitList(String allListFileName, int splitCount) throws Exception {
        String string;
        if (splitCount < 2) {
            return;
        }
        File file = new File(allListFileName);
        ArrayList<String> arrayList = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
            arrayList = new ArrayList<String>();
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
        }
        int n = arrayList.size() / splitCount;
        int n2 = 0;
        string = file.getParent() + "/" + file.getName().replaceAll(".list", "");
        for (int i = 0; i < splitCount; ++i) {
            File file2 = new File(string + "_" + i + ".list");
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8");){
                if ((double)(arrayList.size() - n2) * 1.0 / (double)n < 2.0) {
                    n = arrayList.size() - n2;
                }
                for (int j = 0; j < n; ++j) {
                    outputStreamWriter.write((String)arrayList.get(n2) + "\n");
                    ++n2;
                }
                continue;
            }
        }
    }

    public static void wirteOneSci(CacheWriter writer, String sciName, OutputStreamWriter listWriter) throws Exception {
        boolean bl = writer.ToConfigFile(sciName);
        if (bl) {
            listWriter.write(new File(sciName).getName() + "\n");
        }
    }
}

