/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing.cache;

import com.supermap.data.EngineType;
import com.supermap.data.Workspace;
import com.supermap.data.WorkspaceConnectionInfo;
import com.supermap.data.processing.CacheWriter;
import com.supermap.data.processing.MapCacheBuilder;
import com.supermap.data.processing.TileFormat;
import com.supermap.data.processing.cache.LogWriter;
import com.supermap.data.processing.cache.MultiProcessManager;
import com.supermap.data.processing.cache.ProcessBuildEvent;
import com.supermap.data.processing.cache.ProcessBuildingListener;
import com.supermap.mapping.Map;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class CacheBuilder {
    private int sciIndex = 0;
    private String scaleCaptin = "";

    public static void main(String[] args) {
        CacheBuilder.run(args);
    }

    public static String run(String[] args) {
        Object object;
        CacheWriter cacheWriter;
        Comparable<Boolean> comparable;
        if (args.length < 6) {
            System.out.println("please input argements:");
            System.out.println("workspacefile mapname scilist cacheroot prpcesscount mergetaskcount scifile");
            return "failed: argement error";
        }
        String string = args[0];
        String string2 = args[1];
        String string3 = args[2];
        String string4 = args[3];
        int n = 0;
        if (args.length > 4) {
            n = Integer.valueOf(args[4]);
        }
        int n2 = 0;
        if (args.length > 5) {
            n2 = Integer.valueOf(args[5]);
        }
        String string5 = "";
        if (args.length > 6) {
            string5 = args[6];
        }
        if (n > 0) {
            LogWriter.setWriteToFile(true);
            comparable = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                ((StringBuilder)comparable).append(args[i]);
                ((StringBuilder)comparable).append(" ");
            }
            LogWriter.getInstance().writelog(((StringBuilder)comparable).toString());
            LogWriter.getInstance().flush();
            if (string5.isEmpty()) {
                LogWriter.getInstance().writelog("scifile args is empty!");
                LogWriter.getInstance().flush();
                return "failed: scifile args is empty!";
            }
        }
        comparable = false;
        Boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!string5.isEmpty()) {
            cacheWriter = new CacheWriter();
            if (!cacheWriter.FromConfigFile(string5).booleanValue()) {
                LogWriter.getInstance().writelog("cachewrier read sci file failed!");
                LogWriter.getInstance().flush();
                return "failed: cachewrier read sci file failed!";
            }
            comparable = cacheWriter.getTileFormat() == TileFormat.PBF;
            if (cacheWriter.isbuildFromOriginalResolution().booleanValue()) {
                bl = true;
                object = new ArrayList();
                ((ArrayList)object).addAll(cacheWriter.getCacheScaleCaptions().keySet());
                Collections.sort(object, Collections.reverseOrder());
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    Double d = (Double)iterator.next();
                    arrayList.add(cacheWriter.getCacheScaleCaptions().get(d));
                }
            }
        }
        cacheWriter = new Workspace();
        object = new WorkspaceConnectionInfo(string);
        cacheWriter.open((WorkspaceConnectionInfo)object);
        boolean bl2 = true;
        for (int i = 0; i < cacheWriter.getDatasources().getCount(); ++i) {
            if (cacheWriter.getDatasources().get(i).getEngineType() == EngineType.UDBX) continue;
            bl2 = cacheWriter.getDatasources().get(i).isReadOnly() && bl2;
        }
        cacheWriter.close();
        cacheWriter.dispose();
        if (!bl2) {
            LogWriter.getInstance().writelog("not udbx datasource must be readonly!");
            LogWriter.getInstance().flush();
            return "failed: not udbx datasource must be readonly!";
        }
        String string6 = "";
        int n3 = 0;
        do {
            String string72;
            Object object2;
            Object object3;
            ++n3;
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            if (string3.endsWith(".list")) {
                object3 = new File(string3);
                object2 = ((File)object3).getParent();
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)object3), "UTF-8"));){
                    String string8;
                    while ((string8 = bufferedReader.readLine()) != null) {
                        string72 = (String)object2 + "/" + string8;
                        File file = new File(string72);
                        if (!file.exists()) continue;
                        arrayList2.add(string72);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.out.println(unsupportedEncodingException.getMessage());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println(fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                }
            } else if (string3.contains("&")) {
                object3 = string3.split("&");
                for (int i = 0; i < ((String[])object3).length; ++i) {
                    arrayList2.add(object3[i]);
                }
            } else if (string3.endsWith(".sci")) {
                arrayList2.add(string3);
            } else {
                object3 = new File(string3);
                if (((File)object3).isDirectory()) {
                    object2 = ((File)object3).list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith(".sci");
                        }
                    });
                    for (String string72 : object2) {
                        arrayList2.add(string3 + "/" + string72);
                    }
                }
            }
            if (arrayList2.size() == 0) {
                LogWriter.getInstance().writelog("sci files is empty!");
                if (n3 != 1) break;
                string6 = "failed: sci files is empty!";
                break;
            }
            object3 = new ArrayList();
            if (bl.booleanValue()) {
                int n4;
                HashMap hashMap = new HashMap();
                for (n4 = 0; n4 < arrayList.size(); ++n4) {
                    hashMap.put("L" + (String)arrayList.get(n4), new ArrayList());
                }
                for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                    String string9 = (String)arrayList2.get(n4);
                    String string10 = new File(string9).getName();
                    string72 = string10.substring(0, string10.indexOf("_"));
                    if (!hashMap.containsKey(string72)) continue;
                    ((ArrayList)hashMap.get(string72)).add(string9);
                }
                for (n4 = 0; n4 < arrayList.size(); ++n4) {
                    ((ArrayList)object3).add(hashMap.get("L" + arrayList.get(n4)));
                }
            } else {
                ((ArrayList)object3).add(arrayList2);
            }
            if (n > 0 && n2 == 0) {
                n2 = CacheBuilder.getMergeTaskCount(arrayList2.size(), n);
            }
            object2 = new CacheBuilder();
            string6 = super.build(string, string2, (ArrayList<ArrayList<String>>)object3, string4, n, n2, string5, (Boolean)comparable, bl, arrayList);
        } while (n > 0 && n3 < 2);
        return string6;
    }

    private String build(String workspaceFile, String mapName, ArrayList<ArrayList<String>> sciGroup, String cacheRoot, int processCount, int mergeTaskCount, String sciRoot, boolean isMvtCache, boolean isMaxtoMinScale, ArrayList<String> listCaption) {
        if (processCount > 0) {
            Object object;
            WorkspaceConnectionInfo workspaceConnectionInfo;
            WorkspaceConnectionInfo workspaceConnectionInfo2;
            Object object2;
            int n = 0;
            File file = null;
            for (ArrayList<String> object32 : sciGroup) {
                if (file != null || (n += object32.size()) <= 0) continue;
                file = new File(object32.get(0));
            }
            LogWriter.getInstance().writelog(workspaceFile + " " + mapName + " " + n + " " + cacheRoot + " " + processCount + " " + mergeTaskCount + " " + sciRoot + " " + isMvtCache + " " + isMaxtoMinScale + " " + listCaption.size());
            LogWriter.getInstance().flush();
            if (file != null) {
                if (!file.isFile()) {
                    LogWriter.getInstance().writelog("args \"" + file + "\" not file!");
                    return "args \"" + file + "\" not file!";
                }
                object2 = new File(file.getParentFile().getParent() + "/build");
                if (!((File)object2).exists()) {
                    ((File)object2).mkdir();
                }
            }
            object2 = workspaceFile;
            String mapCacheBuilder = mapName;
            String bl = cacheRoot;
            for (int workspace = 0; workspace < sciGroup.size(); ++workspace) {
                workspaceConnectionInfo2 = sciGroup.get(workspace);
                if (workspaceConnectionInfo2.size() == 0) continue;
                this.sciIndex = 0;
                workspaceConnectionInfo = workspaceConnectionInfo2;
                object = new MultiProcessManager(this, processCount);
                ((MultiProcessManager)object).addProcessBuildingListener(new ProcessBuildingListener((ArrayList)workspaceConnectionInfo, processCount, (String)object2, mapCacheBuilder, bl){
                    final /* synthetic */ ArrayList val$argsSciList;
                    final /* synthetic */ int val$processCount;
                    final /* synthetic */ String val$argsWorkspace;
                    final /* synthetic */ String val$argsMapName;
                    final /* synthetic */ String val$argsCacheRoot;
                    {
                        this.val$argsSciList = arrayList;
                        this.val$processCount = n;
                        this.val$argsWorkspace = string;
                        this.val$argsMapName = string2;
                        this.val$argsCacheRoot = string3;
                    }

                    @Override
                    public void ProcessBuilding(ProcessBuildEvent event) {
                        if (CacheBuilder.this.sciIndex < this.val$argsSciList.size()) {
                            String string = (String)this.val$argsSciList.get(CacheBuilder.this.sciIndex);
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(string);
                            CacheBuilder.this.sciIndex++;
                            int n = CacheBuilder.getMergeTaskCount(this.val$argsSciList.size() - CacheBuilder.this.sciIndex, this.val$processCount);
                            if (n > 1) {
                                for (int i = 1; i < n && CacheBuilder.this.sciIndex < this.val$argsSciList.size(); ++i) {
                                    stringBuilder.append("&");
                                    stringBuilder.append((String)this.val$argsSciList.get(CacheBuilder.this.sciIndex));
                                    CacheBuilder.this.sciIndex++;
                                }
                            }
                            String string2 = stringBuilder.toString();
                            ArrayList<String> arrayList = new ArrayList<String>();
                            arrayList.add(this.val$argsWorkspace);
                            arrayList.add(this.val$argsMapName);
                            arrayList.add(string2);
                            arrayList.add(this.val$argsCacheRoot);
                            arrayList.add("0");
                            arrayList.add("0");
                            event.setActive(true);
                            event.setArgs(arrayList);
                        }
                    }
                });
                ((MultiProcessManager)object).Run();
            }
            if (isMvtCache) {
                Workspace workspace = new Workspace();
                workspaceConnectionInfo2 = new WorkspaceConnectionInfo(workspaceFile);
                workspace.open(workspaceConnectionInfo2);
                workspaceConnectionInfo = new Map(workspace);
                workspaceConnectionInfo.open(mapName);
                workspaceConnectionInfo.setVisibleScalesEnabled(false);
                object = new MapCacheBuilder();
                ((MapCacheBuilder)((Object)object)).setMap((Map)workspaceConnectionInfo);
                ((MapCacheBuilder)((Object)object)).fromConfigFile(sciRoot);
                ((MapCacheBuilder)((Object)object)).setOutputFolder(cacheRoot);
                ((MapCacheBuilder)((Object)object)).resumable(false);
                ((MapCacheBuilder)((Object)object)).setMultiProcessing(true);
                boolean bl2 = ((MapCacheBuilder)((Object)object)).buildWithoutConfigFile(false, true);
                ((MapCacheBuilder)((Object)object)).dispose();
                workspaceConnectionInfo.close();
                workspaceConnectionInfo.dispose();
                workspace.close();
                workspace.dispose();
            }
        } else {
            this.BuildCache(workspaceFile, mapName, sciGroup.get(0), cacheRoot);
            if (processCount == 0 && isMvtCache) {
                Workspace workspace = new Workspace();
                WorkspaceConnectionInfo workspaceConnectionInfo = new WorkspaceConnectionInfo(workspaceFile);
                workspace.open(workspaceConnectionInfo);
                Map map = new Map(workspace);
                map.open(mapName);
                map.setVisibleScalesEnabled(false);
                MapCacheBuilder mapCacheBuilder = new MapCacheBuilder();
                mapCacheBuilder.setMap(map);
                mapCacheBuilder.fromConfigFile(sciRoot);
                mapCacheBuilder.setOutputFolder(cacheRoot);
                mapCacheBuilder.resumable(false);
                mapCacheBuilder.setMultiProcessing(true);
                boolean bl = mapCacheBuilder.buildWithoutConfigFile(false, true);
                mapCacheBuilder.dispose();
                map.close();
                map.dispose();
                workspace.close();
                workspace.dispose();
            }
        }
        return "success";
    }

    public void BuildCache(String workspaceFile, String mapName, ArrayList<String> sciFiles, String targetRoot) {
        long l = System.currentTimeMillis();
        LogWriter logWriter = LogWriter.getInstance();
        String string = LogWriter.getPID();
        Workspace workspace = new Workspace();
        WorkspaceConnectionInfo workspaceConnectionInfo = new WorkspaceConnectionInfo(workspaceFile);
        workspace.open(workspaceConnectionInfo);
        Map map = new Map(workspace);
        map.open(mapName);
        map.setVisibleScalesEnabled(false);
        logWriter.writelog(String.format("start sciCount:%d , PID:%s", sciFiles.size(), string));
        logWriter.writelog(String.format("init PID:%s, cost(ms):%d", LogWriter.getPID(), System.currentTimeMillis() - l));
        for (String string2 : sciFiles) {
            long l2 = System.currentTimeMillis();
            File file = new File(string2);
            if (!file.exists()) {
                LogWriter.getInstance().writelog(String.format("sciFile: %s does not exist. Maybe has done at before running. ", string2));
                continue;
            }
            MapCacheBuilder mapCacheBuilder = new MapCacheBuilder();
            mapCacheBuilder.setMap(map);
            mapCacheBuilder.fromConfigFile(string2);
            mapCacheBuilder.setOutputFolder(targetRoot);
            mapCacheBuilder.resumable(false);
            boolean bl = false;
            if (mapCacheBuilder.getTileFormat() == TileFormat.PBF) {
                mapCacheBuilder.setMultiProcessing(true);
                bl = mapCacheBuilder.buildWithoutConfigFile(true, false);
            } else {
                mapCacheBuilder.setMultiProcessing(sciFiles.size() > 1);
                bl = mapCacheBuilder.buildWithoutConfigFile();
            }
            mapCacheBuilder.dispose();
            if (bl) {
                boolean bl2;
                File file2 = new File(file.getParentFile().getParent() + "/build");
                if (!file2.exists()) {
                    file2.mkdir();
                }
                if (!(bl2 = file.renameTo(new File(file2, file.getName())))) {
                    System.out.println("rename Failed!");
                }
            }
            long l3 = System.currentTimeMillis();
            logWriter.writelog(String.format("%s %s done,PID:%s, cost(ms):%d, done", string2, String.valueOf(bl), LogWriter.getPID(), l3 - l2));
            logWriter.flush();
        }
        map.close();
        map.dispose();
        workspace.close();
        workspace.dispose();
    }

    private static int getMergeTaskCount(int scicount, int processcount) {
        int n = scicount / processcount;
        if (n < 1) {
            n = 1;
        } else if (n > 20) {
            n = 20;
        }
        return n;
    }
}

