/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing.cache;

import com.supermap.data.CursorType;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.EngineType;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldType;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometrist;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Toolkit;
import com.supermap.data.Unit;
import com.supermap.data.Workspace;
import com.supermap.data.conversion.DataImport;
import com.supermap.data.conversion.ImportResult;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingGeoJson;
import com.supermap.data.processing.CacheWriter;
import com.supermap.data.processing.CompactFile;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.TileFormat;
import com.supermap.data.processing.cache.LogWriter;
import com.supermap.data.processing.cache.MultiProcessManager;
import com.supermap.data.processing.cache.ProcessBuildEvent;
import com.supermap.data.processing.cache.ProcessBuildingListener;
import com.supermap.tilestorage.TileContent;
import com.supermap.tilestorage.TileContentInfo;
import com.supermap.tilestorage.TileStorageConnection;
import com.supermap.tilestorage.TileStorageInfo;
import com.supermap.tilestorage.TileStorageManager;
import com.supermap.tilestorage.TileStorageType;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class CacheCheck {
    private static int sciIndex = 0;
    private String m_sciFilePath = "";
    private String m_errorFileName;
    private BufferedWriter m_errorWriter = null;
    private boolean m_error2udb = false;
    private boolean m_checkSolid = false;
    private boolean m_checkBlock = false;
    private int m_checkType = 1;
    private boolean m_boundaryCheck = false;
    private Geometry m_boundaryRegion = null;

    public static void main(String[] args) {
        Object object;
        ArrayList<String> arrayList;
        if (args.length < 3 || args[0].equalsIgnoreCase("--help")) {
            System.out.println("CacheCheck arguments instructions:");
            System.out.println("cacheroot scipath processcount mergetaskcount error2udb checkSolid checkBlock checktype boundaryRegion");
            return;
        }
        String string = args[0];
        String string2 = args[1];
        int n = Integer.valueOf(args[2]);
        int n2 = 0;
        if (args.length > 3) {
            n2 = Integer.valueOf(args[3]);
        }
        boolean bl = false;
        if (args.length > 4) {
            bl = Boolean.valueOf(args[4]);
        }
        boolean bl2 = false;
        if (args.length > 5) {
            bl2 = Boolean.valueOf(args[5]);
        }
        boolean bl3 = false;
        if (args.length > 6) {
            bl3 = Boolean.valueOf(args[6]);
        }
        String string3 = "white";
        if (args.length > 7) {
            string3 = args[7];
        }
        String string4 = "";
        if (args.length > 8) {
            string4 = args[8];
        }
        if ((arrayList = CacheCheck.getSciFileList(string2)).size() == 0) {
            System.out.println("sci file not found!");
            return;
        }
        if (n > 0 && n2 == 0) {
            n2 = arrayList.size() / n / 2;
            if (n2 < 1) {
                n2 = 1;
            } else if (n2 > 50) {
                n2 = 50;
            }
        }
        if (n >= 0) {
            LogWriter.setWriteToFile(true);
            object = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                ((StringBuilder)object).append(args[i]);
                ((StringBuilder)object).append(" ");
            }
            LogWriter.getInstance().writelog("cache check args:" + ((StringBuilder)object).toString());
        }
        object = new CacheCheck();
        ((CacheCheck)object).initalize(string, arrayList, n, n2, bl, bl2, bl3, string3, string4);
        if (n > 0 && n2 > 1) {
            String string5 = string2;
            if (string2.endsWith(".list")) {
                File file = new File(string2);
                string5 = file.getParent();
            }
            if ((arrayList = CacheCheck.getSciFileList(string2)).size() > 0) {
                ((CacheCheck)object).initalize(string, arrayList, n, 0, bl, bl2, bl3, string3, string4);
            }
        }
    }

    public void initalize(String cacheRoot, ArrayList<String> sciFiles, int processcount, int mergeTaskCount, boolean error2udb, boolean checkSolid, boolean checkBlock, String checkType, String boundaryRegion) {
        this.m_error2udb = error2udb;
        this.m_checkSolid = checkSolid;
        this.m_checkBlock = checkBlock;
        if (checkType.equalsIgnoreCase("white")) {
            this.m_checkType = 1;
        } else if (checkType.equalsIgnoreCase("alpha")) {
            this.m_checkType = 2;
        } else if (checkType.equalsIgnoreCase("whiteandalpha")) {
            this.m_checkType = 3;
        }
        this.m_boundaryRegion = this.geojsonToGeomtry(boundaryRegion);
        this.m_boundaryCheck = this.m_boundaryRegion != null;
        CacheWriter cacheWriter = new CacheWriter();
        cacheWriter.FromConfigFile(sciFiles.get(0));
        double d = cacheWriter.getIndexBounds().getLeft();
        double d2 = cacheWriter.getIndexBounds().getTop();
        int n = cacheWriter.getTileSize().value();
        if (processcount > 0) {
            final ArrayList<String> arrayList = sciFiles;
            final String string = cacheRoot;
            final int n2 = mergeTaskCount;
            final String string2 = String.valueOf(error2udb);
            final String string3 = String.valueOf(checkSolid);
            final String string4 = String.valueOf(checkBlock);
            final String string5 = checkType;
            final String string6 = String.valueOf(boundaryRegion);
            sciIndex = 0;
            MultiProcessManager multiProcessManager = new MultiProcessManager(this, processcount);
            multiProcessManager.addProcessBuildingListener(new ProcessBuildingListener(){

                @Override
                public void ProcessBuilding(ProcessBuildEvent event) {
                    if (sciIndex < arrayList.size()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append((String)arrayList.get(sciIndex));
                        sciIndex++;
                        if (n2 > 1) {
                            for (int i = 1; i < n2 && sciIndex < arrayList.size(); ++i) {
                                stringBuilder.append("&");
                                stringBuilder.append((String)arrayList.get(sciIndex));
                                sciIndex++;
                            }
                        }
                        String string7 = stringBuilder.toString();
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        arrayList2.add(string);
                        arrayList2.add(string7);
                        arrayList2.add("-1");
                        arrayList2.add("0");
                        arrayList2.add(string2);
                        arrayList2.add(string3);
                        arrayList2.add(string4);
                        arrayList2.add(string5);
                        arrayList2.add(string6);
                        event.setActive(true);
                        event.setArgs(arrayList2);
                    }
                }
            });
            multiProcessManager.Run();
            if (this.m_error2udb) {
                this.Error2Udb(d, d2, n, sciFiles.get(0));
            }
        } else {
            for (String string : sciFiles) {
                this.check(cacheRoot, string);
            }
            if (this.m_error2udb && processcount == 0 && sciFiles.size() > 0) {
                this.Error2Udb(d, d2, n, sciFiles.get(0));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void check(String cacheRoot, String sciFile) {
        void var9_15;
        boolean bl;
        Object object;
        String string;
        Object object3;
        File file = new File(sciFile);
        if (!file.exists()) {
            return;
        }
        this.m_sciFilePath = file.getName();
        this.m_errorWriter = null;
        CacheWriter cacheWriter = new CacheWriter();
        cacheWriter.FromConfigFile(sciFile);
        cacheRoot = cacheRoot + "/" + cacheWriter.getCacheName() + "/" + cacheWriter.parseTileFormat() + "_" + cacheWriter.getTileSize().value() + "_" + cacheWriter.getHashCode();
        double[] dArray = null;
        TileStorageManager tileStorageManager = null;
        if (cacheWriter.getStorageType() == StorageType.MongoDB) {
            String[] stringArray = cacheWriter.getMongoConnectionInfo();
            if (stringArray == null || stringArray.length < 3) {
                LogWriter.getInstance().writelog("error: mongo connection info!");
                return;
            }
            object3 = stringArray[0];
            String object22 = stringArray[1];
            string = stringArray[2];
            object = new TileStorageConnection();
            object.setStorageType(TileStorageType.MONGO);
            object.setServer((String)object3);
            object.setDatabase(object22);
            object.setName(string);
            tileStorageManager = new TileStorageManager();
            if (!tileStorageManager.open(object)) {
                LogWriter.getInstance().writelog("error: mongo open failed!");
                return;
            }
            TileStorageInfo tileStorageInfo = tileStorageManager.getInfo();
            dArray = tileStorageInfo.getResolutions();
        }
        boolean bl2 = true;
        for (Double d : cacheWriter.getCacheScaleCaptions().keySet()) {
            int n;
            string = cacheWriter.getCacheScaleCaptions().get(d);
            object = file.getName().replaceAll(".sci", "");
            object = (String)object + "(L" + string + "_S" + Math.round(1.0 / d) + ").err";
            this.m_errorFileName = file.getParentFile().getParent() + "/temp/" + (String)object;
            double d2 = this.getReolustion(d, cacheWriter.getPrjCoordSys(), cacheWriter.getDPI());
            double d3 = (cacheWriter.getCacheBounds().getLeft() - cacheWriter.getIndexBounds().getLeft()) / d2 / (double)cacheWriter.getTileSize().value();
            double d4 = (cacheWriter.getIndexBounds().getTop() - cacheWriter.getCacheBounds().getTop()) / d2 / (double)cacheWriter.getTileSize().value();
            double d5 = (cacheWriter.getCacheBounds().getRight() - cacheWriter.getIndexBounds().getLeft()) / d2 / (double)cacheWriter.getTileSize().value();
            double d6 = (cacheWriter.getIndexBounds().getTop() - cacheWriter.getCacheBounds().getBottom()) / d2 / (double)cacheWriter.getTileSize().value();
            int n2 = (int)d3;
            int n3 = (int)d4;
            int n4 = (int)d5;
            if (d5 - (double)n4 < 1.0E-4) {
                --n4;
            }
            if (d6 - (double)(n = (int)d6) < 1.0E-4) {
                --n;
            }
            if (cacheWriter.getStorageType() != StorageType.Original) {
                if (cacheWriter.getStorageType() == StorageType.Compact) {
                    bl2 = bl2 && this.checkCompactCache(cacheRoot, string, n2, n3, n4, n, d2, cacheWriter);
                } else if (cacheWriter.getStorageType() == StorageType.MongoDB) {
                    int n5 = 1;
                    double d7 = dArray[0];
                    double d8 = Math.abs(d7 - d2);
                    for (int i = 0; i < dArray.length; ++i) {
                        if (!(Math.abs(dArray[i] - d2) < d8)) continue;
                        d7 = dArray[i];
                        d8 = dArray[i] - d2;
                        n5 = i + 1;
                    }
                    if (n5 > 0) {
                        boolean bl3 = bl2 = bl2 && this.checkMongoCache(tileStorageManager, n5, n2, n3, n4, n, d2, cacheWriter);
                    }
                }
            }
            if (this.m_errorWriter == null) continue;
            try {
                this.m_errorWriter.flush();
                this.m_errorWriter.close();
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
            this.m_errorWriter = null;
        }
        object3 = new File(sciFile);
        String string2 = ((File)object3).getParentFile().getParent() + "/checked";
        if (!bl2) {
            String string3 = ((File)object3).getParentFile().getParent() + "/error";
        }
        if (!(bl = ((File)object3).renameTo(new File((String)var9_15, ((File)object3).getName())))) {
            System.out.println("rename Failed!");
        }
        if (tileStorageManager != null) {
            tileStorageManager.close();
        }
    }

    public void checkOriginalCache() {
    }

    public boolean checkCompactCache(String cacheRoot, String caption, int left, int top, int right, int bottom, double reolustion, CacheWriter cacheFile) {
        boolean bl = false;
        if (this.m_boundaryCheck) {
            Rectangle2D rectangle2D = cacheFile.getCacheBounds();
            Point2Ds point2Ds = new Point2Ds();
            point2Ds.add(new Point2D(rectangle2D.getLeft(), rectangle2D.getBottom()));
            point2Ds.add(new Point2D(rectangle2D.getLeft(), rectangle2D.getTop()));
            point2Ds.add(new Point2D(rectangle2D.getRight(), rectangle2D.getTop()));
            point2Ds.add(new Point2D(rectangle2D.getRight(), rectangle2D.getBottom()));
            GeoRegion geoRegion = new GeoRegion(point2Ds);
            bl = Geometrist.isWithin((Geometry)geoRegion, (Geometry)this.m_boundaryRegion);
        }
        double d = cacheFile.getIndexBounds().getLeft();
        double d2 = cacheFile.getIndexBounds().getTop();
        int n = cacheFile.getTileSize().value();
        TileFormat tileFormat = cacheFile.getTileFormat();
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        boolean bl2 = true;
        int n2 = top;
        while (n2 <= bottom) {
            int n3 = n2 / 128;
            int n4 = Math.min(bottom, (n3 + 1) * 128 - 1);
            int n5 = left;
            while (n5 <= right) {
                Point2Ds point2Ds;
                int n6 = n5 / 128;
                int n7 = Math.min(right, (n6 + 1) * 128 - 1);
                String string = cacheRoot + "/" + caption + "/" + n3 + "/" + n6 + ".cf";
                File file = new File(string);
                if (!file.exists()) {
                    boolean bl3 = bl;
                    if (this.m_boundaryCheck && !bl) {
                        double d3 = d + reolustion * (double)n5 * (double)n;
                        double d4 = d3 + reolustion * (double)(n7 + 1) * (double)n;
                        double d5 = d2 - reolustion * (double)n2 * (double)n;
                        double d6 = d5 - reolustion * (double)(n4 + 1) * (double)n;
                        Point2Ds point2Ds2 = new Point2Ds();
                        point2Ds2.add(new Point2D(d3, d6));
                        point2Ds2.add(new Point2D(d3, d5));
                        point2Ds2.add(new Point2D(d4, d5));
                        point2Ds2.add(new Point2D(d4, d6));
                        point2Ds = new GeoRegion(point2Ds2);
                        bl3 = Geometrist.isWithin((Geometry)point2Ds, (Geometry)this.m_boundaryRegion);
                    }
                    if (this.m_boundaryCheck && !bl3) {
                        n5 = n7 + 1;
                        continue;
                    }
                    bl2 = false;
                    LogWriter.getInstance().writelog("lost:" + string);
                    this.writError("lost," + reolustion + "," + n3 + "," + n6 + "," + this.m_sciFilePath);
                } else {
                    CompactFile compactFile = new CompactFile();
                    if (compactFile.Open(string, "") != 0) {
                        boolean bl4 = bl;
                        if (this.m_boundaryCheck && !bl) {
                            double d7 = d + reolustion * (double)n5 * (double)n;
                            double d8 = d7 + reolustion * (double)(n7 + 1) * (double)n;
                            double d9 = d2 - reolustion * (double)n2 * (double)n;
                            double d10 = d9 - reolustion * (double)(n4 + 1) * (double)n;
                            point2Ds = new Point2Ds();
                            point2Ds.add(new Point2D(d7, d10));
                            point2Ds.add(new Point2D(d7, d9));
                            point2Ds.add(new Point2D(d8, d9));
                            point2Ds.add(new Point2D(d8, d10));
                            GeoRegion geoRegion = new GeoRegion(point2Ds);
                            bl4 = Geometrist.isWithin((Geometry)geoRegion, (Geometry)this.m_boundaryRegion);
                        }
                        if (this.m_boundaryCheck && !bl4) {
                            n5 = n7 + 1;
                            continue;
                        }
                        bl2 = false;
                        LogWriter.getInstance().writelog("failure:" + string);
                        this.writError("failure," + reolustion + "," + n3 + "," + n6 + "," + this.m_sciFilePath);
                    } else {
                        byte[] byArray = null;
                        for (int i = n2; i <= n4; ++i) {
                            for (int j = n5; j <= n7; ++j) {
                                Object object;
                                boolean bl5 = bl;
                                if (this.m_boundaryCheck && !bl) {
                                    double d11 = d + reolustion * (double)j * (double)n;
                                    double d12 = d11 + reolustion * (double)n;
                                    double d13 = d2 - reolustion * (double)i * (double)n;
                                    double d14 = d13 - reolustion * (double)n;
                                    Point2Ds point2Ds3 = new Point2Ds();
                                    point2Ds3.add(new Point2D(d11, d14));
                                    point2Ds3.add(new Point2D(d11, d13));
                                    point2Ds3.add(new Point2D(d12, d13));
                                    point2Ds3.add(new Point2D(d12, d14));
                                    GeoRegion geoRegion = new GeoRegion(point2Ds3);
                                    bl5 = Geometrist.isWithin((Geometry)geoRegion, (Geometry)this.m_boundaryRegion);
                                }
                                if (this.m_boundaryCheck && !bl5) continue;
                                byArray = compactFile.getAt(i % 128, j % 128);
                                if (byArray == null || byArray.length == 0) {
                                    bl2 = false;
                                    LogWriter.getInstance().writelog("missing:" + caption + "," + i + "," + j + "," + this.m_sciFilePath);
                                    this.writError("missing," + reolustion + "," + i + "," + j + "," + this.m_sciFilePath);
                                    continue;
                                }
                                if (byArray.length <= 16 && this.m_checkSolid) {
                                    String string2 = String.format("%02x%02x%02x", byArray[12], byArray[13], byArray[14]);
                                    object = string2 + (tileFormat.value() == TileFormat.PNG.value() ? ".png" : ".jpg");
                                    if (tileFormat.value() == TileFormat.JPG_PNG.value()) {
                                        object = string2;
                                    }
                                    if (!hashMap.containsKey(object)) {
                                        String string3 = cacheRoot + "/" + caption + "/" + n3 + "/" + (String)object;
                                        File file2 = null;
                                        if (tileFormat.value() == TileFormat.JPG_PNG.value()) {
                                            file2 = new File(string3 + ".png");
                                            if (file2.exists()) {
                                                string3 = string3 + ".png";
                                            } else {
                                                file2 = new File(string3 + ".jpg");
                                                if (file2.exists()) {
                                                    string3 = string3 + ".jpg";
                                                } else {
                                                    file2 = null;
                                                }
                                            }
                                        } else {
                                            file2 = new File(string3);
                                            if (!file2.exists()) {
                                                file2 = null;
                                            }
                                        }
                                        if (file2 != null) {
                                            BufferedImage bufferedImage = null;
                                            try {
                                                bufferedImage = ImageIO.read(file2);
                                            }
                                            catch (IOException iOException) {
                                                hashMap.put(object, 5);
                                            }
                                            boolean bl6 = false;
                                            if (this.m_checkBlock) {
                                                if ((this.m_checkType & 1) == 1) {
                                                    boolean bl7 = bl6 = bl6 || this.isBlockWhite(bufferedImage);
                                                }
                                                if ((this.m_checkType & 2) == 2) {
                                                    bl6 = bl6 || this.isBlockAlpha(bufferedImage);
                                                }
                                            } else {
                                                if ((this.m_checkType & 1) == 1) {
                                                    boolean bl8 = bl6 = bl6 || this.isSolidWhite(bufferedImage);
                                                }
                                                if ((this.m_checkType & 2) == 2) {
                                                    boolean bl9 = bl6 = bl6 || this.isSolidAlpha(bufferedImage);
                                                }
                                            }
                                            if (bl6) {
                                                hashMap.put(object, 2);
                                            } else {
                                                hashMap.put(object, 0);
                                            }
                                        } else {
                                            hashMap.put(object, 1);
                                        }
                                    }
                                    switch ((Integer)hashMap.get(object)) {
                                        case 1: {
                                            bl2 = false;
                                            LogWriter.getInstance().writelog("missing:" + caption + "," + i + "," + j + "," + this.m_sciFilePath);
                                            this.writError("missing," + reolustion + "," + i + "," + j + "," + this.m_sciFilePath);
                                            break;
                                        }
                                        case 2: {
                                            bl2 = false;
                                            LogWriter.getInstance().writelog("white:" + caption + "," + i + "," + j + "," + this.m_sciFilePath);
                                            this.writError("white," + reolustion + "," + i + "," + j + "," + this.m_sciFilePath);
                                            break;
                                        }
                                        case 5: {
                                            bl2 = false;
                                            LogWriter.getInstance().writelog("error:" + caption + "," + i + "," + j + "," + this.m_sciFilePath);
                                            this.writError("error," + reolustion + "," + i + "," + j + "," + this.m_sciFilePath);
                                            break;
                                        }
                                    }
                                    continue;
                                }
                                if (byArray.length <= 16) continue;
                                try {
                                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 12, byArray.length - 12);
                                    object = null;
                                    try {
                                        object = ImageIO.read(byteArrayInputStream);
                                    }
                                    catch (IOException iOException) {
                                        bl2 = false;
                                        LogWriter.getInstance().writelog("error:" + caption + "," + i + "," + j + "," + this.m_sciFilePath);
                                        this.writError("error," + reolustion + "," + i + "," + j + "," + this.m_sciFilePath);
                                        byteArrayInputStream.close();
                                        continue;
                                    }
                                    boolean bl10 = false;
                                    if (this.m_checkBlock) {
                                        if ((this.m_checkType & 1) == 1) {
                                            boolean bl11 = bl10 = bl10 || this.isBlockWhite((BufferedImage)object);
                                        }
                                        if ((this.m_checkType & 2) == 2) {
                                            bl10 = bl10 || this.isBlockAlpha((BufferedImage)object);
                                        }
                                    } else {
                                        if ((this.m_checkType & 1) == 1) {
                                            boolean bl12 = bl10 = bl10 || this.isSolidWhite((BufferedImage)object);
                                        }
                                        if ((this.m_checkType & 2) == 2) {
                                            boolean bl13 = bl10 = bl10 || this.isSolidAlpha((BufferedImage)object);
                                        }
                                    }
                                    if (bl10) {
                                        bl2 = false;
                                        LogWriter.getInstance().writelog("white:" + caption + "," + i + "," + j + "," + this.m_sciFilePath);
                                        this.writError("white," + reolustion + "," + i + "," + j + "," + this.m_sciFilePath);
                                    }
                                    byteArrayInputStream.close();
                                    continue;
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                        compactFile.Close();
                    }
                }
                LogWriter.getInstance().flush();
                n5 = n7 + 1;
            }
            n2 = n4 + 1;
        }
        return bl2;
    }

    public boolean checkMongoCache(TileStorageManager manager, int level, int left, int top, int right, int bottom, double reolustion, CacheWriter cacheFile) {
        boolean bl = false;
        if (this.m_boundaryCheck) {
            Rectangle2D rectangle2D = cacheFile.getCacheBounds();
            Point2Ds point2Ds = new Point2Ds();
            point2Ds.add(new Point2D(rectangle2D.getLeft(), rectangle2D.getBottom()));
            point2Ds.add(new Point2D(rectangle2D.getLeft(), rectangle2D.getTop()));
            point2Ds.add(new Point2D(rectangle2D.getRight(), rectangle2D.getTop()));
            point2Ds.add(new Point2D(rectangle2D.getRight(), rectangle2D.getBottom()));
            GeoRegion geoRegion = new GeoRegion(point2Ds);
            bl = Geometrist.isWithin((Geometry)geoRegion, (Geometry)this.m_boundaryRegion);
        }
        double d = cacheFile.getIndexBounds().getLeft();
        double d2 = cacheFile.getIndexBounds().getTop();
        int n = cacheFile.getTileSize().value();
        boolean bl2 = true;
        byte[] byArray = null;
        TileContent tileContent = null;
        for (int i = top; i <= bottom; ++i) {
            for (int j = left; j <= right; ++j) {
                Object object;
                TileContentInfo tileContentInfo = new TileContentInfo();
                tileContentInfo.setLevel((long)level);
                tileContentInfo.setRow((long)i);
                tileContentInfo.setColumn((long)j);
                tileContentInfo.setTilesetName(cacheFile.getVersionSetting());
                tileContent = manager.loadTile(tileContentInfo);
                byArray = null;
                if (tileContent != null) {
                    byArray = tileContent.getData();
                    object = tileContent.getKey();
                    tileContent.dispose();
                    if (!this.m_checkSolid && ((String)object).length() <= 6) continue;
                }
                if (byArray == null || byArray.length == 0) {
                    bl2 = false;
                    LogWriter.getInstance().writelog("missing:" + level + "," + i + "," + j + "," + this.m_sciFilePath);
                    this.writError("missing," + reolustion + "," + i + "," + j + "," + this.m_sciFilePath);
                    continue;
                }
                if (byArray.length <= 16) continue;
                try {
                    object = new ByteArrayInputStream(byArray);
                    BufferedImage bufferedImage = null;
                    try {
                        bufferedImage = ImageIO.read((InputStream)object);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (bufferedImage == null) {
                        bl2 = false;
                        LogWriter.getInstance().writelog("error:" + level + "," + i + "," + j + "," + this.m_sciFilePath);
                        this.writError("error," + reolustion + "," + i + "," + j + "," + this.m_sciFilePath);
                        ((ByteArrayInputStream)object).close();
                        continue;
                    }
                    boolean bl3 = bl;
                    if (this.m_boundaryCheck && !bl) {
                        double d3 = d + reolustion * (double)j * (double)n;
                        double d4 = d3 + reolustion * (double)n;
                        double d5 = d2 - reolustion * (double)i * (double)n;
                        double d6 = d5 - reolustion * (double)n;
                        Point2Ds point2Ds = new Point2Ds();
                        point2Ds.add(new Point2D(d3, d6));
                        point2Ds.add(new Point2D(d3, d5));
                        point2Ds.add(new Point2D(d4, d5));
                        point2Ds.add(new Point2D(d4, d6));
                        GeoRegion geoRegion = new GeoRegion(point2Ds);
                        bl3 = Geometrist.isWithin((Geometry)geoRegion, (Geometry)this.m_boundaryRegion);
                    }
                    boolean bl4 = false;
                    if (this.m_boundaryCheck) {
                        if (bl3 && (bl4 = this.m_checkBlock ? this.isBlockWhite(bufferedImage) : this.isSolidWhite(bufferedImage))) {
                            bl2 = false;
                            LogWriter.getInstance().writelog("white:" + level + "," + i + "," + j + "," + this.m_sciFilePath);
                            this.writError("white," + reolustion + "," + i + "," + j + "," + this.m_sciFilePath);
                        }
                    } else {
                        bl4 = this.m_checkBlock ? this.isBlockWhite(bufferedImage) : this.isSolidWhite(bufferedImage);
                        if (bl4) {
                            bl2 = false;
                            LogWriter.getInstance().writelog("white:" + level + "," + i + "," + j + "," + this.m_sciFilePath);
                            this.writError("white," + reolustion + "," + i + "," + j + "," + this.m_sciFilePath);
                        }
                    }
                    ((ByteArrayInputStream)object).close();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bl2;
    }

    public double getReolustion(double scale, PrjCoordSys prjCoordSys, double cacheDPI) {
        double d = 0.0;
        d = prjCoordSys.getCoordUnit().equals((Object)Unit.DEGREE) ? prjCoordSys.getGeoCoordSys().getGeoDatum().getGeoSpheroid().getAxis() * (double)(prjCoordSys.getCoordUnit().value() - 1000000000) * 10000.0 * Math.PI / 3.1415922E8 : (double)prjCoordSys.getCoordUnit().value();
        double d2 = 1.0 / (scale * cacheDPI / 254.0);
        return d2 /= d;
    }

    public boolean isSolidWhite(BufferedImage image) {
        byte[] byArray = ((DataBufferByte)image.getData().getDataBuffer()).getData();
        byte by = -1;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == by) continue;
            return false;
        }
        return true;
    }

    public boolean isBlockWhite(BufferedImage image) {
        byte[] byArray = ((DataBufferByte)image.getData().getDataBuffer()).getData();
        byte by = -1;
        int n = 0;
        int n2 = 0;
        int n3 = image.getHeight();
        int n4 = byArray.length / n3;
        for (int i = 0; i < n3; ++i) {
            n2 = i * n4;
            block1: for (int j = 0; j < n4; ++j) {
                if (byArray[n2 + j] == by) {
                    if (n == -1) {
                        n = j;
                        continue;
                    }
                    if (j - n > 400) {
                        return true;
                    }
                    if (j - n != 3) continue;
                    for (int k = i + 1; k < n3; ++k) {
                        if (k - i > 100) {
                            return true;
                        }
                        int n5 = k * n4 + n;
                        if (byArray[n5] != by || byArray[n5 + 1] != by || byArray[n5 + 2] != by || byArray[n5 + 3] != by) continue block1;
                    }
                    continue;
                }
                n = -1;
            }
        }
        return false;
    }

    public boolean isSolidAlpha(BufferedImage image) {
        byte[] byArray = ((DataBufferByte)image.getData().getDataBuffer()).getData();
        int n = image.getWidth();
        int n2 = image.getHeight();
        int n3 = byArray.length / n2;
        int n4 = n3 / n;
        if (n4 != 4) {
            return false;
        }
        int n5 = 0;
        if (image.getType() == 6) {
            n5 = 0;
        } else if (image.getType() == 0) {
            n5 = 3;
        }
        byte by = 0;
        for (int i = 0; i < byArray.length; i += 4) {
            if (byArray[i + n5] == by) continue;
            return false;
        }
        return true;
    }

    public boolean isBlockAlpha(BufferedImage image) {
        byte[] byArray = ((DataBufferByte)image.getData().getDataBuffer()).getData();
        byte by = 0;
        int n = 0;
        int n2 = 0;
        int n3 = image.getWidth();
        int n4 = image.getHeight();
        int n5 = byArray.length / n4;
        int n6 = n5 / n3;
        if (n6 != 4) {
            return false;
        }
        int n7 = 0;
        if (image.getType() == 6) {
            n7 = 0;
        } else if (image.getType() == 0) {
            n7 = 3;
        }
        for (int i = 0; i < n4; ++i) {
            n2 = i * n5;
            block1: for (int j = 0; j < n5; j += 4) {
                if (byArray[n2 + j + n7] == by) {
                    if (n == -1) {
                        n = j;
                        for (int k = i + 1; k < n4; ++k) {
                            if (k - i > 100) {
                                return true;
                            }
                            int n8 = k * n5 + n;
                            if (byArray[n8 + n7] != by) continue block1;
                        }
                        continue;
                    }
                    if (j - n <= 400) continue;
                    return true;
                }
                n = -1;
            }
        }
        return false;
    }

    public static ArrayList<String> getSciFileList(String scipath) {
        Object object;
        Object object2;
        String string = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        if (scipath.endsWith(".list")) {
            object2 = new File(scipath);
            object = ((File)object2).getParent();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)object2), "UTF-8"));){
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    String string3 = (String)object + "/" + string2;
                    File file = new File(string3);
                    if (!file.exists()) continue;
                    arrayList.add(string3);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println(unsupportedEncodingException.getMessage());
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println(fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
            string = ((File)object2).getParentFile().getParent() + "/checked";
        } else if (scipath.contains("&")) {
            object = object2 = scipath.split("&");
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                String string4 = object[i];
                arrayList.add(string4);
            }
            if (arrayList.size() > 0) {
                object = new File((String)arrayList.get(0));
                string = ((File)object).getParentFile().getParent() + "/checked";
            }
        } else if (scipath.endsWith(".sci")) {
            arrayList.add(scipath);
            object2 = new File(scipath);
            string = ((File)object2).getParentFile().getParent() + "/checked";
        } else {
            object2 = new File(scipath);
            if (((File)object2).isDirectory()) {
                object = ((File)object2).list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".sci");
                    }
                });
                for (String string5 : object) {
                    arrayList.add(scipath + "/" + string5);
                }
                string = ((File)object2).getParent() + "/checked";
            }
        }
        object2 = new File(string);
        if (!((File)object2).exists()) {
            ((File)object2).mkdir();
        }
        if (!((File)(object = new File(((File)object2).getParent() + "/error"))).exists()) {
            ((File)object).mkdir();
        }
        return arrayList;
    }

    private void writError(String error) {
        if (!this.m_error2udb) {
            return;
        }
        if (this.m_errorWriter == null) {
            try {
                File file = new File(this.m_errorFileName);
                if (file.exists()) {
                    boolean bl = file.delete();
                    if (!bl) {
                        return;
                    }
                } else {
                    file.getParentFile().mkdirs();
                }
                this.m_errorWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_errorFileName), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println(unsupportedEncodingException.getMessage());
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println(fileNotFoundException.getMessage());
            }
        }
        try {
            if (this.m_errorWriter != null) {
                this.m_errorWriter.write(error);
                this.m_errorWriter.newLine();
                this.m_errorWriter.flush();
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    private void Error2Udb(double anchorLeft, double anchorTop, int tileSize, String sciFile) {
        boolean bl;
        String string = new File(sciFile).getParentFile().getParent();
        String string2 = string + "/temp/";
        File file = new File(string2);
        String[] stringArray = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".err");
            }
        });
        if (stringArray == null || stringArray.length <= 0) {
            System.out.println("no error file!");
            return;
        }
        String string3 = string + "/udb/cache.udb";
        File file2 = new File(string3);
        DatasourceConnectionInfo datasourceConnectionInfo = new DatasourceConnectionInfo();
        datasourceConnectionInfo.setServer(string3);
        datasourceConnectionInfo.setAlias("cache");
        datasourceConnectionInfo.setEngineType(EngineType.UDB);
        Workspace workspace = new Workspace();
        Datasource datasource = null;
        if (file2.exists()) {
            datasource = workspace.getDatasources().open(datasourceConnectionInfo);
        } else {
            file2.getParentFile().mkdirs();
            datasource = workspace.getDatasources().create(datasourceConnectionInfo);
        }
        for (String string4 : stringArray) {
            boolean bl2;
            GeoRegion geoRegion;
            Point2Ds point2Ds;
            HashMap<String, Object> hashMap;
            double d;
            double d2;
            double d3;
            double d4;
            int n;
            int n2;
            int n3;
            String[] stringArray2;
            Recordset.BatchEditor batchEditor;
            String string5;
            BufferedReader bufferedReader;
            int n4 = string4.indexOf("(");
            int n5 = string4.indexOf(")");
            String string6 = string4.substring(n4 + 1, n5);
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            File file3 = new File(string2 + string4);
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file3), "UTF-8"));
                while ((string5 = bufferedReader.readLine()) != null) {
                    if (string5.startsWith("lost") || string5.startsWith("failure")) {
                        arrayList2.add(string5);
                        continue;
                    }
                    arrayList.add(string5);
                }
                bufferedReader.close();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println(unsupportedEncodingException.getMessage());
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println(fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
            bufferedReader = null;
            if (datasource.getDatasets().contains(string6)) {
                bufferedReader = (DatasetVector)datasource.getDatasets().get(string6);
            } else {
                string5 = new DatasetVectorInfo(string6, DatasetType.REGION);
                bufferedReader = datasource.getDatasets().create((DatasetVectorInfo)string5);
                batchEditor = new FieldInfo("tiletype", FieldType.INT32);
                FieldInfo fieldInfo = new FieldInfo("tilerow", FieldType.INT32);
                FieldInfo fieldInfo2 = new FieldInfo("tilecol", FieldType.INT32);
                stringArray2 = new FieldInfo("errortype", FieldType.INT32);
                FieldInfo fieldInfo3 = new FieldInfo("errordesc", FieldType.TEXT);
                bufferedReader.getFieldInfos().add((FieldInfo)batchEditor);
                bufferedReader.getFieldInfos().add(fieldInfo);
                bufferedReader.getFieldInfos().add(fieldInfo2);
                bufferedReader.getFieldInfos().add((FieldInfo)stringArray2);
                bufferedReader.getFieldInfos().add(fieldInfo3);
            }
            string5 = bufferedReader.getRecordset(false, CursorType.DYNAMIC);
            batchEditor = string5.getBatch();
            batchEditor.setMaxRecordCount(50);
            batchEditor.begin();
            for (String string7 : arrayList2) {
                stringArray2 = string7.split(",");
                if (stringArray2.length <= 0) continue;
                double d5 = Double.valueOf((String)stringArray2[1]);
                n3 = Integer.valueOf(stringArray2[2]);
                n2 = Integer.valueOf(stringArray2[3]);
                n = stringArray2[0].startsWith("lo") ? 3 : 4;
                d4 = anchorLeft + d5 * (double)n2 * (double)tileSize * 128.0;
                d3 = d4 + d5 * (double)tileSize * 128.0;
                d2 = anchorTop - d5 * (double)n3 * (double)tileSize * 128.0;
                d = d2 - d5 * (double)tileSize * 128.0;
                hashMap = new HashMap<String, Object>();
                hashMap.put("tiletype", 1);
                hashMap.put("tilerow", n3);
                hashMap.put("tilecol", n2);
                hashMap.put("errortype", n);
                hashMap.put("errordesc", stringArray2[0]);
                point2Ds = new Point2Ds();
                point2Ds.add(new Point2D(d4, d));
                point2Ds.add(new Point2D(d4, d2));
                point2Ds.add(new Point2D(d3, d2));
                point2Ds.add(new Point2D(d3, d));
                geoRegion = new GeoRegion(point2Ds);
                string5.addNew((Geometry)geoRegion, hashMap);
            }
            for (String string8 : arrayList) {
                stringArray2 = string8.split(",");
                if (stringArray2.length <= 0) continue;
                double d6 = Double.valueOf(stringArray2[1]);
                n3 = Integer.valueOf(stringArray2[2]);
                n2 = Integer.valueOf(stringArray2[3]);
                n = 5;
                if (stringArray2[0].startsWith("m")) {
                    n = 1;
                } else if (stringArray2[0].startsWith("w")) {
                    n = 2;
                }
                d4 = anchorLeft + d6 * (double)n2 * (double)tileSize;
                d3 = d4 + d6 * (double)tileSize;
                d2 = anchorTop - d6 * (double)n3 * (double)tileSize;
                d = d2 - d6 * (double)tileSize;
                hashMap = new HashMap();
                hashMap.put("tiletype", 2);
                hashMap.put("tilerow", n3);
                hashMap.put("tilecol", n2);
                hashMap.put("errortype", n);
                hashMap.put("errordesc", stringArray2[0]);
                point2Ds = new Point2Ds();
                point2Ds.add(new Point2D(d4, d));
                point2Ds.add(new Point2D(d4, d2));
                point2Ds.add(new Point2D(d3, d2));
                point2Ds.add(new Point2D(d3, d));
                geoRegion = new GeoRegion(point2Ds);
                string5.addNew((Geometry)geoRegion, hashMap);
            }
            batchEditor.update();
            string5.close();
            string5.dispose();
            if (!file3.exists() || (bl2 = file3.delete())) continue;
            System.out.println("delete Failed!");
        }
        if (file.exists() && !(bl = file.delete())) {
            System.out.println("delete Failed!");
        }
        datasource.close();
        workspace.close();
        workspace.dispose();
    }

    private Geometry geojsonToGeomtry(String geojsonfile) {
        Geometry geometry;
        block31: {
            geometry = null;
            try {
                FileReader fileReader;
                Object object;
                if (geojsonfile.isEmpty()) break block31;
                Workspace workspace = new Workspace();
                DatasourceConnectionInfo datasourceConnectionInfo = new DatasourceConnectionInfo();
                datasourceConnectionInfo.setServer(":memory:");
                datasourceConnectionInfo.setAlias("memory");
                datasourceConnectionInfo.setEngineType(EngineType.MEMORY);
                Datasource datasource = workspace.getDatasources().create(datasourceConnectionInfo);
                ImportSettingGeoJson importSettingGeoJson = new ImportSettingGeoJson();
                importSettingGeoJson.setSourceFilePath(geojsonfile);
                importSettingGeoJson.setImportingAsCAD(false);
                importSettingGeoJson.setTargetDatasource(datasource);
                importSettingGeoJson.setTargetDatasetName("boundary");
                DataImport dataImport = new DataImport();
                dataImport.getImportSettings().add((ImportSetting)importSettingGeoJson);
                ImportResult importResult = dataImport.run();
                if (importResult.getSucceedSettings().length > 0 && datasource.getDatasets().getCount() > 0 && (object = datasource.getDatasets().get(0)) != null && object instanceof DatasetVector && (fileReader = ((DatasetVector)object).getRecordset(false, CursorType.STATIC)) != null && !fileReader.isEOF()) {
                    geometry = new GeoRegion((GeoRegion)fileReader.getGeometry());
                    fileReader.dispose();
                }
                workspace.close();
                workspace.dispose();
                if (geometry != null) break block31;
                object = new StringBuilder();
                try {
                    fileReader = new FileReader(new File(geojsonfile));
                    Throwable throwable = null;
                    try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
                        String string = null;
                        while ((string = bufferedReader.readLine()) != null) {
                            ((StringBuilder)object).append(string);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fileReader != null) {
                            if (throwable != null) {
                                try {
                                    fileReader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                fileReader.close();
                            }
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println(fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                }
                geometry = Toolkit.GeoJsonToGeometry((String)((StringBuilder)object).toString());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return geometry;
    }
}

