/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing.cache;

import com.supermap.data.Workspace;
import com.supermap.data.WorkspaceConnectionInfo;
import com.supermap.data.processing.MapCacheBuilder;
import com.supermap.data.processing.cache.LogWriter;
import com.supermap.data.processing.cache.SubprocessThread;
import com.supermap.mapping.Map;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MultiProcessCacheBuilder {
    public static void main(String[] args) throws Exception {
        File file;
        if (args.length < 4) {
            System.out.println("please input args: workspaceFile mapName taskList cacheRoot processCount[options] mergeCount[options]");
            return;
        }
        String string = args[0];
        String string2 = args[1];
        String string3 = args[2];
        String string4 = args[3];
        int n = 3;
        if (args.length > 4) {
            n = Integer.valueOf(args[4]);
        }
        int n2 = 1;
        if (args.length > 5) {
            n2 = Integer.valueOf(args[5]);
        }
        if (!(file = new File(new File(string3).getParent() + "/done")).exists()) {
            file.mkdir();
        }
        if (string3.toLowerCase().endsWith(".sci")) {
            MultiProcessCacheBuilder.Run(string, string2, string3, string4);
        } else {
            LogWriter.setWriteToFile(true);
            LogWriter logWriter = LogWriter.getInstance();
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string5 = inetAddress.getHostName();
            String string6 = inetAddress.getHostAddress();
            logWriter.writelog(String.format("Run Workspace:%s Map:%s Tasks:%s CacheRoot%s processCount:%d mergeCount:%d, at computer:%s, ip:%s", string, string2, string3, string4, n, n2, string5, string6));
            File file2 = new File(string3);
            String string7 = null;
            ArrayList<String> arrayList = null;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), "UTF-8"));){
                String string8;
                Object var17_17 = null;
                string7 = file2.getParent();
                arrayList = new ArrayList<String>();
                while ((string8 = bufferedReader.readLine()) != null) {
                    arrayList.add(string8);
                }
            }
            if (n < 2) {
                MultiProcessCacheBuilder.RunAllCurrentProc(arrayList, string7, string, string2, string4);
            } else {
                MultiProcessCacheBuilder.RunAllMultiProc(arrayList, string7, string, string2, string4, n, n2);
            }
        }
    }

    public static void RunBySubProc(List<String> allTasks, String sciFolder, String workspaceFile, String mapName, String cacheRoot, int processCount, int mergeCount) throws Exception {
        Object object;
        int n;
        LogWriter logWriter = LogWriter.getInstance();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> list = runtimeMXBean.getInputArguments();
        List<SubprocessThread> list2 = Collections.synchronizedList(new ArrayList());
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = allTasks.size();
        int n4 = n3 - 1;
        for (n = 0; n < n3; ++n) {
            String string = allTasks.get(n);
            string = sciFolder + "/" + string;
            object = new File(string);
            if (!((File)object).exists()) {
                LogWriter.getInstance().writelog(String.format("sciFile: %s does not exist. Maybe has done at before running. ", string));
                continue;
            }
            stringBuffer.append(";");
            stringBuffer.append(string);
            if (++n2 < mergeCount && n != n4) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("java");
            arrayList.addAll(list);
            arrayList.add("-cp");
            arrayList.add(System.getProperty("java.class.path"));
            arrayList.add(MultiProcessCacheBuilder.class.getName());
            arrayList.add(workspaceFile);
            arrayList.add(mapName);
            arrayList.add(stringBuffer.substring(1));
            arrayList.add(cacheRoot);
            stringBuffer = new StringBuffer();
            n2 = 0;
            SubprocessThread subprocessThread = new SubprocessThread(arrayList);
            list2.add(subprocessThread);
            subprocessThread.start();
            while (list2.size() >= processCount) {
                int n5 = list2.size();
                for (int i = n5 - 1; i > -1; --i) {
                    SubprocessThread subprocessThread2 = (SubprocessThread)list2.get(i);
                    subprocessThread2.timeout();
                    if (!subprocessThread2.isExit) continue;
                    list2.remove(i);
                }
                Thread.sleep(1000L);
                logWriter.flush();
            }
        }
        logWriter.flush();
        while (list2.size() > 0) {
            n = list2.size();
            for (int i = n - 1; i > -1; --i) {
                object = (SubprocessThread)list2.get(i);
                ((SubprocessThread)object).timeout();
                if (!((SubprocessThread)object).isExit) continue;
                list2.remove(i);
            }
            Thread.sleep(1000L);
            logWriter.flush();
        }
        logWriter.flush();
    }

    public static void RunAllMultiProc(List<String> allTasks, String sciFolder, String workspaceFile, String mapName, String cacheRoot, int processCount, int mergeCount) throws Exception {
        Object object;
        LogWriter logWriter = LogWriter.getInstance();
        long l = System.currentTimeMillis();
        MultiProcessCacheBuilder.RunBySubProc(allTasks, sciFolder, workspaceFile, mapName, cacheRoot, processCount, mergeCount);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object2 : allTasks) {
            String string = sciFolder + "/" + object2;
            object = new File(string);
            if (!((File)object).exists()) continue;
            arrayList.add(object2);
            LogWriter.getInstance().writelog(String.format("the failure sciFile: %s try again", string));
        }
        int n = arrayList.size() / processCount;
        if (n < 4) {
            n = 4;
        }
        MultiProcessCacheBuilder.RunBySubProc(arrayList, sciFolder, workspaceFile, mapName, cacheRoot, processCount, n);
        for (String string : arrayList) {
            object = sciFolder + "/" + string;
            File file = new File((String)object);
            if (!file.exists()) continue;
            LogWriter.getInstance().writelog(String.format("sciFile: %s fail.", object));
        }
        long l2 = System.currentTimeMillis() - l;
        object = String.format("sci File count:%d, cost(ms):%d", allTasks.size(), l2);
        logWriter.writelog((String)object);
        logWriter.flush();
        logWriter.closs();
        System.out.println((String)object);
    }

    public static void RunAllCurrentProc(List<String> allTasks, String sciFolder, String workspaceFile, String mapName, String cacheRoot) {
        File file;
        String string;
        for (String string2 : allTasks) {
            String object22 = sciFolder + "/" + string2;
            File file2 = new File(object22);
            if (!file2.exists()) {
                LogWriter.getInstance().writelog(String.format("sciFile: %s does not exist. Maybe has done at before running. ", object22));
                continue;
            }
            MultiProcessCacheBuilder.Run(workspaceFile, mapName, object22, cacheRoot);
        }
        ArrayList arrayList = new ArrayList();
        for (String string3 : allTasks) {
            string = sciFolder + "/" + string3;
            file = new File(string);
            if (!file.exists()) continue;
            arrayList.add(string3);
            LogWriter.getInstance().writelog(String.format("the failure sciFile: %s try again", string));
            MultiProcessCacheBuilder.Run(workspaceFile, mapName, string, cacheRoot);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            string = sciFolder + "/" + string4;
            file = new File(string);
            if (!file.exists()) continue;
            LogWriter.getInstance().writelog(String.format("sciFile: %s fail.", string));
        }
    }

    public static void Run(String workspaceFile, String mapName, String sciFiles, String targetRoot) {
        long l = System.currentTimeMillis();
        LogWriter logWriter = LogWriter.getInstance();
        String string = LogWriter.getPID();
        String[] stringArray = sciFiles.split(";");
        Workspace workspace = new Workspace();
        WorkspaceConnectionInfo workspaceConnectionInfo = new WorkspaceConnectionInfo(workspaceFile);
        workspace.open(workspaceConnectionInfo);
        Map map = new Map(workspace);
        map.open(mapName);
        logWriter.writelog(String.format("start sciCount:%d , PID:%s", stringArray.length, string));
        logWriter.writelog(String.format("init PID:%s, cost(ms):%d", LogWriter.getPID(), System.currentTimeMillis() - l));
        for (String string2 : stringArray) {
            boolean bl;
            long l2 = System.currentTimeMillis();
            File file = new File(string2);
            if (!file.exists()) {
                LogWriter.getInstance().writelog(String.format("sciFile: %s does not exist. Maybe has done at before running. ", string2));
                continue;
            }
            MapCacheBuilder mapCacheBuilder = new MapCacheBuilder();
            mapCacheBuilder.setMap(map);
            mapCacheBuilder.fromConfigFile(string2);
            mapCacheBuilder.setOutputFolder(targetRoot);
            mapCacheBuilder.resumable(false);
            boolean bl2 = mapCacheBuilder.buildWithoutConfigFile();
            String string3 = file.getParent() + "/done";
            if (bl2 && !(bl = file.renameTo(new File(string3, file.getName())))) {
                System.out.println("rename Failed!");
            }
            mapCacheBuilder.dispose();
            long l3 = System.currentTimeMillis();
            logWriter.writelog(String.format("%s %s done,PID:%s, cost(ms):%d, done", string2, String.valueOf(bl2), LogWriter.getPID(), l3 - l2));
            logWriter.flush();
        }
        map.close();
        map.dispose();
        workspace.dispose();
    }
}

