/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.tilestorage;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Rectangle2D;
import com.supermap.tilestorage.InternalResource;
import com.supermap.tilestorage.TileVersionNative;
import java.util.Date;

public class TileVersion
extends InternalHandleDisposable {
    TileVersion(long handle) {
        this.setHandle(handle, true);
    }

    static final TileVersion createInstance(long handle) {
        if (handle == 0L) {
            return null;
        }
        TileVersion tileVersion = null;
        tileVersion = new TileVersion(handle);
        if (tileVersion != null) {
            tileVersion.setIsDisposable(true);
        }
        return tileVersion;
    }

    public TileVersion() {
        long l = TileVersionNative.jni_New();
        this.setHandle(l, true);
    }

    public TileVersion(String name, String desc, String parent, Date timetense, double[] resolutions, Rectangle2D bounds) {
        long l = TileVersionNative.jni_New();
        this.setHandle(l, true);
        this.setName(name);
        this.setDesc(desc);
        this.setParent(parent);
        this.setTimetense(timetense);
        this.setResolutions(resolutions);
        this.setBounds(bounds);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        return TileVersionNative.jni_GetName(this.getHandle());
    }

    public void setName(String name) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setName()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalArgumentException(string);
        }
        TileVersionNative.jni_SetName(this.getHandle(), name);
    }

    public String getDesc() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDesc()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        return TileVersionNative.jni_GetDesc(this.getHandle());
    }

    public void setDesc(String desc) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDesc()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalArgumentException(string);
        }
        TileVersionNative.jni_SetDesc(this.getHandle(), desc);
    }

    public String getParent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getParent()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        return TileVersionNative.jni_GetParent(this.getHandle());
    }

    public void setParent(String parent) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setParent()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalArgumentException(string);
        }
        TileVersionNative.jni_SetParent(this.getHandle(), parent);
    }

    public Date getTimetense() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTimetense()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        long l = TileVersionNative.jni_GetTimetense(this.getHandle());
        return new Date(1000L * l);
    }

    public void setTimetense(Date timetense) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTimetense()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalArgumentException(string);
        }
        TileVersionNative.jni_SetTimetense(this.getHandle(), timetense.getTime() / 1000L);
    }

    public double[] getResolutions() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getResolutions()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        int n = TileVersionNative.jni_GetResolutionCount(this.getHandle());
        if (n > 0) {
            double[] dArray = new double[n];
            TileVersionNative.jni_GetResolutions(this.getHandle(), dArray);
            return dArray;
        }
        return null;
    }

    public void setResolutions(double[] resolutions) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setResolutions()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalArgumentException(string);
        }
        TileVersionNative.jni_SetResolutions(this.getHandle(), resolutions);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        TileVersionNative.jni_GetBounds(this.getHandle(), dArray);
        return new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    public void setBounds(Rectangle2D bounds) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBounds()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[]{bounds.getLeft(), bounds.getBottom(), bounds.getRight(), bounds.getTop()};
        TileVersionNative.jni_SetBounds(this.getHandle(), dArray);
    }

    public double[] getScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getScales()", "Handle_ObjectHasBeenDisposed", "tilestorage_resources");
            throw new IllegalStateException(string);
        }
        int n = TileVersionNative.jni_GetScaleCount(this.getHandle());
        if (n > 0) {
            double[] dArray = new double[n];
            TileVersionNative.jni_GetScales(this.getHandle(), dArray);
            return dArray;
        }
        return null;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "tilestorage_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            TileVersionNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }
}

