/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.layout;

import com.supermap.layout.InternalEnum;
import com.supermap.layout.InternalGridSetting;
import com.supermap.layout.InternalHandle;
import com.supermap.layout.InternalResource;
import com.supermap.layout.MapLayout;
import com.supermap.layout.PaperMargin;
import com.supermap.layout.PaperNative;
import com.supermap.layout.PaperOrientation;
import com.supermap.layout.PaperSize;
import com.supermap.mapping.GridSetting;
import java.awt.Color;

public class Paper {
    private MapLayout m_mapLayout;
    private PaperOrientation m_paperOrientation;
    private PaperSize m_paperSize;
    private PaperMargin m_paperMargin;
    private GridSetting m_gridSetting;

    Paper(MapLayout mapLayout) {
        this.m_mapLayout = mapLayout;
        this.m_paperMargin = null;
    }

    public Color getBackgroundColor() {
        Color color = null;
        if (this.m_mapLayout != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
                String string = InternalResource.loadString("getBackgroundColor()", "Handle_ObjectHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            int n = PaperNative.jni_getBackgroundColor(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout));
            color = new Color(n, true);
        }
        return color;
    }

    public void setBackgroundColor(Color color) {
        if (this.m_mapLayout != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
                String string = InternalResource.loadString("setBackgroundColor(Color color)", "Handle_ObjectHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            PaperNative.jni_SetBackgroundColor(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout), color.getRGB());
        }
    }

    public PaperOrientation getOrientation() {
        if (this.m_mapLayout != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
                String string = InternalResource.loadString("getOrientation()", "Handle_ObjectHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            int n = PaperNative.jni_getOrientation(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout));
            if (n != -1) {
                this.m_paperOrientation = (PaperOrientation)InternalEnum.parseUGCValue(PaperOrientation.class, n);
            }
        }
        return this.m_paperOrientation;
    }

    public void setOrientation(PaperOrientation paperOrientation) {
        if (this.m_mapLayout != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
                String string = InternalResource.loadString("setOrientation(PaperOrientation paperOrientation)", "Global_OwnerHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            PaperNative.jni_setOrientation(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout), paperOrientation.value());
        }
    }

    public double getWidth() {
        double d = 0.0;
        if (this.m_mapLayout != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
                String string = InternalResource.loadString("getWidth()", "Handle_ObjectHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            d = this.getOrientation() == PaperOrientation.LANDSCAPE ? PaperNative.jni_getHeight(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout)) : PaperNative.jni_getWidth(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout));
        }
        return d;
    }

    public void setWidth(double value) {
        if (this.m_mapLayout != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
                String string = InternalResource.loadString("setWidth(double value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            if (value <= 0.0) {
                String string = InternalResource.loadString("setWidth(double value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            PaperNative.jni_setWidth(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout), value, this.getHeight());
        }
    }

    public double getHeight() {
        double d = 0.0;
        if (this.m_mapLayout != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
                String string = InternalResource.loadString("getHeight()", "Handle_ObjectHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            d = this.getOrientation() == PaperOrientation.LANDSCAPE ? PaperNative.jni_getWidth(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout)) : PaperNative.jni_getHeight(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout));
        }
        return d;
    }

    public void setHeight(double value) {
        if (this.m_mapLayout != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
                String string = InternalResource.loadString("setHeight(double value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            if (value <= 0.0) {
                String string = InternalResource.loadString("setHeight(double value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            PaperNative.jni_setHeight(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout), value, this.getWidth());
        }
    }

    public PaperSize getSize() {
        if (this.m_mapLayout != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
                String string = InternalResource.loadString("getSize()", "Handle_ObjectHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            int n = PaperNative.jni_getSize(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout));
            if (n < 0) {
                n = -n;
            }
            this.m_paperSize = (PaperSize)InternalEnum.parseUGCValue(PaperSize.class, n);
        }
        return this.m_paperSize;
    }

    public void setSize(PaperSize paperSize) {
        if (this.m_mapLayout != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
                String string = InternalResource.loadString("setSize(PaperSize paperSize)", "Handle_ObjectHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            int n = paperSize.value();
            if (this.getOrientation().equals((Object)PaperOrientation.LANDSCAPE)) {
                n = -n;
            }
            PaperNative.jni_setSize(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout), n);
        }
    }

    public PaperMargin getMargin() {
        if (this.m_mapLayout != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
            String string = InternalResource.loadString("getMargin()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_paperMargin == null) {
            int[] nArray = new int[4];
            PaperNative.jni_getMargin(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout), nArray);
            this.m_paperMargin = new PaperMargin(nArray[0], nArray[2], nArray[1], nArray[3]);
        }
        return this.m_paperMargin;
    }

    public void setMargin(PaperMargin paperMargin) {
        if (this.m_mapLayout != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
            String string = InternalResource.loadString("getMargin()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        this.m_paperMargin = new PaperMargin(paperMargin);
        PaperNative.jni_setMargin(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout), this.m_paperMargin.getLeft(), this.m_paperMargin.getTop(), this.m_paperMargin.getRight(), this.m_paperMargin.getBottom());
    }

    public GridSetting getGrid() {
        if (this.m_mapLayout != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
            String string = InternalResource.loadString("getGrid()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_gridSetting == null) {
            this.m_gridSetting = new InternalGridSetting(this.m_mapLayout);
        }
        return this.m_gridSetting;
    }

    public void setGrid(GridSetting setting) {
        if (this.m_mapLayout != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
            String string = InternalResource.loadString("setGrid(GridSetting setting)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        this.m_gridSetting = new InternalGridSetting(this.m_mapLayout);
        this.m_gridSetting.setVisible(setting.isVisible());
        this.m_gridSetting.setSnapable(setting.isSnapable());
        this.m_gridSetting.setHorizontalSpacing(setting.getHorizontalSpacing());
        this.m_gridSetting.setVerticalSpacing(setting.getVerticalSpacing());
    }

    public boolean isVisible() {
        if (this.m_mapLayout != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
            String string = InternalResource.loadString("isVisible", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return PaperNative.jni_IsVisible(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout));
    }

    public void setVisible(boolean value) {
        if (this.m_mapLayout != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
            String string = InternalResource.loadString("setVisible", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        PaperNative.jni_SetVisible(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout), value);
    }

    public Color getMarginDashColor() {
        Color color = null;
        if (this.m_mapLayout != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
                String string = InternalResource.loadString("getMarginDashColor()", "Handle_ObjectHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            int n = PaperNative.jni_getMarginDashColor(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout));
            color = new Color(n, true);
        }
        return color;
    }

    public void setMarginDashColor(Color color) {
        if (this.m_mapLayout != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
                String string = InternalResource.loadString("setMarginDashColor(Color color)", "Handle_ObjectHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            PaperNative.jni_SetMarginDashColor(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout), color.getRGB());
        }
    }

    public Color getMarginSolidColor() {
        Color color = null;
        if (this.m_mapLayout != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
                String string = InternalResource.loadString("getMarginSolidColor()", "Handle_ObjectHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            int n = PaperNative.jni_getMarginSolidColor(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout));
            color = new Color(n, true);
        }
        return color;
    }

    public void setMarginSolidColor(Color color) {
        if (this.m_mapLayout != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
                String string = InternalResource.loadString("setMarginSolidColor(Color color)", "Handle_ObjectHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            PaperNative.jni_SetMarginSolidColor(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout), color.getRGB());
        }
    }

    public Color getPaperShadowColor() {
        Color color = null;
        if (this.m_mapLayout != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
                String string = InternalResource.loadString("getPaperShadowColor()", "Handle_ObjectHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            int n = PaperNative.jni_getPaperShadowColor(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout));
            color = new Color(n, true);
        }
        return color;
    }

    public void setPaperShadowColor(Color color) {
        if (this.m_mapLayout != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout) == 0L) {
                String string = InternalResource.loadString("setPaperShadowColor(Color color)", "Handle_ObjectHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            PaperNative.jni_SetPaperShadowColor(InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_mapLayout), color.getRGB());
        }
    }
}

