/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy;

import com.supermap.data.Colors;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.Datasource;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoPoint3D;
import com.supermap.data.GeometriesRelation;
import com.supermap.data.Geometrist;
import com.supermap.data.Geometry;
import com.supermap.data.Recordset;
import java.awt.Point;
import java.util.ArrayList;

final class Utils {
    Utils() {
    }

    public static void GeometriesRelation_InsertRecordset(GeometriesRelation geoRelation, Recordset rd, String fieldName) {
        int nFieldIndex = -1;
        if (fieldName != null) {
            nFieldIndex = rd.getFieldInfos().indexOf(fieldName);
        }
        while (!rd.isEOF()) {
            Geometry geo = rd.getGeometry();
            if (geo != null) {
                int nID = -1;
                nID = nFieldIndex != -1 ? ((Integer)rd.getFieldValue(nFieldIndex)).intValue() : rd.getID();
                if (nID >= 0) {
                    geoRelation.insert(geo, nID);
                } else {
                    geo.dispose();
                }
            }
            rd.moveNext();
        }
    }

    public static DatasetVector AltitudeStatistics(DatasetVector pointDataset, DatasetGrid datasetGrid, Datasource outputDatasource, String outputDatasetName) {
        DatasetVectorInfo dtInfo = new DatasetVectorInfo(outputDatasetName, DatasetType.POINT3D);
        DatasetVector resultPoint3D = outputDatasource.getDatasets().create(dtInfo);
        if (resultPoint3D == null) {
            return null;
        }
        resultPoint3D.open();
        pointDataset.open();
        datasetGrid.open();
        resultPoint3D.setPrjCoordSys(pointDataset.getPrjCoordSys());
        Recordset sourcePointRecordset = pointDataset.query(datasetGrid.getBounds(), CursorType.STATIC);
        if (sourcePointRecordset == null) {
            outputDatasource.getDatasets().delete(outputDatasetName);
            return null;
        }
        Recordset resultPoint3DRecordset = resultPoint3D.getRecordset(true, CursorType.DYNAMIC);
        if (resultPoint3DRecordset == null) {
            sourcePointRecordset.dispose();
            outputDatasource.getDatasets().delete(outputDatasetName);
            return null;
        }
        resultPoint3DRecordset.getBatch().begin();
        while (!sourcePointRecordset.isEOF()) {
            GeoPoint geo = (GeoPoint)sourcePointRecordset.getGeometry();
            Point gridPoint = datasetGrid.xyToGrid(geo.getInnerPoint());
            double altitude = datasetGrid.getNoValue();
            if (gridPoint.getX() < (double)datasetGrid.getWidth() && gridPoint.getX() >= 0.0 && gridPoint.getY() < (double)datasetGrid.getHeight() && gridPoint.getY() >= 0.0) {
                altitude = datasetGrid.getValue((int)gridPoint.getX(), (int)gridPoint.getY());
            }
            GeoPoint3D geoPoint3D = new GeoPoint3D(geo.getX(), geo.getY(), altitude);
            resultPoint3DRecordset.addNew((Geometry)geoPoint3D);
            sourcePointRecordset.moveNext();
        }
        resultPoint3DRecordset.getBatch().update();
        resultPoint3DRecordset.dispose();
        sourcePointRecordset.dispose();
        return resultPoint3D;
    }

    public static Colors ColorsMakeRandom(int count) {
        return Colors.makeRandom((int)count);
    }

    public static DatasetVector simplifyBuilding(DatasetVector srcDataset, Datasource datasource, String destName, double widthThreshold, double heightThreshold, boolean isDeleteFailed) {
        if (srcDataset == null || srcDataset.getType() != DatasetType.REGION) {
            return null;
        }
        DatasetVector destDataset = (DatasetVector)datasource.copyDataset((Dataset)srcDataset, destName, srcDataset.getEncodeType());
        if (destDataset == null) {
            return null;
        }
        destDataset.open();
        Recordset recordset = destDataset.getRecordset(false, CursorType.DYNAMIC);
        if (recordset == null) {
            return null;
        }
        recordset.getBatch().begin();
        ArrayList<Integer> deleteIDs = new ArrayList<Integer>();
        while (!recordset.isEOF()) {
            Geometry geo = recordset.getGeometry();
            if (geo != null) {
                Geometry resGeometry = Geometrist.orthogonalPolygonFitting((Geometry)geo, (double)widthThreshold, (double)heightThreshold);
                if (resGeometry != null) {
                    recordset.setGeometry(resGeometry);
                } else if (isDeleteFailed) {
                    deleteIDs.add(recordset.getID());
                }
                geo.dispose();
            }
            recordset.moveNext();
        }
        recordset.getBatch().update();
        recordset.dispose();
        if (isDeleteFailed && deleteIDs.size() > 0) {
            int[] ids = new int[deleteIDs.size()];
            for (int i = 0; i < deleteIDs.size(); ++i) {
                ids[i] = (Integer)deleteIDs.get(i);
            }
            destDataset.deleteRecords(ids);
        }
        return destDataset;
    }
}

