/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.threeddesigner;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.Environment;
import com.supermap.data.Model;
import com.supermap.realspace.threeddesigner.InternalHandle;
import com.supermap.realspace.threeddesigner.InternalResource;
import com.supermap.realspace.threeddesigner.InternalToolkitThreeDDesigner;
import com.supermap.realspace.threeddesigner.ModelConvertorNative;
import com.supermap.realspace.threeddesigner.ModelFileSetting;
import java.io.File;
import java.util.ArrayList;

public abstract class ModelConvertor {
    private static License m_license;

    public static boolean fromFile(Model model, ModelFileSetting setting) {
        if (null == model) {
            String string = InternalResource.loadString("model", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)model);
        if (0L == l) {
            String string = InternalResource.loadString("model", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (setting == null) {
            String string = InternalResource.loadString("setting", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        File file = new File(setting.getFilePath());
        if (!file.exists()) {
            String string = InternalResource.loadString("file", "File_NotFound", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        return ModelConvertorNative.jni_FromFile(l, setting.getFilePath(), setting.getIgnoreLOD());
    }

    public static boolean toFile(Model model, ModelFileSetting setting) {
        if (null == model) {
            String string = InternalResource.loadString("model", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)model);
        if (0L == l) {
            String string = InternalResource.loadString("model", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (setting == null) {
            String string = InternalResource.loadString("setting", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (setting.getFilePath() == null) {
            String string = InternalResource.loadString("file", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        return ModelConvertorNative.jni_ToFile(l, setting.getFilePath(), setting.getIgnoreLOD());
    }

    static {
        Environment.LoadWrapJ();
        ArrayList<ProductType> arrayList = InternalToolkitThreeDDesigner.managerProducts(InternalToolkitThreeDDesigner.getThreeDDesignerProducts());
        m_license = InternalToolkitThreeDDesigner.verifyLicense(arrayList);
    }
}

