/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.threeddesigner;

import com.supermap.data.ColorDictionary;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.realspace.threeddesigner.InternalColorDict;
import com.supermap.realspace.threeddesigner.InternalHandle;
import com.supermap.realspace.threeddesigner.InternalResource;
import com.supermap.realspace.threeddesigner.ShadowQuerySettingNative;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class SunlightAnalysisSetting
extends InternalHandleDisposable {
    private Datasource m_pointDatasource;
    private String m_strName;

    public SunlightAnalysisSetting() {
        long l = ShadowQuerySettingNative.jni_New();
        this.setHandle(l, true);
        this.m_pointDatasource = null;
    }

    public double getSubdivisionThreshold() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowQuerySetting", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        return ShadowQuerySettingNative.jni_GetSegemetThreshold(this.getHandle());
    }

    public void setSubdivisionThreshold(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowQuerySetting", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (value < 0.001) {
            String string = InternalResource.loadString("value", "ArgumentInvalid", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        ShadowQuerySettingNative.jni_SetSegemetThreshold(this.getHandle(), value);
    }

    public double getDistanceThreshold() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowQuerySetting", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        return ShadowQuerySettingNative.jni_GetDistanceThreshold(this.getHandle());
    }

    public void setDistanceThreshold(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowQuerySetting", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (value < 0.001) {
            String string = InternalResource.loadString("value", "ArgumentInvalid", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        ShadowQuerySettingNative.jni_SetDistanceThreshold(this.getHandle(), value);
    }

    public void setBaseUtcOffset(TimeZone value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowQuerySetting", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        int n = -((int)((double)value.getRawOffset() / 60000.0));
        ShadowQuerySettingNative.jni_SetBaseUtcOffset(this.getHandle(), n);
    }

    public TimeZone getBaseUtcOffset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowQuerySetting", "Global_ArgumentObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalArgumentException(string);
        }
        int n = ShadowQuerySettingNative.jni_GetBaseUtcOffset(this.getHandle());
        String[] stringArray = TimeZone.getAvailableIDs(-(n * 1000 * 60));
        return TimeZone.getTimeZone(stringArray[0]);
    }

    public void setStartTime(Calendar value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowQuerySetting", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        String string = String.format("%1$tY-%1$tm-%1$td %1$tT", value);
        ShadowQuerySettingNative.jni_SetStartTime(this.getHandle(), string);
    }

    public Calendar getStartTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowQuerySetting", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        String string = ShadowQuerySettingNative.jni_GetStartTime(this.getHandle());
        return this.dateTimeStringToCalendar(string);
    }

    public void setEndTime(Calendar value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowQuerySetting", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        String string = String.format("%1$tY-%1$tm-%1$td %1$tT", value);
        ShadowQuerySettingNative.jni_SetEndTime(this.getHandle(), string);
    }

    public Calendar getEndTime() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowQuerySetting", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        String string = ShadowQuerySettingNative.jni_GetEndTime(this.getHandle());
        return this.dateTimeStringToCalendar(string);
    }

    public int getTimeInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowQuerySetting", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        return ShadowQuerySettingNative.jni_GetTimeInterval(this.getHandle());
    }

    public void setTimeInterval(int minutes) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowQuerySetting", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        ShadowQuerySettingNative.jni_SetTimeInterval(this.getHandle(), minutes);
    }

    public void setColorDictTable(ColorDictionary colorTable) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowQuerySetting", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        if (colorTable == null) {
            String string = InternalResource.loadString("colorTable", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)colorTable);
        ShadowQuerySettingNative.jni_SetColorDictTable(this.getHandle(), l);
    }

    public ColorDictionary getColorDictTable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowQuerySetting", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        ColorDictionary colorDictionary = null;
        long l = ShadowQuerySettingNative.jni_GetColorDictTable(this.getHandle());
        if (l != 0L) {
            colorDictionary = InternalColorDict.createInstance(l);
        }
        return colorDictionary;
    }

    public void setQueryDatasets(ArrayList<DatasetVector> value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ShadowQuerySetting", "Handle_ObjectHasBeenDisposed", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "ThreeDDesigner_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = new long[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)value.get(i));
        }
        ShadowQuerySettingNative.jni_SetQueryDatasets(this.getHandle(), lArray);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "ThreeDDesigner_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ShadowQuerySettingNative.jni_Delete(this.getHandle());
            this.m_pointDatasource = null;
            this.clearHandle();
        }
    }

    private Calendar dateTimeStringToCalendar(String dateTime) {
        String[] stringArray = dateTime.trim().split(" ");
        String[] stringArray2 = stringArray[0].trim().split("-");
        String[] stringArray3 = stringArray[1].trim().split(":");
        int n = Integer.parseInt(stringArray2[0]);
        int n2 = Integer.parseInt(stringArray2[1]);
        int n3 = Integer.parseInt(stringArray2[2]);
        int n4 = Integer.parseInt(stringArray3[0]);
        int n5 = Integer.parseInt(stringArray3[1]);
        int n6 = Integer.parseInt(stringArray3[2]);
        return new GregorianCalendar(n, n2 - 1, n3, n4, n5, n6);
    }
}

