/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Charset;
import com.supermap.data.conversion.ExportSetting;
import com.supermap.data.conversion.FileType;
import com.supermap.data.conversion.InternalResource;

public class ExportSettingCSV
extends ExportSetting {
    private boolean m_bExportPointAsWKT;
    private boolean m_bIsExportFieldName;

    public ExportSettingCSV() {
        this.m_bExportPointAsWKT = false;
        this.m_bIsExportFieldName = false;
        this.setTargetFileType(FileType.CSV);
        this.setTargetFileCharset(Charset.UTF8);
    }

    public ExportSettingCSV(ExportSettingCSV exportSettingCSV) {
        super(exportSettingCSV);
        this.m_bExportPointAsWKT = exportSettingCSV.m_bExportPointAsWKT;
        this.m_bIsExportFieldName = exportSettingCSV.m_bIsExportFieldName;
        this.setTargetFileCharset(exportSettingCSV.getTargetFileCharset());
    }

    public ExportSettingCSV(Object sourceData, String targetFilePath) {
        super(sourceData, targetFilePath, FileType.CSV);
        this.m_bExportPointAsWKT = false;
        this.m_bIsExportFieldName = false;
        this.setTargetFileCharset(Charset.UTF8);
    }

    @Override
    public void setTargetFileType(FileType type) {
        if (type != FileType.CSV) {
            String string = InternalResource.loadString("setTargetFileType(FileType type)", "SetTargetFileTypeIsNotAllowed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        super.setTargetFileType(type);
    }

    public void setIsExportPointAsWKT(boolean value) {
        this.m_bExportPointAsWKT = value;
    }

    public boolean GetIsExportPointAsWKT() {
        return this.m_bExportPointAsWKT;
    }

    public void setIsExportFieldName(boolean value) {
        this.m_bIsExportFieldName = value;
    }

    public boolean getIsExportFieldName() {
        return this.m_bIsExportFieldName;
    }
}

