/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.trafficanalyst;

import com.supermap.analyst.trafficanalyst.InternalHandle;
import com.supermap.analyst.trafficanalyst.InternalResource;
import com.supermap.analyst.trafficanalyst.RelationSettingNative;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasets;
import com.supermap.data.Datasource;
import com.supermap.data.FieldType;

public class RelationSetting {
    private DatasetVector m_dataset;
    private String m_lineIDField;
    private String m_stopIDField;
    private String m_serialNumField;
    private String m_exitIDField;
    private String m_stationIDField;
    private String m_exitNameCField;
    private String m_exitNamePYField;
    private DatasetVector m_datasetPath;
    private DatasetVector m_networkDataset;
    private String m_nodeIDField;
    private String m_edgeIDField;
    private String m_fNodeIDField;
    private String m_tNodeIDField;

    public RelationSetting() {
        this.m_dataset = null;
        this.m_lineIDField = "";
        this.m_stopIDField = "";
        this.m_serialNumField = "";
        this.m_datasetPath = null;
        this.m_exitIDField = "";
        this.m_stationIDField = "";
        this.m_exitNameCField = "";
        this.m_exitNamePYField = "";
        this.m_networkDataset = null;
        this.m_nodeIDField = "";
        this.m_edgeIDField = "";
        this.m_fNodeIDField = "";
        this.m_tNodeIDField = "";
    }

    public RelationSetting(RelationSetting relationSetting) {
        this.setDataset(relationSetting.getDataset());
        this.setLineIDField(relationSetting.getLineIDField());
        this.setStopIDField(relationSetting.getStopIDField());
        this.setSerialNumField(relationSetting.getSerialNumField());
        if (relationSetting.getDatasetPath() != null) {
            this.setDatasetPath(relationSetting.getDatasetPath());
            this.setExitIDField(relationSetting.getExitIDField());
            this.setStationIDField(relationSetting.getStationIDField());
            this.setExitNameCField(relationSetting.getExitNameCField());
            if (relationSetting.getExitNamePYField() != null && relationSetting.getExitNamePYField().trim().length() != 0) {
                this.setExitNamePYField(relationSetting.getExitNamePYField());
            }
        }
        if (relationSetting.getDatasetNetwork() != null) {
            this.setDatasetNetwork(relationSetting.getDatasetNetwork());
            this.setNodeIDField(relationSetting.getNodeIDField());
            this.setEdgeIDField(relationSetting.getEdgeIDField());
            this.setFNodeIDField(relationSetting.getFNodeIDField());
            this.setTNodeIDField(relationSetting.getTNodeIDField());
        }
    }

    public DatasetVector getDataset() {
        return this.m_dataset;
    }

    public void setDataset(DatasetVector datasetVector) {
        this.m_dataset = datasetVector;
    }

    public String getLineIDField() {
        return this.m_lineIDField;
    }

    public void setLineIDField(String value) {
        this.m_lineIDField = value;
    }

    public String getStopIDField() {
        return this.m_stopIDField;
    }

    public void setStopIDField(String value) {
        this.m_stopIDField = value;
    }

    public String getSerialNumField() {
        return this.m_serialNumField;
    }

    public void setSerialNumField(String value) {
        this.m_serialNumField = value;
    }

    public DatasetVector getDatasetPath() {
        return this.m_datasetPath;
    }

    public void setDatasetPath(DatasetVector datasetVector) {
        this.m_datasetPath = datasetVector;
    }

    public String getExitIDField() {
        return this.m_exitIDField;
    }

    public void setExitIDField(String value) {
        this.m_exitIDField = value;
    }

    public String getStationIDField() {
        return this.m_stationIDField;
    }

    public void setStationIDField(String value) {
        this.m_stationIDField = value;
    }

    public String getExitNameCField() {
        return this.m_exitNameCField;
    }

    public void setExitNameCField(String value) {
        this.m_exitNameCField = value;
    }

    public String getExitNamePYField() {
        return this.m_exitNamePYField;
    }

    public void setExitNamePYField(String value) {
        this.m_exitNamePYField = value;
    }

    public void setDatasetNetwork(DatasetVector value) {
        this.m_networkDataset = value;
    }

    public DatasetVector getDatasetNetwork() {
        return this.m_networkDataset;
    }

    public void setNodeIDField(String value) {
        this.m_nodeIDField = value;
    }

    public String getNodeIDField() {
        return this.m_nodeIDField;
    }

    public void setEdgeIDField(String value) {
        this.m_edgeIDField = value;
    }

    public String getEdgeIDField() {
        return this.m_edgeIDField;
    }

    public void setFNodeIDField(String value) {
        this.m_fNodeIDField = value;
    }

    public String getFNodeIDField() {
        return this.m_fNodeIDField;
    }

    public void setTNodeIDField(String value) {
        this.m_tNodeIDField = value;
    }

    public String getTNodeIDField() {
        return this.m_tNodeIDField;
    }

    void setRelationToUGC(long settingHandles) {
        this.checkRelation();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_dataset);
        RelationSettingNative.jni_SetRelationToUGC(settingHandles, l, this.m_lineIDField, this.m_stopIDField, this.m_serialNumField);
    }

    void setStopExitToUGC(long settingHandles) {
        this.checkStopExit();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_datasetPath);
        RelationSettingNative.jni_SetStopAndExitRelationToUGC(settingHandles, l, this.m_exitIDField, this.m_stationIDField, this.m_exitNameCField, this.m_exitNamePYField);
    }

    void setNetworkToUGC(long settingHandles) {
        this.checkNetwork();
        DatasetVector datasetVector = this.getDatasetNetwork();
        long l = 0L;
        if (datasetVector != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) != 0L) {
            DatasetType datasetType = datasetVector.getType();
            if (datasetType != DatasetType.NETWORK) {
                String string = InternalResource.loadString("m_analystSetting.getNetworkDataset().getType()", "TransportationAnalyst_DatasetTypeMustBeNetwork", "trafficanalyst_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
            String[] stringArray = new String[]{this.getNodeIDField(), this.getEdgeIDField(), this.getFNodeIDField(), this.getTNodeIDField()};
            String[] stringArray2 = new String[]{stringArray[0], stringArray[1], stringArray[2], stringArray[3]};
            if (!RelationSetting.isNetworkFieldsAllRight(stringArray2, datasetVector)) {
                String string = InternalResource.loadString("fields", "TransportationAnalystSetting_FieldIsNotInNetworkDataset", "trafficanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            RelationSettingNative.jni_SetNetworkToUGC(settingHandles, l, stringArray);
        }
    }

    void getRelationFromUGC(Datasource ds, long handle) {
        String string = RelationSettingNative.jni_GetRelationFieldsFromUGC(handle);
        int n = -1;
        int n2 = string.indexOf(",", 0);
        this.m_lineIDField = string.substring(n + 1, n2);
        n = string.indexOf(",", n + 1);
        n2 = string.indexOf(",", n2 + 1);
        this.m_stopIDField = string.substring(n + 1, n2);
        n = string.indexOf(",", n + 1);
        this.m_serialNumField = string.substring(n + 1);
        long l = RelationSettingNative.jni_GetRelationDataset(handle);
        Datasets datasets = ds.getDatasets();
        for (int i = 0; i < datasets.getCount(); ++i) {
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasets.get(i));
            if (l2 != l) continue;
            this.m_dataset = (DatasetVector)datasets.get(i);
            break;
        }
    }

    void getStopExitFromUGC(Datasource ds, long handle) {
        String string = RelationSettingNative.jni_GetStopAndExitFieldsFromUGC(handle);
        int n = -1;
        int n2 = string.indexOf(",", 0);
        this.m_exitIDField = string.substring(n + 1, n2);
        n = string.indexOf(",", n + 1);
        n2 = string.indexOf(",", n2 + 1);
        this.m_stationIDField = string.substring(n + 1, n2);
        n = string.indexOf(",", n + 1);
        n2 = string.indexOf(",", n2 + 1);
        this.m_exitNameCField = string.substring(n + 1, n2);
        n = string.indexOf(",", n + 1);
        this.m_exitNamePYField = string.substring(n + 1);
        long l = RelationSettingNative.jni_GetStopAndExitDataset(handle);
        Datasets datasets = ds.getDatasets();
        for (int i = 0; i < datasets.getCount(); ++i) {
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasets.get(i));
            if (l2 != l) continue;
            this.m_datasetPath = (DatasetVector)datasets.get(i);
            break;
        }
    }

    void getNetworkFromUGC(Datasource ds, long handle) {
        String string = RelationSettingNative.jni_GetNetworkFieldsFromUGC(handle);
        int n = -1;
        int n2 = string.indexOf(",", 0);
        this.m_nodeIDField = string.substring(n + 1, n2);
        n = string.indexOf(",", n + 1);
        n2 = string.indexOf(",", n2 + 1);
        this.m_edgeIDField = string.substring(n + 1, n2);
        n = string.indexOf(",", n + 1);
        n2 = string.indexOf(",", n2 + 1);
        this.m_fNodeIDField = string.substring(n + 1, n2);
        n = string.indexOf(",", n + 1);
        this.m_tNodeIDField = string.substring(n + 1);
        long l = RelationSettingNative.jni_GetNetworkDataset(handle);
        Datasets datasets = ds.getDatasets();
        for (int i = 0; i < datasets.getCount(); ++i) {
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasets.get(i));
            if (l2 != l) continue;
            this.m_networkDataset = (DatasetVector)datasets.get(i);
            break;
        }
    }

    void checkRelation() {
        if (this.m_dataset == null) {
            String string = InternalResource.loadString("m_dataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_dataset.getType() != DatasetType.TABULAR) {
            String string = InternalResource.loadString("datasetVector", "TransferAnalyst_DatasetTypeMustBeTabular", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_stopIDField == null || this.m_stopIDField.trim().length() == 0) {
            String string = InternalResource.loadString("m_stopIDField", "Global_StringIsNullOrEmpty", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_dataset.getFieldInfos().indexOf(this.m_stopIDField) == -1) {
            String string = InternalResource.loadString("m_stopIDField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_dataset.getFieldInfos().get(this.m_stopIDField).getType() != FieldType.INT32 && this.m_dataset.getFieldInfos().get(this.m_stopIDField).getType() != FieldType.INT64) {
            String string = InternalResource.loadString("m_stopIDField", "FieldType_UnSupport", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_lineIDField == null || this.m_lineIDField.trim().length() == 0) {
            String string = InternalResource.loadString("m_lineIDField", "Global_StringIsNullOrEmpty", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_dataset.getFieldInfos().indexOf(this.m_lineIDField) == -1) {
            String string = InternalResource.loadString("m_lineIDField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_dataset.getFieldInfos().get(this.m_lineIDField).getType() != FieldType.INT32 && this.m_dataset.getFieldInfos().get(this.m_lineIDField).getType() != FieldType.INT64) {
            String string = InternalResource.loadString("m_LineIDField", "FieldType_UnSupport", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_serialNumField != null && !this.m_serialNumField.trim().equals("") && this.m_dataset.getFieldInfos().indexOf(this.m_serialNumField) == -1) {
            String string = InternalResource.loadString("m_serialNumField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_serialNumField != null && !this.m_serialNumField.trim().equals("") && this.m_dataset.getFieldInfos().get(this.m_serialNumField).getType() != FieldType.INT32 && this.m_dataset.getFieldInfos().get(this.m_serialNumField).getType() != FieldType.INT64) {
            String string = InternalResource.loadString("m_serialNumField", "FieldType_UnSupport", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
    }

    void checkStopExit() {
        if (this.m_datasetPath == null) {
            String string = InternalResource.loadString("m_dataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_datasetPath.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("datasetVector", "TransferAnalyst_DatasetTypeMustBeTabular", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_stationIDField == null || this.m_stationIDField.trim().length() == 0) {
            String string = InternalResource.loadString("m_stationIDField", "Global_StringIsNullOrEmpty", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_datasetPath.getFieldInfos().indexOf(this.m_stationIDField) == -1) {
            String string = InternalResource.loadString("m_stationIDField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_datasetPath.getFieldInfos().get(this.m_stationIDField).getType() != FieldType.INT32 && this.m_datasetPath.getFieldInfos().get(this.m_stationIDField).getType() != FieldType.INT64) {
            String string = InternalResource.loadString("m_stationIDField", "FieldType_UnSupport", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_exitIDField == null || this.m_exitIDField.trim().length() == 0) {
            String string = InternalResource.loadString("m_exitIDField", "Global_StringIsNullOrEmpty", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_datasetPath.getFieldInfos().indexOf(this.m_exitIDField) == -1) {
            String string = InternalResource.loadString("m_exitIDField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_datasetPath.getFieldInfos().get(this.m_exitIDField).getType() != FieldType.INT32 && this.m_datasetPath.getFieldInfos().get(this.m_exitIDField).getType() != FieldType.INT64) {
            String string = InternalResource.loadString("m_exitIDField", "FieldType_UnSupport", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_exitNameCField == null || this.m_exitNameCField.trim().length() == 0) {
            String string = InternalResource.loadString("m_exitNameCField", "Global_StringIsNullOrEmpty", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_datasetPath.getFieldInfos().indexOf(this.m_exitNameCField) == -1) {
            String string = InternalResource.loadString("m_exitNameCField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_exitNamePYField != null && this.m_exitNamePYField.length() != 0 && this.m_datasetPath.getFieldInfos().indexOf(this.m_exitNamePYField) == -1) {
            String string = InternalResource.loadString("m_exitNamePYField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
    }

    void checkNetwork() {
        if (this.m_networkDataset == null) {
            String string = InternalResource.loadString("m_dataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_networkDataset.getType() != DatasetType.NETWORK) {
            String string = InternalResource.loadString("datasetVector", "NetworkBuilder_DatasetTypeMustBePoint", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_edgeIDField == null || this.m_edgeIDField.trim().length() == 0) {
            String string = InternalResource.loadString("m_edgeIDField", "Global_StringIsNullOrEmpty", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_networkDataset.getFieldInfos().indexOf(this.m_edgeIDField) == -1) {
            String string = InternalResource.loadString("m_edgeIDField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_networkDataset.getFieldInfos().get(this.m_edgeIDField).getType() != FieldType.INT32 && this.m_networkDataset.getFieldInfos().get(this.m_edgeIDField).getType() != FieldType.INT64) {
            String string = InternalResource.loadString("m_edgeIDField", "FieldType_UnSupport", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_fNodeIDField == null || this.m_fNodeIDField.trim().length() == 0) {
            String string = InternalResource.loadString("m_fNodeIDField", "Global_StringIsNullOrEmpty", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_networkDataset.getFieldInfos().indexOf(this.m_fNodeIDField) == -1) {
            String string = InternalResource.loadString("m_fNodeIDField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_networkDataset.getFieldInfos().get(this.m_fNodeIDField).getType() != FieldType.INT32 && this.m_networkDataset.getFieldInfos().get(this.m_fNodeIDField).getType() != FieldType.INT64) {
            String string = InternalResource.loadString("m_fNodeIDField", "FieldType_UnSupport", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_tNodeIDField == null || this.m_tNodeIDField.trim().length() == 0) {
            String string = InternalResource.loadString("m_tNodeIDField", "Global_StringIsNullOrEmpty", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_networkDataset.getFieldInfos().indexOf(this.m_tNodeIDField) == -1) {
            String string = InternalResource.loadString("m_tNodeIDField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_networkDataset.getFieldInfos().get(this.m_tNodeIDField).getType() != FieldType.INT32 && this.m_networkDataset.getFieldInfos().get(this.m_tNodeIDField).getType() != FieldType.INT64) {
            String string = InternalResource.loadString("m_tNodeIDField", "FieldType_UnSupport", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_nodeIDField == null || this.m_nodeIDField.trim().length() == 0) {
            String string = InternalResource.loadString("m_nodeIDField", "Global_StringIsNullOrEmpty", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_networkDataset.getChildDataset().getFieldInfos().indexOf(this.m_nodeIDField) == -1) {
            String string = InternalResource.loadString("m_nodeIDField", "Global_SpecifiedNameNotExist", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_networkDataset.getChildDataset().getFieldInfos().get(this.m_nodeIDField).getType() != FieldType.INT32 && this.m_networkDataset.getChildDataset().getFieldInfos().get(this.m_nodeIDField).getType() != FieldType.INT64) {
            String string = InternalResource.loadString("m_nodeIDField", "FieldType_UnSupport", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
    }

    private static boolean isNetworkFieldsAllRight(String[] fields, DatasetVector networkDataset) {
        boolean bl = true;
        if (!networkDataset.open()) {
            networkDataset.open();
        }
        if (networkDataset.getChildDataset().isAvailableFieldName(fields[0])) {
            return false;
        }
        int n = fields.length;
        for (int i = 1; i < n; ++i) {
            if (!networkDataset.isAvailableFieldName(fields[i])) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

