/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.GeoStyle3D;
import com.supermap.realspace.InternalGeoStyle3D;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.InternalToolkitSpace;
import com.supermap.realspace.Theme3DRange;
import com.supermap.realspace.ThemeRange3DNative;

public class Theme3DRangeItem {
    private double m_start;
    private double m_end;
    private boolean m_isVisible;
    private String m_caption;
    private GeoStyle3D m_style3D;
    private boolean isUserThemeRange3D;
    private Theme3DRange m_themeRange3D;
    private boolean m_modellingStyleEnable;

    public Theme3DRangeItem() {
        this(InternalToolkitSpace.FLT_MIN_VALUE, InternalToolkitSpace.FLT_MAX_VALUE, new GeoStyle3D(), "UntitledThemeRangeItem");
        this.m_modellingStyleEnable = false;
    }

    public Theme3DRangeItem(double start, double end, GeoStyle3D style) {
        this(start, end, style, "UntitledThemeRangeItem");
    }

    public Theme3DRangeItem(double start, double end, GeoStyle3D style, String caption) {
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)style) == 0L) {
            String string = InternalResource.loadString("style", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3D geoStyle3D = style.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoStyle3D, false);
        this.m_style3D = geoStyle3D;
        this.m_start = start;
        this.m_end = end;
        this.m_caption = caption;
        this.m_isVisible = true;
        this.isUserThemeRange3D = false;
        InternalHandleDisposable.makeSureNativeObjectLive((Object)style);
    }

    public Theme3DRangeItem(Theme3DRangeItem themeRange3DItem) {
        this(themeRange3DItem.getStart(), themeRange3DItem.getEnd(), themeRange3DItem.getStyle(), themeRange3DItem.getCaption());
        this.m_isVisible = themeRange3DItem.isVisible();
    }

    Theme3DRangeItem(Theme3DRange themeRange3D) {
        this.m_themeRange3D = themeRange3D;
        this.isUserThemeRange3D = true;
    }

    public double getStart() {
        if (this.isUserThemeRange3D) {
            int n = this.m_themeRange3D.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getStart()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange3D);
            if (l == 0L) {
                String string = InternalResource.loadString("getStart()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            this.m_start = ThemeRange3DNative.jni_GetValueAt(l, n);
        }
        return this.m_start;
    }

    public void setStart(double start) {
        if (this.isUserThemeRange3D) {
            int n = this.m_themeRange3D.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setStart(double start)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange3D);
            if (l == 0L) {
                String string = InternalResource.loadString("setStart(double start)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            ThemeRange3DNative.jni_SetValueAt(l, n, start);
        }
        this.m_start = start;
    }

    public double getEnd() {
        if (this.isUserThemeRange3D) {
            int n = this.m_themeRange3D.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getEnd()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange3D);
            if (l == 0L) {
                String string = InternalResource.loadString("getEnd()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            this.m_end = ThemeRange3DNative.jni_GetValueAt(l, n + 1);
        }
        return this.m_end;
    }

    public void setEnd(double end) {
        if (this.isUserThemeRange3D) {
            int n = this.m_themeRange3D.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setEnd(double end)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange3D);
            if (l == 0L) {
                String string = InternalResource.loadString("setEnd(double end)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            ThemeRange3DNative.jni_SetValueAt(l, n + 1, end);
        }
        this.m_end = end;
    }

    public boolean isVisible() {
        if (this.isUserThemeRange3D) {
            int n = this.m_themeRange3D.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("isVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange3D);
            if (l == 0L) {
                String string = InternalResource.loadString("isVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            this.m_isVisible = ThemeRange3DNative.jni_GetIsVisibleAt(l, n);
        }
        return this.m_isVisible;
    }

    public void setVisible(boolean value) {
        if (this.isUserThemeRange3D) {
            int n = this.m_themeRange3D.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange3D);
            if (l == 0L) {
                String string = InternalResource.loadString("setVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            ThemeRange3DNative.jni_SetIsVisibleAt(l, n, value);
        }
        this.m_isVisible = value;
    }

    public String getCaption() {
        String string = null;
        if (this.isUserThemeRange3D) {
            int n = this.m_themeRange3D.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string2 = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string2);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange3D);
            if (l == 0L) {
                String string3 = InternalResource.loadString("getCaption()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string3);
            }
            string = ThemeRange3DNative.jni_GetCaptionAt(l, n);
        } else {
            string = this.m_caption == null ? "" : this.m_caption;
        }
        return string;
    }

    public void setCaption(String caption) {
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.isUserThemeRange3D) {
            int n = this.m_themeRange3D.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setCaption(String caption)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange3D);
            if (l == 0L) {
                String string = InternalResource.loadString("setCaption(String caption)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            ThemeRange3DNative.jni_SetCaptionAt(l, n, caption);
        }
        this.m_caption = caption;
    }

    public GeoStyle3D getStyle() {
        if (this.isUserThemeRange3D) {
            long l;
            int n = this.m_themeRange3D.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange3D);
            if (l2 == 0L) {
                String string = InternalResource.loadString("getStyle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            if (this.m_style3D == null && (l = ThemeRange3DNative.jni_GetStyleAt(l2, n)) != 0L) {
                this.m_style3D = InternalGeoStyle3D.createInstance(l);
            }
        }
        return this.m_style3D;
    }

    public void setStyle(GeoStyle3D style) {
        int n = -1;
        long l = 0L;
        if (this.isUserThemeRange3D) {
            n = this.m_themeRange3D.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setStyle(GeoStyle3D style)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange3D);
            if (l == 0L) {
                String string = InternalResource.loadString("setStyle(GeoStyle3D style)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l2 == 0L) {
            String string = InternalResource.loadString("style", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle3D geoStyle3D = style.clone();
        long l3 = 0L;
        if (this.isUserThemeRange3D) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle3D);
            ThemeRange3DNative.jni_SetStyleAt(l, n, l3);
        } else {
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoStyle3D, false);
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle3D);
            if (this.m_style3D == null) {
                this.m_style3D = geoStyle3D;
            } else {
                InternalGeoStyle3D.changeHandle(this.m_style3D, l3);
            }
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)style);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle3D);
    }

    public String toString() {
        if (this.isUserThemeRange3D) {
            int n = this.m_themeRange3D.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange3D);
            if (l == 0L) {
                String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Caption = ");
        stringBuffer.append(this.getCaption());
        stringBuffer.append(",Start = ");
        stringBuffer.append(this.getStart());
        stringBuffer.append(",End = ");
        stringBuffer.append(this.getEnd());
        stringBuffer.append(",Visible = ");
        stringBuffer.append(this.isVisible());
        stringBuffer.append(",Style = ");
        stringBuffer.append(this.getStyle().toString());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    void refreshStyle(long handle) {
        if (this.isUserThemeRange3D && this.m_style3D != null) {
            InternalGeoStyle3D.refreshHandle(this.m_style3D, handle);
        }
    }

    void clearHandle() {
        if (this.m_style3D != null) {
            InternalGeoStyle3D.clearHandle(this.m_style3D);
            this.m_style3D = null;
        }
        this.m_themeRange3D = null;
    }

    public boolean isModellingStyleEnable() {
        int n = -1;
        long l = 0L;
        if (this.isUserThemeRange3D) {
            n = this.m_themeRange3D.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("isModellingStyleEnable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange3D);
            if (l == 0L) {
                String string = InternalResource.loadString("isModellingStyleEnable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            return ThemeRange3DNative.jni_IsModellingStyleEnabled(l, n);
        }
        return this.m_modellingStyleEnable;
    }

    public void setModellingStyleEnable(boolean bValue) {
        int n = -1;
        long l = 0L;
        if (this.isUserThemeRange3D) {
            n = this.m_themeRange3D.getRangeItemsList().indexOf(this);
            if (n == -1) {
                String string = InternalResource.loadString("setModellingStyleEnable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_themeRange3D);
            if (l == 0L) {
                String string = InternalResource.loadString("setModellingStyleEnable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalStateException(string);
            }
            ThemeRange3DNative.jni_SetModellingStyleEnabled(l, n, bValue);
        }
        this.m_modellingStyleEnable = bValue;
    }
}

