/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalResource;
import java.util.ArrayList;

public class ANNParameter {
    private int m_nNeighborhoodNumber;
    private double m_dLearningRate;
    private int m_nSampleCount;
    private boolean m_bCustomNeighborhood;
    private ArrayList[] m_arrCustomNeighborhoods;

    public ANNParameter() {
        this.m_nNeighborhoodNumber = 7;
        this.m_dLearningRate = 0.2;
        this.m_nSampleCount = 1000;
        this.m_bCustomNeighborhood = false;
        this.m_arrCustomNeighborhoods = null;
    }

    public ANNParameter(ANNParameter para) {
        this.m_nNeighborhoodNumber = para.m_nNeighborhoodNumber;
        this.m_dLearningRate = para.m_dLearningRate;
        this.m_nSampleCount = para.m_nSampleCount;
    }

    public boolean isCustomNeighborhood() {
        return this.m_bCustomNeighborhood;
    }

    public void setCustomNeighborhood(boolean value) {
        this.m_bCustomNeighborhood = value;
    }

    public int getNeighborhoodNumber() {
        return this.m_nNeighborhoodNumber;
    }

    public void setNeighborhoodNumber(int value) {
        if (value <= 0) {
            String string = InternalResource.loadString("NeighborhoodNumber", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nNeighborhoodNumber = value;
    }

    public boolean[][] getCustomNeighborhoods() {
        if (this.m_arrCustomNeighborhoods == null) {
            return null;
        }
        int n = this.m_arrCustomNeighborhoods.length;
        boolean[][] blArrayArray = new boolean[n][];
        for (int i = 0; i < n; ++i) {
            boolean[] blArray = new boolean[n];
            for (int j = 0; j < n; ++j) {
                blArray[j] = (Boolean)this.m_arrCustomNeighborhoods[i].get(j);
            }
            blArrayArray[i] = blArray;
        }
        return blArrayArray;
    }

    public void setCustomNeighborhoods(boolean[][] value) {
        int n;
        int n2;
        if (value == null || value.length == 0) {
            String string = InternalResource.loadString("CustomNeighborhoods", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        for (n2 = 0; n2 < value.length; ++n2) {
            if (value[n2] == null) {
                String string = InternalResource.loadString("CustomNeighborhoods[" + n2 + "]", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (value.length == value[n2].length) continue;
            String string = InternalResource.loadString("CustomNeighborhoods[" + n2 + "].length and CustomNeighborhoods.length must be the same length.", "ArgumentInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        n2 = value.length;
        if (this.m_arrCustomNeighborhoods != null) {
            for (n = 0; n < this.m_arrCustomNeighborhoods.length; ++n) {
                this.m_arrCustomNeighborhoods[n].clear();
            }
        } else {
            this.m_arrCustomNeighborhoods = new ArrayList[n2];
            for (n = 0; n < n2; ++n) {
                this.m_arrCustomNeighborhoods[n] = new ArrayList();
            }
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                this.m_arrCustomNeighborhoods[n].add(value[n][i]);
            }
        }
    }

    public double getLearningRate() {
        return this.m_dLearningRate;
    }

    public void setLearningRate(double value) {
        if (value <= 0.0 || value > 1.0) {
            String string = InternalResource.loadString("LearningRate", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_dLearningRate = value;
    }

    public int getSampleCount() {
        return this.m_nSampleCount;
    }

    public void setSampleCount(int value) {
        if (value < 100) {
            String string = InternalResource.loadString("SampleCount", "GlobalGreaterThanHundred", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nSampleCount = value;
    }
}

