/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.data.DatasetGrid;
import com.supermap.data.Datasource;
import com.supermap.data.PixelFormat;
import java.util.ArrayList;

public class CellularAutomataParameter {
    private DatasetGrid m_CellGrid;
    private ArrayList<DatasetGrid> m_arrSpatialVariableGrid;
    private Datasource m_OutputDataSource;
    private String m_strOutputDatasetName;
    private boolean m_bSave;
    private int m_nSaveFrequency;
    private int m_nFlushFrequency;
    private int m_nSimulationCount;
    private String m_strFlushFilePathName;
    private int m_nIterations;

    protected void Reset(CellularAutomataParameter para) {
        this.m_CellGrid = para.m_CellGrid;
        this.m_arrSpatialVariableGrid = para.m_arrSpatialVariableGrid;
        this.m_OutputDataSource = para.m_OutputDataSource;
        this.m_strOutputDatasetName = para.m_strOutputDatasetName;
        this.m_bSave = para.m_bSave;
        this.m_nSaveFrequency = para.m_nSaveFrequency;
        this.m_nFlushFrequency = para.m_nFlushFrequency;
        this.m_nSimulationCount = para.m_nSimulationCount;
        this.m_strFlushFilePathName = para.m_strFlushFilePathName;
        this.m_nIterations = para.m_nIterations;
    }

    public CellularAutomataParameter() {
        this.m_CellGrid = null;
        this.m_arrSpatialVariableGrid = null;
        this.m_OutputDataSource = null;
        this.m_bSave = false;
        this.m_nSaveFrequency = 10;
        this.m_nFlushFrequency = 10;
        this.m_nSimulationCount = 0;
        this.m_nIterations = 10;
    }

    public CellularAutomataParameter(CellularAutomataParameter para) {
        this.Reset(para);
    }

    protected static void CheckParameter(CellularAutomataParameter para) {
        if (para == null) {
            String string = InternalResource.loadString("CellularAutomataParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (null == para.getCellGrid() || InternalHandle.getHandle((com.supermap.data.InternalHandle)para.getCellGrid()) == 0L) {
            String string = InternalResource.loadString("CellularAutomataParameter.getCellGrid()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetGrid datasetGrid = para.getCellGrid();
        if (datasetGrid.getPixelFormat() != PixelFormat.BIT8 && datasetGrid.getPixelFormat() != PixelFormat.BIT16 && datasetGrid.getPixelFormat() != PixelFormat.BIT32 && datasetGrid.getPixelFormat() != PixelFormat.BIT64 && datasetGrid.getPixelFormat() != PixelFormat.UBIT1 && datasetGrid.getPixelFormat() != PixelFormat.UBIT4 && datasetGrid.getPixelFormat() != PixelFormat.UBIT8 && datasetGrid.getPixelFormat() != PixelFormat.UBIT16 && datasetGrid.getPixelFormat() != PixelFormat.UBIT32) {
            String string = InternalResource.loadString("CellularAutomataParameter.getCellGrid()", "ZonalDataset_UnsupportedDatasetType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == para.getSpatialVariableGrids() || para.getSpatialVariableGrids().length == 0) {
            String string = InternalResource.loadString("CellularAutomataParameter.getSpatialVariableGrids()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (para.IsSave()) {
            if (para.getSaveFrequency() <= 0) {
                String string = InternalResource.loadString("CellularAutomataParameter.getSaveFrequency()", "GlobalGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (null == para.getOutputDataSource() || 0L == InternalHandle.getHandle((com.supermap.data.InternalHandle)para.getOutputDataSource())) {
                String string = InternalResource.loadString("CellularAutomataParameter.getOutputDataSource()", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (para.getOutputDatasetName() == null || para.getOutputDatasetName().trim().equalsIgnoreCase("")) {
                String string = InternalResource.loadString("CellularAutomataParameter.getOutputDatasetName()", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!para.getOutputDataSource().getDatasets().isAvailableDatasetName(para.getOutputDatasetName())) {
                String string = InternalResource.loadString("CellularAutomataParameter.getOutputDatasetName()", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if (para.getFlushFilePathName() != null && !para.getFlushFilePathName().trim().equalsIgnoreCase("")) {
            if (para.getFlushFrequency() <= 0) {
                String string = InternalResource.loadString("CellularAutomataParameter.getFlushFrequency()", "GlobalGreaterThanZero", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!para.getFlushFilePathName().endsWith(".tif")) {
                String string = InternalResource.loadString("CellularAutomataParameter.getFlushFilePathName()", "ArgumentInvalid", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if (para.getSimulationCount() <= 0) {
            String string = InternalResource.loadString("CellularAutomataParameter.getSimulationCount()", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (para.getIterations() <= 0) {
            String string = InternalResource.loadString("CellularAutomataParameter.getIterations()", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public DatasetGrid getCellGrid() {
        return this.m_CellGrid;
    }

    public void setCellGrid(DatasetGrid value) {
        if (value == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)value) == 0L) {
            String string = InternalResource.loadString("CellGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_CellGrid = value;
    }

    public DatasetGrid[] getSpatialVariableGrids() {
        if (this.m_arrSpatialVariableGrid == null) {
            return null;
        }
        int n = this.m_arrSpatialVariableGrid.size();
        DatasetGrid[] datasetGridArray = new DatasetGrid[n];
        for (int i = 0; i < n; ++i) {
            datasetGridArray[i] = this.m_arrSpatialVariableGrid.get(i);
        }
        return datasetGridArray;
    }

    public void setSpatialVariableGrids(DatasetGrid[] value) {
        int n;
        if (value == null) {
            String string = InternalResource.loadString("SpatialVariableGrids", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = value.length;
        for (n = 0; n < n2; ++n) {
            if (value[n] != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)value[n]) != 0L) continue;
            String string = InternalResource.loadString("value[" + n + "]", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_arrSpatialVariableGrid != null) {
            this.m_arrSpatialVariableGrid.clear();
        } else {
            this.m_arrSpatialVariableGrid = new ArrayList();
        }
        for (n = 0; n < n2; ++n) {
            this.m_arrSpatialVariableGrid.add(value[n]);
        }
    }

    public Datasource getOutputDataSource() {
        return this.m_OutputDataSource;
    }

    public void setOutputDataSource(Datasource value) {
        if (value == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)value) == 0L) {
            String string = InternalResource.loadString("OutputDataSource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_OutputDataSource = value;
    }

    public String getOutputDatasetName() {
        return this.m_strOutputDatasetName;
    }

    public void setOutputDatasetName(String value) {
        if (value == null || value.trim().equalsIgnoreCase("")) {
            String string = InternalResource.loadString("OutputDatasetName", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_strOutputDatasetName = value;
    }

    public boolean IsSave() {
        return this.m_bSave;
    }

    public void setSave(boolean value) {
        this.m_bSave = value;
    }

    public int getSaveFrequency() {
        return this.m_nSaveFrequency;
    }

    public void setSaveFrequency(int value) {
        if (value <= 0) {
            String string = InternalResource.loadString("SaveFrequency", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nSaveFrequency = value;
    }

    public int getFlushFrequency() {
        return this.m_nFlushFrequency;
    }

    public void setFlushFrequency(int value) {
        if (value <= 0) {
            String string = InternalResource.loadString("FlushFrequency", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nFlushFrequency = value;
    }

    public int getSimulationCount() {
        return this.m_nSimulationCount;
    }

    public void setSimulationCount(int value) {
        if (value <= 0) {
            String string = InternalResource.loadString("SimulationCount", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nSimulationCount = value;
    }

    public String getFlushFilePathName() {
        return this.m_strFlushFilePathName;
    }

    public void setFlushFilePathName(String value) {
        if (value == null || value.trim().equalsIgnoreCase("")) {
            String string = InternalResource.loadString("FlushFilePathName", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_strFlushFilePathName = value;
    }

    public int getIterations() {
        return this.m_nIterations;
    }

    public void setIterations(int value) {
        if (value <= 0) {
            String string = InternalResource.loadString("Iterations", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nIterations = value;
    }
}

