/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.ComputeType;
import com.supermap.analyst.spatialanalyst.CostPathLineResult;
import com.supermap.analyst.spatialanalyst.DistanceAnalystNative;
import com.supermap.analyst.spatialanalyst.DistanceAnalystParameter;
import com.supermap.analyst.spatialanalyst.DistanceAnalystResult;
import com.supermap.analyst.spatialanalyst.GridAnalystSetting;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalGeometry;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.PathLineResult;
import com.supermap.analyst.spatialanalyst.SmoothMethod;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.GeoLine;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class DistanceAnalyst {
    private static License m_license;
    private static transient Vector m_steppedListeners;
    private static GridAnalystSetting m_gridAnalystSetting;

    private DistanceAnalyst() {
        m_gridAnalystSetting = null;
    }

    public static GridAnalystSetting getAnalystSetting() {
        return m_gridAnalystSetting;
    }

    public static void setAnalystSetting(GridAnalystSetting gridAnalystSetting) {
        if (gridAnalystSetting == null) {
            m_gridAnalystSetting = null;
            return;
        }
        if (m_gridAnalystSetting == null) {
            m_gridAnalystSetting = new GridAnalystSetting();
        }
        m_gridAnalystSetting.setBounds(gridAnalystSetting.getBounds());
        m_gridAnalystSetting.setBoundsType(gridAnalystSetting.getBoundsType());
        m_gridAnalystSetting.setCellSizeType(gridAnalystSetting.getCellSizeType());
        m_gridAnalystSetting.setCellSize(gridAnalystSetting.getCellSize());
        m_gridAnalystSetting.setOutputDatasource(gridAnalystSetting.getOutputDatasource());
        m_gridAnalystSetting.setGridOutputNamePrefix(gridAnalystSetting.getGridOutputNamePrefix());
        m_gridAnalystSetting.setVectorOutputNamePrefix(gridAnalystSetting.getVectorOutputNamePrefix());
        m_gridAnalystSetting.setValidRegion(gridAnalystSetting.getValidRegion());
        m_gridAnalystSetting.setShowProgress(gridAnalystSetting.isShowProgress());
    }

    @Deprecated
    public static DistanceAnalystResult straightDistance(Dataset sourceDataset, Datasource targetDatasource, String distanceGridName, String directionGridName, String allocationGridName, double cellSize, double maxDistance) {
        DistanceAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (distanceGridName == null || distanceGridName.length() == 0) {
            String string = InternalResource.loadString("distanceGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (directionGridName != null && directionGridName.length() > 0 && !targetDatasource.getDatasets().isAvailableDatasetName(directionGridName)) {
            String string = InternalResource.loadString("directionGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (allocationGridName != null && allocationGridName.length() > 0 && !targetDatasource.getDatasets().isAvailableDatasetName(allocationGridName)) {
            String string = InternalResource.loadString("allocationGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(distanceGridName)) {
            String string = InternalResource.loadString("distanceGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = DistanceAnalystNative.jni_New();
        if (l3 == 0L) {
            return null;
        }
        long[] lArray = DistanceAnalystNative.jni_StraightDistance(l3, l, l2, distanceGridName, directionGridName, allocationGridName, cellSize, maxDistance);
        DistanceAnalystNative.jni_Delete(l3);
        DistanceAnalystResult distanceAnalystResult = null;
        DatasetGrid datasetGrid = null;
        DatasetGrid datasetGrid2 = null;
        DatasetGrid datasetGrid3 = null;
        if (lArray != null && lArray.length == 3) {
            datasetGrid = InternalDatasetGrid.createInstance(lArray[0], targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            if (directionGridName != null && directionGridName.length() > 0) {
                datasetGrid2 = InternalDatasetGrid.createInstance(lArray[1], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid2);
            }
            if (allocationGridName != null && allocationGridName.length() > 0) {
                datasetGrid3 = InternalDatasetGrid.createInstance(lArray[2], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid3);
            }
            distanceAnalystResult = new DistanceAnalystResult(datasetGrid, datasetGrid2, datasetGrid3);
        }
        return distanceAnalystResult;
    }

    public static DistanceAnalystResult straightDistance(DistanceAnalystParameter parameter) {
        Object object;
        DistanceAnalyst.verifyLicense();
        if (parameter.getSourceDataset() == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getSourceDataset()) == 0L) {
            String string = InternalResource.loadString("getSourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        Datasource datasource = parameter.getTargetDatasource();
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : parameter.getSourceDataset().getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = parameter.getDistanceGridName();
        String string2 = parameter.getDirectionGridName();
        String string3 = parameter.getAllocationGridName();
        if (null == string) {
            String string4 = InternalResource.loadString("distanceGridName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            string = m_gridAnalystSetting.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("distanceGridName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (string2 != null && string2.length() > 0) {
            if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
                string2 = m_gridAnalystSetting.getGridOutputNamePrefix() + string2;
            }
            if (!datasource.getDatasets().isAvailableDatasetName(string2)) {
                String string6 = InternalResource.loadString("directionGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string6);
            }
        }
        if (string3 != null && string3.length() > 0) {
            if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
                string3 = m_gridAnalystSetting.getGridOutputNamePrefix() + string3;
            }
            if (!datasource.getDatasets().isAvailableDatasetName(string3)) {
                String string7 = InternalResource.loadString("allocationGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string7);
            }
        }
        if (string.equals(string2) || string.equals(string3) || string2 != null && !string2.isEmpty() && string2.equals(string3)) {
            String string8 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string8);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getSourceDataset());
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        double d = parameter.getCellSize();
        double d2 = parameter.getMaxDistance();
        long l3 = DistanceAnalystNative.jni_New();
        if (l3 == 0L) {
            return null;
        }
        if (null != m_gridAnalystSetting) {
            DistanceAnalystNative.jni_SetShowProgress(l3, m_gridAnalystSetting.isShowProgress());
            object = m_gridAnalystSetting.getBounds();
            DistanceAnalystNative.jni_SetTargetBounds(l3, m_gridAnalystSetting.getBoundsType().value(), object.getLeft(), object.getBottom(), object.getRight(), object.getTop());
            if (d <= 0.0) {
                DistanceAnalystNative.jni_SetTargetCellSize(l3, m_gridAnalystSetting.getCellSizeType().value(), m_gridAnalystSetting.getCellSize());
            }
        }
        object = DistanceAnalystNative.jni_StraightDistance(l3, l, l2, string, string2, string3, d, d2);
        DistanceAnalystNative.jni_Delete(l3);
        DistanceAnalystResult distanceAnalystResult = null;
        DatasetGrid datasetGrid = null;
        DatasetGrid datasetGrid2 = null;
        DatasetGrid datasetGrid3 = null;
        if (object != null && ((Rectangle2D)object).length == 3 && object[0] != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance((long)object[0], datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
            if (object[1] != 0L) {
                datasetGrid2 = InternalDatasetGrid.createInstance((long)object[1], datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
            }
            if (object[2] != 0L) {
                datasetGrid3 = InternalDatasetGrid.createInstance((long)object[2], datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid3);
            }
            distanceAnalystResult = new DistanceAnalystResult(datasetGrid, datasetGrid2, datasetGrid3);
        }
        return distanceAnalystResult;
    }

    @Deprecated
    public static DistanceAnalystResult costDistance(Dataset sourceDataset, DatasetGrid costGrid, Datasource targetDatasource, String distanceGridName, String directionGridName, String allocationGridName, double cellSize, double maxDistance) {
        DistanceAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (distanceGridName == null || distanceGridName.length() == 0) {
            String string = InternalResource.loadString("distanceGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (directionGridName != null && directionGridName.length() > 0 && !targetDatasource.getDatasets().isAvailableDatasetName(directionGridName)) {
            String string = InternalResource.loadString("directionGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (allocationGridName != null && allocationGridName.length() > 0 && !targetDatasource.getDatasets().isAvailableDatasetName(allocationGridName)) {
            String string = InternalResource.loadString("allocationGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(distanceGridName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = 0L;
        if (costGrid != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)costGrid);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l4 = DistanceAnalystNative.jni_New();
        if (l4 == 0L) {
            return null;
        }
        long[] lArray = DistanceAnalystNative.jni_CostDistance(l4, l, l2, l3, distanceGridName, directionGridName, allocationGridName, cellSize, maxDistance);
        DistanceAnalystNative.jni_Delete(l4);
        DistanceAnalystResult distanceAnalystResult = null;
        DatasetGrid datasetGrid = null;
        DatasetGrid datasetGrid2 = null;
        DatasetGrid datasetGrid3 = null;
        if (lArray != null && lArray.length == 3) {
            datasetGrid = InternalDatasetGrid.createInstance(lArray[0], targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
            if (directionGridName != null && directionGridName.length() > 0) {
                datasetGrid2 = InternalDatasetGrid.createInstance(lArray[1], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid2);
            }
            if (allocationGridName != null && allocationGridName.length() > 0) {
                datasetGrid3 = InternalDatasetGrid.createInstance(lArray[2], targetDatasource);
                InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid3);
            }
            distanceAnalystResult = new DistanceAnalystResult(datasetGrid, datasetGrid2, datasetGrid3);
        }
        return distanceAnalystResult;
    }

    public static DistanceAnalystResult costDistance(DistanceAnalystParameter parameter) {
        Object object;
        DistanceAnalyst.verifyLicense();
        if (parameter.getSourceDataset() == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getSourceDataset()) == 0L) {
            String string = InternalResource.loadString("getSourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        Datasource datasource = parameter.getTargetDatasource();
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : parameter.getSourceDataset().getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = parameter.getDistanceGridName();
        String string2 = parameter.getDirectionGridName();
        String string3 = parameter.getAllocationGridName();
        if (null == string) {
            String string4 = InternalResource.loadString("distanceGridName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            string = m_gridAnalystSetting.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("distanceGridName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (string2 != null && string2.length() > 0) {
            if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
                string2 = m_gridAnalystSetting.getGridOutputNamePrefix() + string2;
            }
            if (!datasource.getDatasets().isAvailableDatasetName(string2)) {
                String string6 = InternalResource.loadString("directionGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string6);
            }
        }
        if (string3 != null && string3.length() > 0) {
            if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
                string3 = m_gridAnalystSetting.getGridOutputNamePrefix() + string3;
            }
            if (!datasource.getDatasets().isAvailableDatasetName(string3)) {
                String string7 = InternalResource.loadString("allocationGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string7);
            }
        }
        if (string.equals(string2) || string.equals(string3) || string2 != null && !string2.isEmpty() && string2.equals(string3)) {
            String string8 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string8);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getSourceDataset());
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = 0L;
        if (parameter.getCostGrid() != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getCostGrid());
        }
        double d = parameter.getCellSize();
        double d2 = parameter.getMaxDistance();
        long l4 = DistanceAnalystNative.jni_New();
        if (l4 == 0L) {
            return null;
        }
        if (null != m_gridAnalystSetting) {
            DistanceAnalystNative.jni_SetShowProgress(l4, m_gridAnalystSetting.isShowProgress());
            object = m_gridAnalystSetting.getBounds();
            DistanceAnalystNative.jni_SetTargetBounds(l4, m_gridAnalystSetting.getBoundsType().value(), object.getLeft(), object.getBottom(), object.getRight(), object.getTop());
            if (d <= 0.0) {
                DistanceAnalystNative.jni_SetTargetCellSize(l4, m_gridAnalystSetting.getCellSizeType().value(), m_gridAnalystSetting.getCellSize());
            }
        }
        object = DistanceAnalystNative.jni_CostDistance(l4, l, l3, l2, string, string2, string3, d, d2);
        DistanceAnalystNative.jni_Delete(l4);
        DistanceAnalystResult distanceAnalystResult = null;
        DatasetGrid datasetGrid = null;
        DatasetGrid datasetGrid2 = null;
        DatasetGrid datasetGrid3 = null;
        if (object != null && ((Rectangle2D)object).length == 3 && object[0] != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance((long)object[0], datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
            if (object[1] != 0L) {
                datasetGrid2 = InternalDatasetGrid.createInstance((long)object[1], datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
            }
            if (object[2] != 0L) {
                datasetGrid3 = InternalDatasetGrid.createInstance((long)object[2], datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid3);
            }
            distanceAnalystResult = new DistanceAnalystResult(datasetGrid, datasetGrid2, datasetGrid3);
        }
        return distanceAnalystResult;
    }

    public static DistanceAnalystResult surfaceDistance(DistanceAnalystParameter parameter) {
        Object object;
        DistanceAnalyst.verifyLicense();
        if (parameter.getSourceDataset() == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getSourceDataset()) == 0L) {
            String string = InternalResource.loadString("getSourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        Datasource datasource = parameter.getTargetDatasource();
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : parameter.getSourceDataset().getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        String string = parameter.getDistanceGridName();
        String string2 = parameter.getDirectionGridName();
        String string3 = parameter.getAllocationGridName();
        if (null == string) {
            String string4 = InternalResource.loadString("distanceGridName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            string = m_gridAnalystSetting.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("distanceGridName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        if (string2 != null && string2.length() > 0) {
            if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
                string2 = m_gridAnalystSetting.getGridOutputNamePrefix() + string2;
            }
            if (!datasource.getDatasets().isAvailableDatasetName(string2)) {
                String string6 = InternalResource.loadString("directionGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string6);
            }
        }
        if (string3 != null && string3.length() > 0) {
            if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
                string3 = m_gridAnalystSetting.getGridOutputNamePrefix() + string3;
            }
            if (!datasource.getDatasets().isAvailableDatasetName(string3)) {
                String string7 = InternalResource.loadString("allocationGridName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string7);
            }
        }
        if (string.equals(string2) || string.equals(string3) || string2 != null && !string2.isEmpty() && string2.equals(string3)) {
            String string8 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string8);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getSourceDataset());
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = 0L;
        if (parameter.getSurfaceGrid() != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getSurfaceGrid());
        }
        double d = parameter.getCellSize();
        double d2 = parameter.getMaxDistance();
        double d3 = parameter.getMaxUpslopeDegree();
        double d4 = parameter.getMaxDownslopeDegree();
        long l4 = DistanceAnalystNative.jni_New();
        if (l4 == 0L) {
            return null;
        }
        if (null != m_gridAnalystSetting) {
            DistanceAnalystNative.jni_SetShowProgress(l4, m_gridAnalystSetting.isShowProgress());
            object = m_gridAnalystSetting.getBounds();
            DistanceAnalystNative.jni_SetTargetBounds(l4, m_gridAnalystSetting.getBoundsType().value(), object.getLeft(), object.getBottom(), object.getRight(), object.getTop());
            if (d <= 0.0) {
                DistanceAnalystNative.jni_SetTargetCellSize(l4, m_gridAnalystSetting.getCellSizeType().value(), m_gridAnalystSetting.getCellSize());
            }
        }
        object = DistanceAnalystNative.jni_SurfaceDistance(l4, l, l3, l2, string, string2, string3, d, d2, d3, d4);
        DistanceAnalystNative.jni_Delete(l4);
        DistanceAnalystResult distanceAnalystResult = null;
        DatasetGrid datasetGrid = null;
        DatasetGrid datasetGrid2 = null;
        DatasetGrid datasetGrid3 = null;
        if (object != null && ((Rectangle2D)object).length == 3 && object[0] != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance((long)object[0], datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
            if (object[1] != 0L) {
                datasetGrid2 = InternalDatasetGrid.createInstance((long)object[1], datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
            }
            if (object[2] != 0L) {
                datasetGrid3 = InternalDatasetGrid.createInstance((long)object[2], datasource);
                InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid3);
            }
            distanceAnalystResult = new DistanceAnalystResult(datasetGrid, datasetGrid2, datasetGrid3);
        }
        return distanceAnalystResult;
    }

    public static DatasetGrid costPath(Dataset sourceDataset, DatasetGrid distanceDataset, DatasetGrid directionDataset, ComputeType computeType, Datasource targetDatasource, String targetDatasetName) {
        DistanceAnalyst.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (distanceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)distanceDataset) == 0L) {
            String string = InternalResource.loadString("distanceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (directionDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)directionDataset) == 0L) {
            String string = InternalResource.loadString("directionDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : sourceDataset.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getGridOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getGridOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)distanceDataset);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)directionDataset);
        long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        int n = InternalEnum.getUGCValue(computeType);
        long l5 = DistanceAnalystNative.jni_New();
        if (l5 == 0L) {
            return null;
        }
        if (null != m_gridAnalystSetting) {
            DistanceAnalystNative.jni_SetShowProgress(l5, m_gridAnalystSetting.isShowProgress());
        }
        long l6 = DistanceAnalystNative.jni_CostPath(l5, l, l2, l3, n, l4, targetDatasetName);
        DistanceAnalystNative.jni_Delete(l5);
        DatasetGrid datasetGrid = null;
        if (l6 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l6, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    @Deprecated
    public static CostPathLineResult costPathLine(Point2D sourcePoint, Point2D targetPoint, DatasetGrid costGrid, SmoothMethod smoothMethod, int smoothDegree, Datasource targetDatasource, String targetDatasetName) {
        DistanceAnalyst.verifyLicense();
        if (sourcePoint == null || targetPoint == null) {
            String string = InternalResource.loadString("sourcePoint or targetPoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (costGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)costGrid) == 0L) {
            String string = InternalResource.loadString("costGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            targetDatasource = m_gridAnalystSetting != null && m_gridAnalystSetting.getOutputDatasource() != null ? m_gridAnalystSetting.getOutputDatasource() : costGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (null != m_gridAnalystSetting && null != m_gridAnalystSetting.getVectorOutputNamePrefix()) {
            targetDatasetName = m_gridAnalystSetting.getVectorOutputNamePrefix() + targetDatasetName;
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)costGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        int n = InternalEnum.getUGCValue(smoothMethod);
        double[] dArray = new double[1];
        long l3 = DistanceAnalystNative.jni_New();
        if (l3 == 0L) {
            return null;
        }
        if (null != m_gridAnalystSetting) {
            DistanceAnalystNative.jni_SetShowProgress(l3, m_gridAnalystSetting.isShowProgress());
        }
        long l4 = DistanceAnalystNative.jni_CostPathLineDeprecated(l3, sourcePoint.getX(), sourcePoint.getY(), targetPoint.getX(), targetPoint.getY(), l, n, smoothDegree, l2, targetDatasetName, dArray);
        DistanceAnalystNative.jni_Delete(l3);
        DatasetVector datasetVector = null;
        CostPathLineResult costPathLineResult = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
            costPathLineResult = new CostPathLineResult(datasetVector, dArray[0]);
        }
        return costPathLineResult;
    }

    public static PathLineResult costPathLine(Point2D sourcePoint, Point2D targetPoint, DistanceAnalystParameter parameter) {
        DistanceAnalyst.verifyLicense();
        if (sourcePoint == null || targetPoint == null) {
            String string = InternalResource.loadString("sourcePoint or targetPoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        DatasetGrid datasetGrid = parameter.getCostGrid();
        if (datasetGrid == null) {
            String string = InternalResource.loadString("CostGrid and SurfaceGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string = InternalResource.loadString("CostGrid", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = 0L;
        if (parameter.getBarrierRegion() != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getBarrierRegion());
        }
        int n = InternalEnum.getUGCValue(parameter.getPathLineSmoothMethod());
        double[] dArray = new double[1];
        long l3 = DistanceAnalystNative.jni_New();
        if (l3 == 0L) {
            return null;
        }
        if (null != m_gridAnalystSetting) {
            DistanceAnalystNative.jni_SetShowProgress(l3, m_gridAnalystSetting.isShowProgress());
        }
        long l4 = DistanceAnalystNative.jni_CostPathLine(l3, sourcePoint.getX(), sourcePoint.getY(), targetPoint.getX(), targetPoint.getY(), l, n, parameter.getPathLineSmoothDegree(), dArray, l2);
        DistanceAnalystNative.jni_Delete(l3);
        GeoLine geoLine = null;
        PathLineResult pathLineResult = null;
        if (l4 != 0L) {
            geoLine = (GeoLine)InternalGeometry.createInstance(l4);
            pathLineResult = new PathLineResult(geoLine, dArray[0]);
        }
        return pathLineResult;
    }

    public static PathLineResult surfacePathLine(Point2D sourcePoint, Point2D targetPoint, DistanceAnalystParameter parameter) {
        DistanceAnalyst.verifyLicense();
        if (sourcePoint == null || targetPoint == null) {
            String string = InternalResource.loadString("sourcePoint or targetPoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        DatasetGrid datasetGrid = parameter.getSurfaceGrid();
        if (datasetGrid == null) {
            String string = InternalResource.loadString("SurfaceGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string = InternalResource.loadString("CostGrid", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = 0L;
        if (parameter.getBarrierRegion() != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getBarrierRegion());
        }
        int n = InternalEnum.getUGCValue(parameter.getPathLineSmoothMethod());
        double[] dArray = new double[1];
        long l3 = DistanceAnalystNative.jni_New();
        if (l3 == 0L) {
            return null;
        }
        if (null != m_gridAnalystSetting) {
            DistanceAnalystNative.jni_SetShowProgress(l3, m_gridAnalystSetting.isShowProgress());
        }
        long l4 = DistanceAnalystNative.jni_SurfacePathLine(l3, sourcePoint.getX(), sourcePoint.getY(), targetPoint.getX(), targetPoint.getY(), l, parameter.getMaxUpslopeDegree(), parameter.getMaxDownslopeDegree(), n, parameter.getPathLineSmoothDegree(), dArray, l2);
        DistanceAnalystNative.jni_Delete(l3);
        GeoLine geoLine = null;
        PathLineResult pathLineResult = null;
        if (l4 != 0L) {
            geoLine = (GeoLine)InternalGeometry.createInstance(l4);
            pathLineResult = new PathLineResult(geoLine, dArray[0]);
        }
        return pathLineResult;
    }

    public static PathLineResult pathLine(Point2D targetPoint, DatasetGrid distanceGrid, DatasetGrid directionGrid, SmoothMethod smoothMethod, int smoothDegree) {
        DistanceAnalyst.verifyLicense();
        if (targetPoint == null) {
            String string = InternalResource.loadString("targetPoint", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (distanceGrid == null) {
            String string = InternalResource.loadString("distanceGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)distanceGrid) == 0L) {
            String string = InternalResource.loadString("distanceGrid", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (directionGrid == null) {
            String string = InternalResource.loadString("directionGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)directionGrid) == 0L) {
            String string = InternalResource.loadString("directionGrid", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)distanceGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)directionGrid);
        int n = InternalEnum.getUGCValue(smoothMethod);
        double[] dArray = new double[1];
        long l3 = DistanceAnalystNative.jni_New();
        if (l3 == 0L) {
            return null;
        }
        long l4 = DistanceAnalystNative.jni_PathLine(l3, targetPoint.getX(), targetPoint.getY(), l, l2, n, smoothDegree, dArray);
        DistanceAnalystNative.jni_Delete(l3);
        GeoLine geoLine = null;
        PathLineResult pathLineResult = null;
        if (l4 != 0L) {
            geoLine = (GeoLine)InternalGeometry.createInstance(l4);
            pathLineResult = new PathLineResult(geoLine, dArray[0]);
        }
        return pathLineResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "DistanceAnalyst";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        DistanceAnalyst.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

