/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.SmoothMethod;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;

public class DistanceAnalystParameter {
    private double m_MaxDistance;
    private double m_CellSize;
    private Dataset m_SourceDataset;
    private DatasetGrid m_CostGrid;
    private DatasetGrid m_SurfaceGrid;
    private Datasource m_DistanceDatasource;
    private Datasource m_DirectionDatasource;
    private Datasource m_AllocationDatasource;
    private Datasource m_TargetDatasource;
    private String m_DistanceGridName;
    private String m_DirectionGridName;
    private String m_AllocationGridName;
    private DatasetVector m_BarrierRegion;
    private double m_MaxUpslopeDegree;
    private double m_MaxDownslopeDegree;
    private SmoothMethod m_PathLineSmoothMethod;
    private int m_PathLineSmoothDegree;

    public DistanceAnalystParameter() {
        this.m_MaxDistance = -1.0;
        this.m_CellSize = 0.0;
        this.m_SourceDataset = null;
        this.m_CostGrid = null;
        this.m_SurfaceGrid = null;
        this.m_DirectionDatasource = null;
        this.m_DistanceDatasource = null;
        this.m_AllocationDatasource = null;
        this.m_DistanceGridName = null;
        this.m_DirectionGridName = null;
        this.m_AllocationGridName = null;
        this.m_TargetDatasource = null;
        this.m_MaxUpslopeDegree = 90.0;
        this.m_MaxDownslopeDegree = 90.0;
        this.m_PathLineSmoothMethod = SmoothMethod.NONE;
        this.m_PathLineSmoothDegree = 0;
        this.m_BarrierRegion = null;
    }

    public DistanceAnalystParameter(DistanceAnalystParameter parameter) {
        this.m_MaxDistance = parameter.getMaxDistance();
        this.m_CellSize = parameter.getCellSize();
        this.m_SourceDataset = parameter.getSourceDataset();
        this.m_CostGrid = parameter.getCostGrid();
        this.m_DistanceGridName = parameter.getDistanceGridName();
        this.m_DirectionGridName = parameter.getDirectionGridName();
        this.m_AllocationGridName = parameter.getAllocationGridName();
        this.m_TargetDatasource = parameter.getTargetDatasource();
        this.m_BarrierRegion = parameter.getBarrierRegion();
        this.m_MaxUpslopeDegree = parameter.getMaxUpslopeDegree();
        this.m_MaxDownslopeDegree = parameter.getMaxDownslopeDegree();
        this.m_PathLineSmoothMethod = parameter.getPathLineSmoothMethod();
        this.m_PathLineSmoothDegree = parameter.getPathLineSmoothDegree();
    }

    public double getMaxDistance() {
        return this.m_MaxDistance;
    }

    public void setMaxDistance(double maxDistance) {
        this.m_MaxDistance = maxDistance;
    }

    public double getCellSize() {
        return this.m_CellSize;
    }

    public void setCellSize(double cellSize) {
        this.m_CellSize = cellSize;
    }

    public Dataset getSourceDataset() {
        return this.m_SourceDataset;
    }

    public void setSourceDataset(Dataset sourceDataset) {
        this.m_SourceDataset = sourceDataset;
    }

    public DatasetGrid getCostGrid() {
        return this.m_CostGrid;
    }

    public void setCostGrid(DatasetGrid costGrid) {
        if (costGrid.getMinValue() < 0.0) {
            String string = InternalResource.loadString("costGrid", "GridValueShouldntBeNegative", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        this.m_CostGrid = costGrid;
    }

    public DatasetGrid getSurfaceGrid() {
        return this.m_SurfaceGrid;
    }

    public void setSurfaceGrid(DatasetGrid surfaceGrid) {
        this.m_SurfaceGrid = surfaceGrid;
    }

    @Deprecated
    public Datasource getDistanceDatasource() {
        return this.m_DistanceDatasource;
    }

    @Deprecated
    public void setDistanceDatasource(Datasource distanceDatasource) {
        this.m_DistanceDatasource = distanceDatasource;
    }

    @Deprecated
    public Datasource getDirectionDatasource() {
        return this.m_DirectionDatasource;
    }

    @Deprecated
    public void setDirectionDatasource(Datasource directionDatasource) {
        this.m_DirectionDatasource = directionDatasource;
    }

    @Deprecated
    public Datasource getAllocationDatasource() {
        return this.m_AllocationDatasource;
    }

    @Deprecated
    public void setAllocationDatasource(Datasource allocationDatasource) {
        this.m_AllocationDatasource = allocationDatasource;
    }

    @Deprecated
    public Datasource getOutputDatasource() {
        return this.m_TargetDatasource;
    }

    @Deprecated
    public void setOutputDatasource(Datasource outputDatasource) {
        this.m_TargetDatasource = outputDatasource;
    }

    public Datasource getTargetDatasource() {
        return this.m_TargetDatasource;
    }

    public void setTargetDatasource(Datasource targetDatasource) {
        this.m_TargetDatasource = targetDatasource;
    }

    public String getDistanceGridName() {
        return this.m_DistanceGridName;
    }

    public void setDistanceGridName(String distanceGridName) {
        this.m_DistanceGridName = distanceGridName;
    }

    public String getDirectionGridName() {
        return this.m_DirectionGridName;
    }

    public void setDirectionGridName(String directionGridName) {
        this.m_DirectionGridName = directionGridName;
    }

    public String getAllocationGridName() {
        return this.m_AllocationGridName;
    }

    public void setAllocationGridName(String allocationGridName) {
        this.m_AllocationGridName = allocationGridName;
    }

    public double getMaxUpslopeDegree() {
        return this.m_MaxUpslopeDegree;
    }

    public void setMaxUpslopeDegree(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("MaxUpslopeDegree", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_MaxUpslopeDegree = value;
    }

    public double getMaxDownslopeDegree() {
        return this.m_MaxDownslopeDegree;
    }

    public void setMaxDownslopeDegree(double value) {
        if (value < 0.0) {
            String string = InternalResource.loadString("MaxDownslopeDegree", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_MaxDownslopeDegree = value;
    }

    public SmoothMethod getPathLineSmoothMethod() {
        return this.m_PathLineSmoothMethod;
    }

    public void setPathLineSmoothMethod(SmoothMethod value) {
        this.m_PathLineSmoothMethod = value;
    }

    public int getPathLineSmoothDegree() {
        return this.m_PathLineSmoothDegree;
    }

    public void setPathLineSmoothDegree(int value) {
        this.m_PathLineSmoothDegree = value;
    }

    public DatasetVector getBarrierRegion() {
        return this.m_BarrierRegion;
    }

    public void setBarrierRegion(DatasetVector value) {
        this.m_BarrierRegion = value;
    }
}

