/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.DissolveParameter;
import com.supermap.analyst.spatialanalyst.EdgeMatchParameter;
import com.supermap.analyst.spatialanalyst.EliminateMode;
import com.supermap.analyst.spatialanalyst.GeneralizationNative;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalGeometry;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.Datasource;
import com.supermap.data.FieldInfos;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point2D;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.Unit;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class Generalization {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    private Generalization() {
    }

    public static DatasetVector dissolve(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, DissolveParameter dissolveParameter) {
        Generalization.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (dissolveParameter == null) {
            String string = InternalResource.loadString("dissolveParameter", "OverlayAnalyst_DatsetOrRecordsetTypeInvalidShouldBeRegion", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dissolveParameter);
        long l4 = GeneralizationNative.jni_Dissolve(l, l2, targetDatasetName, l3);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)dissolveParameter));
        return datasetVector;
    }

    public static boolean eliminate(DatasetVector sourceDatasetVector, double regionTolerance, double vertexTolerance, EliminateMode eliminateMode, boolean isDeleteSingleRegion) {
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("sourceDatasetVector", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (regionTolerance < 0.0) {
            String string = InternalResource.loadString("regionTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (vertexTolerance < 0.0) {
            String string = InternalResource.loadString("vertexTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (eliminateMode == null) {
            String string = InternalResource.loadString("eliminateMode", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        boolean bl = false;
        bl = GeneralizationNative.jni_Eliminate(l, regionTolerance, vertexTolerance, eliminateMode.value(), isDeleteSingleRegion);
        return bl;
    }

    public static boolean eliminate(DatasetVector sourceDatasetVector, String[] groupFields, String[] priorityFields, double regionTolerance, double vertexTolerance, EliminateMode eliminateMode, boolean isDeleteSingleRegion) {
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("sourceDatasetVector", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (regionTolerance < 0.0) {
            String string = InternalResource.loadString("regionTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (vertexTolerance < 0.0) {
            String string = InternalResource.loadString("vertexTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (eliminateMode == null) {
            String string = InternalResource.loadString("eliminateMode", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (groupFields == null || groupFields.length == 0) {
            return Generalization.eliminate(sourceDatasetVector, regionTolerance, vertexTolerance, eliminateMode, isDeleteSingleRegion);
        }
        FieldInfos fieldInfos = sourceDatasetVector.getFieldInfos();
        for (String string : groupFields) {
            if (fieldInfos.indexOf(string) != -1) continue;
            String string2 = InternalResource.loadString(String.format("group field `%s` ", string), "FieldInfo_NameIsNotExist", "spatialanalyst_resources");
            throw new IllegalArgumentException(string2);
        }
        if (priorityFields != null) {
            for (String string : priorityFields) {
                if (fieldInfos.indexOf(string) != -1) continue;
                String string3 = InternalResource.loadString(String.format("priority field `%s` ", string), "FieldInfo_NameIsNotExist", "spatialanalyst_resources");
                throw new IllegalArgumentException(string3);
            }
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        int n = 0;
        n = GeneralizationNative.jni_Eliminate2(l, regionTolerance, vertexTolerance, eliminateMode.value(), isDeleteSingleRegion, groupFields, priorityFields) ? 1 : 0;
        return n != 0;
    }

    public static boolean eliminateSpecifiedRegions(DatasetVector sourceDatasetVector, int[] smallRegionIDs, int[] excludeRegionIDs, String[] groupFields, String[] priorityFields, boolean isMaxBorder, double vertexTolerance) {
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("sourceDatasetVector", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (vertexTolerance < 0.0) {
            String string = InternalResource.loadString("vertexTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (smallRegionIDs == null) {
            String string = InternalResource.loadString("smallRegionIDs", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (smallRegionIDs.length == 0) {
            String string = InternalResource.loadString("smallRegionIDs", "Global_ArrayLengthShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        FieldInfos fieldInfos = sourceDatasetVector.getFieldInfos();
        if (groupFields != null) {
            for (String string : groupFields) {
                if (fieldInfos.indexOf(string) != -1) continue;
                String string2 = InternalResource.loadString(String.format("group field `%s` ", string), "FieldInfo_NameIsNotExist", "spatialanalyst_resources");
                throw new IllegalArgumentException(string2);
            }
        }
        if (priorityFields != null) {
            for (String string : priorityFields) {
                if (fieldInfos.indexOf(string) != -1) continue;
                String string3 = InternalResource.loadString(String.format("priority field `%s` ", string), "FieldInfo_NameIsNotExist", "spatialanalyst_resources");
                throw new IllegalArgumentException(string3);
            }
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        int n = 0;
        n = GeneralizationNative.jni_Eliminate3(l, smallRegionIDs, excludeRegionIDs, vertexTolerance, groupFields, priorityFields, isMaxBorder) ? 1 : 0;
        return n != 0;
    }

    public static DatasetVector dualLineToCenterLine(Recordset sourceRecordset, double maxWidth, double minWidth, Datasource outputDatasource, String outputDatasetName) {
        Generalization.verifyLicense();
        if (sourceRecordset == null) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceRecordset);
        if (l == 0L) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource == null) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (l2 == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (maxWidth <= 0.0 || minWidth < 0.0) {
            String string = InternalResource.loadString("width", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = GeneralizationNative.jni_dualLineToCenterLine(l, maxWidth, minWidth, l2, outputDatasetName);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)sourceRecordset);
        return datasetVector;
    }

    public static GeoLine[] dualLineToCenterLine(Recordset sourceRecordset, double maxWidth, double minWidth) {
        if (sourceRecordset == null) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceRecordset);
        if (l == 0L) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (maxWidth <= 0.0 || minWidth < 0.0) {
            String string = InternalResource.loadString("width", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = GeneralizationNative.jni_dualLineToCenterLine(l, maxWidth, minWidth);
        if (lArray == null || lArray.length == 0) {
            return null;
        }
        GeoLine[] geoLineArray = new GeoLine[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            geoLineArray[i] = (GeoLine)InternalGeometry.createInstance(lArray[i]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)sourceRecordset);
        return geoLineArray;
    }

    public static DatasetVector regionToCenterLine(Recordset regionRecordset, Datasource outputDatasource, String outputDatasetName) {
        Generalization.verifyLicense();
        if (regionRecordset == null) {
            String string = InternalResource.loadString("regionRecordset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)regionRecordset);
        if (l == 0L) {
            String string = InternalResource.loadString("regionRecordset", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource == null) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (l2 == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (regionRecordset.getDataset().getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("regionRecordset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = GeneralizationNative.jni_regionToCenterLine(l, l2, outputDatasetName);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)regionRecordset);
        return datasetVector;
    }

    public static GeoLine regionToCenterLine(GeoRegion sourceRegion, Point2D pointFrom, Point2D pointTo) {
        Generalization.verifyLicense();
        if (sourceRegion == null) {
            String string = InternalResource.loadString("region", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceRegion);
        if (l == 0L) {
            String string = InternalResource.loadString("region", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeneralizationNative.jni_regionToCenterLine(l, pointFrom.getX(), pointFrom.getY(), pointTo.getX(), pointTo.getY());
        GeoLine geoLine = null;
        if (l2 != 0L) {
            geoLine = (GeoLine)InternalGeometry.createInstance(l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)sourceRegion);
        return geoLine;
    }

    public static GeoLine regionToCenterLine(GeoRegion sourceRegion) {
        Generalization.verifyLicense();
        if (sourceRegion == null) {
            String string = InternalResource.loadString("region", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceRegion);
        if (l == 0L) {
            String string = InternalResource.loadString("region", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeneralizationNative.jni_regionToCenterLine(l);
        GeoLine geoLine = null;
        if (l2 != 0L) {
            geoLine = (GeoLine)InternalGeometry.createInstance(l2);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)sourceRegion);
        return geoLine;
    }

    public static GeoRegion[] autoCompletePolygon(DatasetVector regionDataset, Rectangle2D bounds, GeoLine geoLine) {
        long[] lArray;
        Generalization.verifyLicense();
        if (regionDataset == null) {
            String string = InternalResource.loadString("regionDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)regionDataset);
        if (l == 0L) {
            String string = InternalResource.loadString("regionDataset", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (regionDataset.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("sourceDatasetVector", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoLine == null) {
            String string = InternalResource.loadString("geoLine", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoLine);
        if (l2 == 0L) {
            String string = InternalResource.loadString("geoLineHandle", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        Rectangle2D rectangle2D = new Rectangle2D(0.0, 0.0, 0.0, 0.0);
        if (bounds != null) {
            rectangle2D = bounds;
        }
        if ((lArray = GeneralizationNative.jni_autoCompletePolygon(l, rectangle2D.getLeft(), rectangle2D.getRight(), rectangle2D.getTop(), rectangle2D.getBottom(), l2)) == null || lArray.length == 0) {
            return null;
        }
        GeoRegion[] geoRegionArray = new GeoRegion[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            geoRegionArray[i] = (GeoRegion)InternalGeometry.createInstance(lArray[i]);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoLine);
        return geoRegionArray;
    }

    public static boolean aggregatePoints(DatasetVector pointDataset, double distance, Unit unit, int minPilePointCount, Datasource outDatasource, String resultRegionDatasetName, String resultClassFieldName) {
        boolean bl;
        FieldInfos fieldInfos;
        if (pointDataset == null) {
            String string = InternalResource.loadString("pointDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)pointDataset);
        if (l == 0L) {
            String string = InternalResource.loadString("pointDataset", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (pointDataset.getType() != DatasetType.POINT) {
            String string = InternalResource.loadString("pointDataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (minPilePointCount < 2) {
            String string = InternalResource.loadString("minPilePointCount", "Must_Larger_Than_One", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (distance <= 0.0) {
            String string = InternalResource.loadString("distance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        pointDataset.open();
        if (resultClassFieldName != null) {
            fieldInfos = pointDataset.getFieldInfos();
            int n = fieldInfos.indexOf(resultClassFieldName);
            if (n == -1) {
                String string = InternalResource.loadString("GlobalSpecifiedNameNotExists", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (fieldInfos.get(n).isSystemField()) {
                String string = InternalResource.loadString("FieldNotSystemField", "FieldNotSystemField", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if ((fieldInfos = pointDataset.getPrjCoordSys()).getType() != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE && (unit == Unit.SECOND || unit == Unit.MINUTE || unit == Unit.DEGREE || unit == Unit.RADIAN)) {
            String string = InternalResource.loadString("unit", "CannotBeAngleUnit", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        if (resultRegionDatasetName != null) {
            if (outDatasource == null) {
                String string = InternalResource.loadString("outDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!outDatasource.getDatasets().isAvailableDatasetName(resultRegionDatasetName)) {
                String string = InternalResource.loadString("resultRegionDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo();
            datasetVectorInfo.setName(resultRegionDatasetName);
            datasetVectorInfo.setType(DatasetType.REGION);
            DatasetVector datasetVector = outDatasource.getDatasets().create(datasetVectorInfo);
            datasetVector.open();
            datasetVector.setPrjCoordSys(pointDataset.getPrjCoordSys());
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        }
        if (!(bl = GeneralizationNative.jni_AggregatePoints(l, distance, unit.value(), minPilePointCount, l2, resultClassFieldName)) && l2 != 0L) {
            outDatasource.getDatasets().delete(resultRegionDatasetName);
        }
        return bl;
    }

    public static boolean aggregatePoints(DatasetVector pointDataset, int aggregateCount, String weightFieldName, Datasource outDatasource, String resultRegionDatasetName, String resultClassFieldName) {
        boolean bl;
        if (pointDataset == null) {
            String string = InternalResource.loadString("pointDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)pointDataset);
        if (l == 0L) {
            String string = InternalResource.loadString("pointDataset", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (pointDataset.getType() != DatasetType.POINT) {
            String string = InternalResource.loadString("pointDataset", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (aggregateCount <= 0) {
            String string = InternalResource.loadString("aggregateCount", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (weightFieldName != null && !weightFieldName.isEmpty() && pointDataset.getFieldInfos().indexOf(weightFieldName) == -1) {
            String string = InternalResource.loadString("weightFieldName", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (resultClassFieldName == null && resultRegionDatasetName == null) {
            String string = InternalResource.loadString("resultClassFieldName && resultRegionDatasetName", "ResultClassFieldAndResultRegionDatasetNotNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        pointDataset.open();
        if (resultClassFieldName != null) {
            FieldInfos fieldInfos = pointDataset.getFieldInfos();
            int n = fieldInfos.indexOf(resultClassFieldName);
            if (n == -1) {
                String string = InternalResource.loadString("GlobalSpecifiedNameNotExists", "GlobalSpecifiedNameNotExists", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (fieldInfos.get(n).isSystemField()) {
                String string = InternalResource.loadString("FieldNotSystemField", "FieldNotSystemField", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        long l2 = 0L;
        if (resultRegionDatasetName != null) {
            if (outDatasource == null) {
                String string = InternalResource.loadString("outDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (!outDatasource.getDatasets().isAvailableDatasetName(resultRegionDatasetName)) {
                String string = InternalResource.loadString("resultRegionDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo();
            datasetVectorInfo.setName(resultRegionDatasetName);
            datasetVectorInfo.setType(DatasetType.REGION);
            DatasetVector datasetVector = outDatasource.getDatasets().create(datasetVectorInfo);
            datasetVector.open();
            datasetVector.setPrjCoordSys(pointDataset.getPrjCoordSys());
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        }
        if (!(bl = GeneralizationNative.jni_AggregatePoints1(l, aggregateCount, weightFieldName, l2, resultClassFieldName)) && l2 != 0L) {
            outDatasource.getDatasets().delete(resultRegionDatasetName);
        }
        return bl;
    }

    public static boolean edgeMatch(DatasetVector sourceDatasetVector, DatasetVector targetDatasetVector, EdgeMatchParameter edgeMatchParameter) {
        boolean bl;
        Generalization.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (targetDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("targetDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (edgeMatchParameter == null) {
            String string = InternalResource.loadString("edgeMatchParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasetVector);
        double d = edgeMatchParameter.getTolerance();
        if (d < 0.0) {
            String string = InternalResource.loadString("edgeMatchParameter.getTolerance", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        int n = edgeMatchParameter.getEdgeMatchMode().value();
        int n2 = edgeMatchParameter.getEdgeMatchAttributeMethod().value();
        long l3 = 0L;
        GeoLine geoLine = edgeMatchParameter.getEdgeMatchLine();
        if (geoLine != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)geoLine) == 0L) {
                String string = InternalResource.loadString("edgeMatchParameter.getEdgeMatchLine", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoLine);
        }
        long l4 = 0L;
        Datasource datasource = edgeMatchParameter.getOutputDatasource();
        if (datasource != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
                String string = InternalResource.loadString("edgeMatchParameter.getOutputDatasource", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            long l5 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
            String string = edgeMatchParameter.getOutputDatasetLinkName();
            if (!datasource.getDatasets().isAvailableDatasetName(string)) {
                String string2 = InternalResource.loadString("edgeMatchParameter.getOutputDatasetLinkName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
                throw new IllegalArgumentException(string2);
            }
            DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo();
            datasetVectorInfo.setName(string);
            datasetVectorInfo.setType(DatasetType.LINE);
            DatasetVector datasetVector = datasource.getDatasets().create(datasetVectorInfo);
            datasetVector.open();
            datasetVector.setPrjCoordSys(sourceDatasetVector.getPrjCoordSys());
            l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        }
        if (!(bl = GeneralizationNative.jni_edgeMatch1(l, l2, d, n, l3, edgeMatchParameter.isUnion(), l4, n2, edgeMatchParameter.getSourceFieldNames(), edgeMatchParameter.getTargetFieldNames())) && l4 != 0L) {
            datasource.getDatasets().delete(edgeMatchParameter.getOutputDatasetLinkName());
        }
        return bl;
    }

    public static boolean lineAttachRegion(GeoLine geoLine, GeoRegion geoRegion, List<GeoRegion> listRegionCompare, double toleranceLineAttachRegion, double toleranceRegionMerge, double toleranceChange, boolean isUsePreProcess) {
        Generalization.verifyLicense();
        if (geoLine == null) {
            String string = InternalResource.loadString("geoLine", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)geoLine) == 0L) {
            String string = InternalResource.loadString("geoLine", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRegion == null) {
            String string = InternalResource.loadString("geoRegion", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) == 0L) {
            String string = InternalResource.loadString("geoRegion", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = null;
        int[] nArray = null;
        if (listRegionCompare != null && listRegionCompare.size() > 0) {
            int n;
            lArray = new long[listRegionCompare.size()];
            for (n = 0; n < listRegionCompare.size(); ++n) {
                if (listRegionCompare.get(n) == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)listRegionCompare.get(n)) == 0L) {
                    String string = InternalResource.loadString(String.format("%s[%d]", "listRegionCompare", n), "Global_ArgumentNull", "spatialanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                lArray[n] = InternalHandle.getHandle((com.supermap.data.InternalHandle)listRegionCompare.get(n));
            }
            nArray = new int[lArray.length];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = 0;
            }
        }
        if (toleranceLineAttachRegion < 0.0) {
            String string = InternalResource.loadString("toleranceLineAttachRegion", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (toleranceRegionMerge < 0.0) {
            String string = InternalResource.loadString("toleranceRegionMerge", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoLine);
        boolean bl = GeneralizationNative.jni_lineAttachRegion(l2, l, lArray, nArray, toleranceLineAttachRegion, toleranceRegionMerge, toleranceChange, isUsePreProcess);
        if (bl && nArray != null) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] != 0) continue;
                GeoRegion geoRegion2 = listRegionCompare.get(i);
                listRegionCompare.remove(i);
                geoRegion2.dispose();
            }
        }
        return bl;
    }

    public static boolean integrate(DatasetVector sourceDatasetVector, double tolerance, Unit unit) {
        Generalization.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.REGION && sourceDatasetVector.getType() != DatasetType.POINT && sourceDatasetVector.getType() != DatasetType.LINE && sourceDatasetVector.getType() != DatasetType.NETWORK) {
            String string = InternalResource.loadString("sourceDatasetVector", "RecordsetDatasetTypeIsNotSupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance <= 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        PrjCoordSys prjCoordSys = sourceDatasetVector.getPrjCoordSys();
        if (prjCoordSys.getType() != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE && (unit == Unit.SECOND || unit == Unit.MINUTE || unit == Unit.DEGREE || unit == Unit.RADIAN)) {
            String string = InternalResource.loadString("unit", "CannotBeAngleUnit", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        boolean bl = GeneralizationNative.jni_integrate(l, tolerance, unit.value());
        return bl;
    }

    public static DatasetVector featureEnvelope(DatasetVector sourceDataset, String targetDatasetName, Datasource targetDatasource, boolean isSinglePart) {
        Generalization.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (sourceDataset.getType() != DatasetType.REGION && sourceDataset.getType() != DatasetType.LINE) {
            String string = InternalResource.loadString("sourceDataset", "RecordsetDatasetTypeIsNotSupported", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = GeneralizationNative.jni_featureEnvelope(l, targetDatasetName, l2, isSinglePart);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static DatasetVector featureEnvelope(DatasetVector sourceDataset, String targetDatasetName, Datasource targetDatasource) {
        return Generalization.featureEnvelope(sourceDataset, targetDatasetName, targetDatasource, true);
    }

    public static boolean isPrjCoordSysIdentical(PrjCoordSys sourcePrjCoordSys, PrjCoordSys targetPrjCoordSys) {
        if (sourcePrjCoordSys == null) {
            String string = InternalResource.loadString("sourcePrjCoordSys", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourcePrjCoordSys);
        if (l == 0L) {
            String string = InternalResource.loadString("sourcePrjCoordSys", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetPrjCoordSys == null) {
            String string = InternalResource.loadString("targetPrjCoordSys", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetPrjCoordSys);
        if (l2 == 0L) {
            String string = InternalResource.loadString("targetPrjCoordSys", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return GeneralizationNative.jni_isPrjCoordSysIdentical(l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "Generalization";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        Generalization.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

