/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.CAFlushedEvent;
import com.supermap.analyst.spatialanalyst.CAFlushedListener;
import com.supermap.analyst.spatialanalyst.CellularAutomataParameter;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.MCECellularAutomataParameter;
import com.supermap.analyst.spatialanalyst.MultiCriteriaEvaluationCANative;
import com.supermap.analyst.spatialanalyst.PrincipalComponentAnalysisCANative;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.Datasource;
import com.supermap.data.PixelFormat;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;

public class MCECellularAutomata
extends InternalHandleDisposable {
    private static License m_license;
    private static transient Vector m_steppedListeners;
    private static transient Vector m_CAFlushedListeners;

    public MCECellularAutomata() {
        long l = MultiCriteriaEvaluationCANative.jni_New();
        this.setHandle(l, true);
    }

    protected long getHandle() {
        long l = super.getHandle();
        if (l != 0L) {
            // empty if block
        }
        return l;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            MultiCriteriaEvaluationCANative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    private void setCellularAutomataParameter(CellularAutomataParameter value) {
        long l = super.getHandle();
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)value.getCellGrid());
        DatasetGrid[] datasetGridArray = value.getSpatialVariableGrids();
        long[] lArray = new long[datasetGridArray.length];
        for (int i = 0; i < datasetGridArray.length; ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGridArray[i]);
        }
        long l3 = 0L;
        if (value.getOutputDataSource() != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)value.getOutputDataSource());
        }
        PrincipalComponentAnalysisCANative.jni_setCellularAutomataParameter(l, l2, lArray, l3, value.getOutputDatasetName(), value.IsSave(), value.getSaveFrequency(), value.getFlushFrequency(), value.getSimulationCount(), value.getFlushFilePathName(), value.getIterations());
    }

    public double[] checkAHPConsistent(double[][] AHPComparisonMatrix) {
        if (AHPComparisonMatrix == null || AHPComparisonMatrix.length == 0) {
            String string = InternalResource.loadString("AHPComparisonMatrix", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < AHPComparisonMatrix.length; ++i) {
            if (AHPComparisonMatrix[i] == null) {
                String string = InternalResource.loadString("AHPComparisonMatrix[" + i + "]", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (AHPComparisonMatrix.length == AHPComparisonMatrix[i].length) continue;
            String string = InternalResource.loadString("AHPComparisonMatrix[" + i + "].length and AHPComparisonMatrix.length must be the same length.", "ArgumentInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = MultiCriteriaEvaluationCANative.jni_checkAHPConsistent(super.getHandle(), AHPComparisonMatrix);
        if (dArray == null) {
            String string = InternalResource.loadString("AHPComparisonMatrix", "ArgumentInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return dArray;
    }

    public DatasetGrid mceCellularAutomata(Datasource outputDatasource, String outputDatasetName, MCECellularAutomataParameter parameter) {
        MCECellularAutomata.verifyLicense();
        if (parameter == null) {
            String string = InternalResource.loadString("MCECellularAutomataParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        this.CheckParameter(parameter);
        if (null == outputDatasource || 0L == InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource)) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasetName == null || outputDatasetName.trim().equalsIgnoreCase("")) {
            String string = InternalResource.loadString("outputDatasetName", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.setCellularAutomataParameter(parameter.getCellularAutomataParameter());
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        long l2 = 0L;
        if (parameter.isCheckResult()) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)parameter.getEndCellGrid());
        }
        Map<Integer, Boolean> map = parameter.getConversionRules();
        Object[] objectArray = map.keySet().toArray();
        int[] nArray = new int[map.size()];
        boolean[] blArray = new boolean[map.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = (Integer)objectArray[i];
            blArray[i] = map.get(objectArray[i]);
        }
        String[] stringArray = new String[1];
        long l3 = MultiCriteriaEvaluationCANative.jni_mceCA(super.getHandle(), l, outputDatasetName, parameter.isCheckResult(), l2, parameter.getAHPComparisonMatrix(), parameter.getGlobalValue(), parameter.getLocalValue(), parameter.getAlpha(), nArray, blArray, parameter.getConversionTarget(), stringArray);
        DatasetGrid datasetGrid = null;
        if (l3 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l3, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetGrid);
            long[] lArray = MultiCriteriaEvaluationCANative.jni_getIterationResults(super.getHandle());
            if (lArray != null && lArray.length != 0) {
                for (int i = 0; i < lArray.length; ++i) {
                    DatasetGrid datasetGrid2 = InternalDatasetGrid.createInstance(lArray[i], parameter.getCellularAutomataParameter().getOutputDataSource());
                    InternalDatasets.add(parameter.getCellularAutomataParameter().getOutputDataSource().getDatasets(), (Dataset)datasetGrid2);
                }
            }
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        return datasetGrid;
    }

    public double getKappa() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("MultiCriteriaEvaluationCA", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return MultiCriteriaEvaluationCANative.jni_getKappa(super.getHandle());
    }

    private void CheckParameter(MCECellularAutomataParameter para) {
        if (para == null) {
            String string = InternalResource.loadString("MCECellularAutomataParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        CellularAutomataParameter.CheckParameter(para.getCellularAutomataParameter());
        if (para.isCheckResult()) {
            if (null == para.getEndCellGrid() || 0L == InternalHandle.getHandle((com.supermap.data.InternalHandle)para.getEndCellGrid())) {
                String string = InternalResource.loadString("MCECellularAutomataParameter.getEndCellGrid", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
            if (para.getEndCellGrid().getPixelFormat() != PixelFormat.BIT8 && para.getEndCellGrid().getPixelFormat() != PixelFormat.BIT16 && para.getEndCellGrid().getPixelFormat() != PixelFormat.BIT32 && para.getEndCellGrid().getPixelFormat() != PixelFormat.BIT64 && para.getEndCellGrid().getPixelFormat() != PixelFormat.UBIT1 && para.getEndCellGrid().getPixelFormat() != PixelFormat.UBIT4 && para.getEndCellGrid().getPixelFormat() != PixelFormat.UBIT8 && para.getEndCellGrid().getPixelFormat() != PixelFormat.UBIT16 && para.getEndCellGrid().getPixelFormat() != PixelFormat.UBIT32) {
                String string = InternalResource.loadString("CellularAutomataParameter.getCellGrid()", "ZonalDataset_UnsupportedDatasetType", "spatialanalyst_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if (null == para.getAHPComparisonMatrix() || 0 == para.getAHPComparisonMatrix().length) {
            String string = InternalResource.loadString("MCECellularAutomataParameter.getAHPComparisonMatrix", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        double[] dArray = this.checkAHPConsistent(para.getAHPComparisonMatrix());
        if (dArray == null) {
            String string = InternalResource.loadString("MCECellularAutomataParameter.geAHPComparisonMatrix", "ArgumentInvalid", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (para.getLocalValue() <= 0.0 || para.getLocalValue() >= 1.0) {
            String string = InternalResource.loadString("MCECellularAutomataParameter.getLocalValue", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (para.getGlobalValue() <= 0.0 || para.getGlobalValue() >= 1.0) {
            String string = InternalResource.loadString("MCECellularAutomataParameter.getGlobalValue", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        double d = para.getGlobalValue() + para.getLocalValue();
        if (d <= 0.0 || d > 1.0) {
            String string = InternalResource.loadString("MCECellularAutomataParameter.getGlobalValue + MCECellularAutomataParameter.getLocalValue", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (para.getAlpha() <= 0 || para.getAlpha() > 10) {
            String string = InternalResource.loadString("MCECellularAutomataParameter.getAlpha", "ArgumentInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (para.getConversionRules() == null || para.getConversionRules().size() == 0) {
            String string = InternalResource.loadString("MCECellularAutomataParameter.getConversionRules()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "MCECellularAutomata";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        MCECellularAutomata.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    public static synchronized void addCAFlushedListener(CAFlushedListener l) {
        if (m_CAFlushedListeners == null) {
            m_CAFlushedListeners = new Vector();
        }
        if (!m_CAFlushedListeners.contains(l)) {
            m_CAFlushedListeners.add(l);
        }
    }

    public static synchronized void removeCAFlushedListener(CAFlushedListener l) {
        if (m_CAFlushedListeners != null && m_CAFlushedListeners.contains(l)) {
            m_CAFlushedListeners.remove(l);
        }
    }

    protected static void fireCAFlushed(CAFlushedEvent event) {
        if (m_CAFlushedListeners != null) {
            Vector vector = m_CAFlushedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CAFlushedListener)vector.elementAt(i)).CAFlushed(event);
            }
        }
    }

    static void CAFlushedCallBack(String strFlushFilePathName) {
        Object object = new Object();
        CAFlushedEvent cAFlushedEvent = new CAFlushedEvent(object, strFlushFilePathName);
        MCECellularAutomata.fireCAFlushed(cAFlushedEvent);
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

