/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.analyst.spatialanalyst.CAFlushedEvent;
import com.supermap.analyst.spatialanalyst.CAFlushedListener;
import com.supermap.analyst.spatialanalyst.CellularAutomataParameter;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalHandleDisposable;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.PCACellularAutomataParameter;
import com.supermap.analyst.spatialanalyst.PCAEigenResult;
import com.supermap.analyst.spatialanalyst.PCAEigenValue;
import com.supermap.analyst.spatialanalyst.PrincipalComponentAnalysisCANative;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.Datasource;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;

public class PCACellularAutomata
extends InternalHandleDisposable {
    private static License m_license;
    private static transient Vector m_steppedListeners;
    private static transient Vector m_CAFlushedListeners;
    PCAEigenResult m_PrimaryComponentEigenResult;

    public PCACellularAutomata() {
        long l = PrincipalComponentAnalysisCANative.jni_New();
        this.setHandle(l, true);
    }

    protected long getHandle() {
        long l = super.getHandle();
        if (l != 0L) {
            // empty if block
        }
        return l;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            PrincipalComponentAnalysisCANative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    private void setCellularAutomataParameter(CellularAutomataParameter value) {
        long l = super.getHandle();
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)value.getCellGrid());
        DatasetGrid[] datasetGridArray = value.getSpatialVariableGrids();
        long[] lArray = new long[datasetGridArray.length];
        for (int i = 0; i < datasetGridArray.length; ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGridArray[i]);
        }
        long l3 = 0L;
        if (value.getOutputDataSource() != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)value.getOutputDataSource());
        }
        PrincipalComponentAnalysisCANative.jni_setCellularAutomataParameter(l, l2, lArray, l3, value.getOutputDatasetName(), value.IsSave(), value.getSaveFrequency(), value.getFlushFrequency(), value.getSimulationCount(), value.getFlushFilePathName(), value.getIterations());
    }

    private PCAEigenResult getPrimaryComponentEigenResult() {
        return this.m_PrimaryComponentEigenResult;
    }

    public PCAEigenResult pca(DatasetGrid[] spatialVariableGrids, int nSampleCount, double dComponentRatio) {
        int n;
        PCACellularAutomata.verifyLicense();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("PCACellularAutomata", "Handle_ObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (dComponentRatio <= 0.0 || dComponentRatio > 1.0) {
            String string = InternalResource.loadString("dComponentRatio", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (nSampleCount < 100) {
            String string = InternalResource.loadString("nSampleCount", "GlobalGreaterThanHundred", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (spatialVariableGrids == null || spatialVariableGrids.length == 0) {
            String string = InternalResource.loadString("spatialVariableGrids", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        for (n = 0; n < spatialVariableGrids.length; ++n) {
            if (spatialVariableGrids[n] != null && 0L != InternalHandle.getHandle((com.supermap.data.InternalHandle)spatialVariableGrids[n])) continue;
            String string = InternalResource.loadString("spatialVariableGrids[" + n + "]", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        n = spatialVariableGrids.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)spatialVariableGrids[i]);
        }
        String[] stringArray = new String[n];
        double[] dArray = new double[3 * n];
        String[] stringArray2 = new String[n];
        double[] dArray2 = new double[n * n];
        String[] stringArray3 = new String[1];
        int n2 = PrincipalComponentAnalysisCANative.jni_principalComponentAnalysis(super.getHandle(), lArray, nSampleCount, dComponentRatio, stringArray, dArray, stringArray2, dArray2, stringArray3);
        this.m_PrimaryComponentEigenResult = null;
        if (n2 > 0) {
            int n3 = n2;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray2.length; ++i) {
                arrayList.add(stringArray2[i]);
            }
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            for (int i = 0; i < n3 * n; ++i) {
                arrayList2.add(dArray2[i]);
            }
            ArrayList<PCAEigenValue> arrayList3 = new ArrayList<PCAEigenValue>();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList3.add(new PCAEigenValue(dArray[i * 3 + 0], stringArray[i], dArray[i * 3 + 1], dArray[i * 3 + 2]));
            }
            this.m_PrimaryComponentEigenResult = new PCAEigenResult(n3, arrayList, arrayList3, arrayList2);
        } else if (stringArray3[0] != null && !stringArray3[0].isEmpty()) {
            throw new RuntimeException(stringArray3[0]);
        }
        return this.m_PrimaryComponentEigenResult;
    }

    public DatasetGrid pcaCellularAutomata(Datasource outputDatasource, String outputDatasetName, PCACellularAutomataParameter parameter) {
        PCACellularAutomata.verifyLicense();
        if (parameter == null) {
            String string = InternalResource.loadString("PCACellularAutomataParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (this.m_PrimaryComponentEigenResult == null) {
            String string = InternalResource.loadString("Please execute 'pca()' method first.", "Global_EnumValueIsError", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        this.CheckParameter(parameter);
        if (null == outputDatasource || 0L == InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource)) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasetName == null || outputDatasetName.trim().equalsIgnoreCase("")) {
            String string = InternalResource.loadString("outputDatasetName", "Global_StringIsNullOrEmpty", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.setCellularAutomataParameter(parameter.getCellularAutomataParameter());
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        Map<Integer, Boolean> map = parameter.getConversionRules();
        Object[] objectArray = map.keySet().toArray();
        int[] nArray = new int[map.size()];
        boolean[] blArray = new boolean[map.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = (Integer)objectArray[i];
            blArray[i] = map.get(objectArray[i]);
        }
        String[] stringArray = new String[1];
        long l2 = PrincipalComponentAnalysisCANative.jni_pcaCA(super.getHandle(), l, outputDatasetName, parameter.getComponentWeights(), parameter.getIndexK(), parameter.getAlpha(), nArray, blArray, parameter.getConversionTarget(), stringArray);
        DatasetGrid datasetGrid = null;
        if (l2 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l2, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetGrid);
            long[] lArray = PrincipalComponentAnalysisCANative.jni_getIterationResults(super.getHandle());
            if (lArray != null && lArray.length != 0) {
                for (int i = 0; i < lArray.length; ++i) {
                    DatasetGrid datasetGrid2 = InternalDatasetGrid.createInstance(lArray[i], parameter.getCellularAutomataParameter().getOutputDataSource());
                    InternalDatasets.add(parameter.getCellularAutomataParameter().getOutputDataSource().getDatasets(), (Dataset)datasetGrid2);
                }
            }
        } else if (stringArray[0] != null && !stringArray[0].isEmpty()) {
            throw new RuntimeException(stringArray[0]);
        }
        return datasetGrid;
    }

    private void CheckParameter(PCACellularAutomataParameter para) {
        if (para == null) {
            String string = InternalResource.loadString("PCACellularAutomataParameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        CellularAutomataParameter.CheckParameter(para.getCellularAutomataParameter());
        if (null == para.getComponentWeights() || 0 == para.getComponentWeights().length) {
            String string = InternalResource.loadString("PCACellularAutomataParameter.getComponentWeights()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (this.m_PrimaryComponentEigenResult.getComponentCount() != para.getComponentWeights().length) {
            String string = InternalResource.loadString("PCACellularAutomataParameter.getComponentWeights() and PrimaryComponentEigenResult.getComponentCount() must be the same length.", "ArgumentInvalid", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        double[] dArray = para.getComponentWeights();
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] <= 0.0) && !(dArray[i] > 1.0)) continue;
            String string = InternalResource.loadString("PCACellularAutomataParameter.getComponentWeights()[" + i + "]", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (para.getIndexK() <= 0.0 || para.getIndexK() >= 100.0) {
            String string = InternalResource.loadString("PCACellularAutomataParameter.getIndexK()", "ShouldBetweenZeroAndHundred", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (para.getConversionRules() == null || para.getConversionRules().size() == 0) {
            String string = InternalResource.loadString("PCACellularAutomataParameter.getConversionRules()", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "PCACellularAutomata";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        PCACellularAutomata.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    public static synchronized void addCAFlushedListener(CAFlushedListener l) {
        if (m_CAFlushedListeners == null) {
            m_CAFlushedListeners = new Vector();
        }
        if (!m_CAFlushedListeners.contains(l)) {
            m_CAFlushedListeners.add(l);
        }
    }

    public static synchronized void removeCAFlushedListener(CAFlushedListener l) {
        if (m_CAFlushedListeners != null && m_CAFlushedListeners.contains(l)) {
            m_CAFlushedListeners.remove(l);
        }
    }

    protected static void fireCAFlushed(CAFlushedEvent event) {
        if (m_CAFlushedListeners != null) {
            Vector vector = m_CAFlushedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((CAFlushedListener)vector.elementAt(i)).CAFlushed(event);
            }
        }
    }

    static void CAFlushedCallBack(String strFlushFilePathName) {
        Object object = new Object();
        CAFlushedEvent cAFlushedEvent = new CAFlushedEvent(object, strFlushFilePathName);
        PCACellularAutomata.fireCAFlushed(cAFlushedEvent);
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

