/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DatasetGroup;
import com.supermap.data.DatasetGroupCreatedEvent;
import com.supermap.data.DatasetGroupCreatedListener;
import com.supermap.data.DatasetGroupDeletedEvent;
import com.supermap.data.DatasetGroupDeletedListener;
import com.supermap.data.DatasetGroupDeletingEvent;
import com.supermap.data.DatasetGroupDeletingListener;
import com.supermap.data.DatasetGroupNative;
import com.supermap.data.InternalResource;
import java.util.ArrayList;
import java.util.Vector;

public class DatasetGroups {
    private DatasetGroup m_parent;
    private ArrayList<DatasetGroup> m_childGroups;
    private Vector<DatasetGroupDeletingListener> m_deletingListeners;
    private Vector<DatasetGroupDeletedListener> m_deletedListeners;
    private Vector<DatasetGroupCreatedListener> m_createdListeners;

    DatasetGroups(DatasetGroup parent) {
        this.m_parent = parent;
        this.initializeChildren();
    }

    private void initializeChildren() {
        this.m_childGroups = new ArrayList();
        int n = this.getCount();
        long l = this.m_parent.getHandle();
        for (int i = 0; i < n; ++i) {
            long l2 = DatasetGroupNative.jni_GetChildHanlde(l, i);
            this.m_childGroups.add(new DatasetGroup(l2, this.m_parent.getDatasource(), this.m_parent));
        }
    }

    public DatasetGroup get(int index) {
        if (this.m_parent == null || this.m_parent.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.m_childGroups.get(index);
    }

    public DatasetGroup get(String name) {
        if (this.m_parent == null || this.m_parent.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetGroup datasetGroup = null;
        int n = this.indexOf(name);
        if (n != -1) {
            datasetGroup = this.m_childGroups.get(n);
        }
        return datasetGroup;
    }

    public int getCount() {
        if (this.m_parent == null || this.m_parent.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGroupNative.jni_GetChildCount(this.m_parent.getHandle());
    }

    public int indexOf(String name) {
        if (this.m_parent == null || this.m_parent.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return DatasetGroupNative.jni_IndexOfChildGroup(this.m_parent.getHandle(), name);
    }

    public DatasetGroup create(String name) {
        if (this.m_parent == null || this.m_parent.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.contains(name) && this.indexOf(name) != -1) {
            String string = InternalResource.loadString("name", "Global_SpecifiedNameAlreadyExist", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = DatasetGroupNative.jni_CreateGroup(this.m_parent.getHandle(), name);
        DatasetGroup datasetGroup = null;
        if (l != 0L) {
            datasetGroup = new DatasetGroup(l, this.m_parent.getDatasource(), this.m_parent);
            this.m_childGroups.add(datasetGroup);
        }
        this.fireCreated(new DatasetGroupCreatedEvent(this, name));
        return datasetGroup;
    }

    public boolean contains(String name) {
        if (this.m_parent == null || this.m_parent.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.indexOf(name) != -1;
    }

    public boolean delete(String name) {
        if (this.m_parent == null || this.m_parent.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Global_OwnerHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = this.indexOf(name);
        if (n == -1) {
            return true;
        }
        boolean bl = false;
        DatasetGroupDeletingEvent datasetGroupDeletingEvent = new DatasetGroupDeletingEvent(this, name, false);
        this.fireDeleting(datasetGroupDeletingEvent);
        if (!datasetGroupDeletingEvent.isCancel() && (bl = DatasetGroupNative.jni_DeleteChildGroup(this.m_parent.getHandle(), name))) {
            DatasetGroup datasetGroup = this.m_childGroups.get(n);
            datasetGroup.clearHandle();
            this.m_childGroups.remove(n);
            this.fireDeleted(new DatasetGroupDeletedEvent(this, name));
        }
        return bl;
    }

    protected void clearHandle() {
        this.m_parent = null;
        for (DatasetGroup datasetGroup : this.m_childGroups) {
            datasetGroup.clearHandle();
        }
        this.m_childGroups.clear();
        this.m_childGroups = null;
    }

    public synchronized void addCreatedListener(DatasetGroupCreatedListener l) {
        if (this.m_createdListeners == null) {
            this.m_createdListeners = new Vector();
        }
        if (!this.m_createdListeners.contains(l)) {
            this.m_createdListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeCreatedListener(DatasetGroupCreatedListener l) {
        if (this.m_createdListeners != null && this.m_createdListeners.contains(l)) {
            this.m_createdListeners.remove(l);
        }
    }

    public synchronized void addDeletingListener(DatasetGroupDeletingListener l) {
        if (this.m_deletingListeners == null) {
            this.m_deletingListeners = new Vector();
        }
        if (!this.m_deletingListeners.contains(l)) {
            this.m_deletingListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeDeletingListener(DatasetGroupDeletingListener l) {
        if (this.m_deletingListeners != null && this.m_deletingListeners.contains(l)) {
            this.m_deletingListeners.remove(l);
        }
    }

    public synchronized void addDeletedListener(DatasetGroupDeletedListener l) {
        if (this.m_deletedListeners == null) {
            this.m_deletedListeners = new Vector();
        }
        if (!this.m_deletedListeners.contains(l)) {
            this.m_deletedListeners.insertElementAt(l, 0);
        }
    }

    public synchronized void removeDeletedListener(DatasetGroupDeletedListener l) {
        if (this.m_deletedListeners != null && this.m_deletedListeners.contains(l)) {
            this.m_deletedListeners.remove(l);
        }
    }

    protected void fireCreated(DatasetGroupCreatedEvent event) {
        if (this.m_createdListeners != null) {
            Vector<DatasetGroupCreatedListener> vector = this.m_createdListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                vector.elementAt(i).datasetGroupCreated(event);
            }
        }
    }

    protected void fireDeleting(DatasetGroupDeletingEvent event) {
        if (this.m_deletingListeners != null) {
            Vector<DatasetGroupDeletingListener> vector = this.m_deletingListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                vector.elementAt(i).datasetGroupDeleting(event);
            }
        }
    }

    protected void fireDeleted(DatasetGroupDeletedEvent event) {
        if (this.m_deletedListeners != null) {
            Vector<DatasetGroupDeletedListener> vector = this.m_deletedListeners;
            int n = vector.size();
            for (int i = n - 1; i >= 0; --i) {
                vector.elementAt(i).datasetGroupDeleted(event);
            }
        }
    }

    void refreshManagedItem() {
        int n = this.m_childGroups.size();
        int n2 = this.getCount();
        for (int i = n; i < n2; ++i) {
            long l = DatasetGroupNative.jni_GetChildHanlde(this.m_parent.getHandle(), i);
            DatasetGroup datasetGroup = new DatasetGroup(l, this.m_parent.getDatasource(), this.m_parent);
            this.m_childGroups.add(datasetGroup);
            this.fireCreated(new DatasetGroupCreatedEvent(this, datasetGroup.getName()));
        }
        for (DatasetGroup datasetGroup : this.m_childGroups) {
            datasetGroup.getChildGroups().refreshManagedItem();
        }
    }
}

