/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.DynamicSegmentInfoNative;
import com.supermap.data.DynamicSegmentRole;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Recordset;

public class DynamicSegmentInfo
extends InternalHandleDisposable {
    private Datasource m_datasource;
    private DatasetVector m_RouteDataset;
    private DatasetVector m_ETDataset;
    private DatasetVector m_ERDataset;

    DynamicSegmentInfo(long handle, Datasource datasource) {
        if (handle == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasource == null) {
            String string = InternalResource.loadString("datasource", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("datasource", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(handle, true);
        this.m_datasource = datasource;
        String string = DynamicSegmentInfoNative.jni_GetRouteDatasetName(this.getHandle());
        this.m_RouteDataset = (DatasetVector)this.m_datasource.getDatasets().get(string);
        String string2 = DynamicSegmentInfoNative.jni_GetEventTableDatasetName(this.getHandle());
        this.m_ETDataset = (DatasetVector)this.m_datasource.getDatasets().get(string2);
        String string3 = DynamicSegmentInfoNative.jni_GetEventResultDatasetName(this.getHandle());
        this.m_ERDataset = (DatasetVector)this.m_datasource.getDatasets().get(string3);
    }

    public DatasetVector getDataset(DynamicSegmentRole dynamicRole) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = dynamicRole.getUGCValue();
        switch (n) {
            case 0: {
                return this.m_RouteDataset;
            }
            case 1: {
                return this.m_ETDataset;
            }
            case 2: {
                return this.m_ERDataset;
            }
        }
        return null;
    }

    public DynamicSegmentRole getDatasetRole(DatasetVector dynamicDataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        if (dynamicDataset == this.m_RouteDataset) {
            return DynamicSegmentRole.ROUTEDATASET;
        }
        if (dynamicDataset == this.m_ETDataset) {
            return DynamicSegmentRole.EVENTTABLE;
        }
        if (dynamicDataset == this.m_ERDataset) {
            return DynamicSegmentRole.EVENTRESULT;
        }
        return DynamicSegmentRole.NONEROLE;
    }

    public Recordset Query(DynamicSegmentRole destDynamicRole, DynamicSegmentRole srcDynamicRole, int[] srcDynamicIDs) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_datasource == null || this.m_datasource.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Dataset_DatasoureIsEmpty", "data_resources");
            throw new IllegalStateException(string);
        }
        Recordset recordset = null;
        long l = 0L;
        DatasetVector datasetVector = this.getDataset(srcDynamicRole);
        int n = destDynamicRole.getUGCValue();
        switch (n) {
            case 0: {
                l = DynamicSegmentInfoNative.jni_QueryRoute(datasetVector.getHandle(), this.m_RouteDataset.getHandle(), this.m_ETDataset.getHandle(), this.m_ERDataset.getHandle(), this.m_datasource.getHandle(), srcDynamicIDs);
                if (l == 0L) break;
                recordset = new Recordset(l, this.m_RouteDataset);
                break;
            }
            case 1: {
                l = DynamicSegmentInfoNative.jni_QueryEventTable(datasetVector.getHandle(), this.m_RouteDataset.getHandle(), this.m_ETDataset.getHandle(), this.m_ERDataset.getHandle(), this.m_datasource.getHandle(), srcDynamicIDs);
                if (l == 0L) break;
                recordset = new Recordset(l, this.m_ETDataset);
                break;
            }
            case 2: {
                l = DynamicSegmentInfoNative.jni_QueryEventResult(datasetVector.getHandle(), this.m_RouteDataset.getHandle(), this.m_ETDataset.getHandle(), this.m_ERDataset.getHandle(), this.m_datasource.getHandle(), srcDynamicIDs);
                if (l == 0L) break;
                recordset = new Recordset(l, this.m_ERDataset);
                break;
            }
        }
        return recordset;
    }

    @Override
    public void dispose() {
        this.m_datasource = null;
        this.m_RouteDataset = null;
        this.m_ETDataset = null;
        this.m_ERDataset = null;
        this.setHandle(0L);
    }
}

