/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.WeightFieldInfo;
import com.supermap.analyst.networkanalyst.WeightFieldInfos;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;

public class FacilityAnalystSetting {
    private DatasetVector m_datasetVector = null;
    private String m_nodeIDField = "SmNodeID";
    private String m_edgeIDField = "SmID";
    private String m_fNodeIDField = "SmFNode";
    private String m_tNodeIDField = "SmTNode";
    private WeightFieldInfos m_weightFieldInfos = null;
    private double m_tolerance = 0.0;
    private int[] m_barrierNodes;
    private int[] m_barrierEdges;
    private String m_directionField = null;
    private boolean m_needSet = true;
    private boolean m_needLoadModel = true;

    public FacilityAnalystSetting() {
        this.m_weightFieldInfos = new WeightFieldInfos();
        WeightFieldInfo weightFieldInfo = new WeightFieldInfo();
        weightFieldInfo.setName("Length");
        weightFieldInfo.setFTWeightField("SmLength");
        weightFieldInfo.setTFWeightField("SmLength");
        this.m_weightFieldInfos.add(weightFieldInfo);
        this.m_weightFieldInfos.setOwner2(this);
    }

    public FacilityAnalystSetting(FacilityAnalystSetting facilityAnalystSetting) {
        if (facilityAnalystSetting == null) {
            String string = InternalResource.loadString("facilityAnalystSetting", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        this.m_weightFieldInfos = new WeightFieldInfos();
        this.m_weightFieldInfos.setOwner2(this);
        this.copyFrom(facilityAnalystSetting);
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public int[] getBarrierEdges() {
        return this.m_barrierEdges;
    }

    public void setBarrierEdges(int[] edges) {
        if (edges == null) {
            this.m_barrierEdges = null;
        } else {
            int n = edges.length;
            this.m_barrierEdges = new int[n];
            for (int i = 0; i < n; ++i) {
                if (edges[i] <= 0) {
                    String string = InternalResource.loadString("value[" + i + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                this.m_barrierEdges[i] = edges[i];
            }
        }
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public int[] getBarrierNodes() {
        return this.m_barrierNodes;
    }

    public void setBarrierNodes(int[] nodes) {
        if (nodes == null) {
            this.m_barrierNodes = null;
        } else {
            int n = nodes.length;
            this.m_barrierNodes = new int[n];
            for (int i = 0; i < n; ++i) {
                if (nodes[i] <= 0) {
                    String string = InternalResource.loadString("value[" + i + "]", "Global_IDShouldGreaterThanZero", "networkanalyst_resources");
                    throw new IllegalArgumentException(string);
                }
                this.m_barrierNodes[i] = nodes[i];
            }
        }
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public DatasetVector getNetworkDataset() {
        return this.m_datasetVector;
    }

    public void setNetworkDataset(DatasetVector datasetVector) {
        if (datasetVector != null && datasetVector.getType() != DatasetType.NETWORK) {
            String string = InternalResource.loadString("datasetVector", "FacilityAnalyst_DatasetTypeMustBeNetwork", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_datasetVector = datasetVector;
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public String getDirectionField() {
        return this.m_directionField;
    }

    public void setDirectionField(String directionField) {
        this.m_directionField = directionField;
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public String getEdgeIDField() {
        return this.m_edgeIDField;
    }

    public void setEdgeIDField(String edgeIDfield) {
        if (edgeIDfield == null || edgeIDfield.trim().length() == 0) {
            String string = InternalResource.loadString("edgeIDfield", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_edgeIDField = edgeIDfield;
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public String getFNodeIDField() {
        return this.m_fNodeIDField;
    }

    public void setFNodeIDField(String fNodeIDField) {
        if (fNodeIDField == null || fNodeIDField.trim().length() == 0) {
            String string = InternalResource.loadString("fNodeIDField", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_fNodeIDField = fNodeIDField;
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public String getNodeIDField() {
        return this.m_nodeIDField;
    }

    public void setNodeIDField(String nodeIDField) {
        if (nodeIDField == null || nodeIDField.trim().length() == 0) {
            String string = InternalResource.loadString("nodeIDField", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_nodeIDField = nodeIDField;
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public String getTNodeIDField() {
        return this.m_tNodeIDField;
    }

    public void setTNodeIDField(String tNodeIDField) {
        if (tNodeIDField == null || tNodeIDField.trim().length() == 0) {
            String string = InternalResource.loadString("tNodeIDField", "Global_StringIsNullOrEmpty", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_tNodeIDField = tNodeIDField;
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    public double getTolerance() {
        return this.m_tolerance;
    }

    public void setTolerance(double tolerance) {
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "FacilityAnalystSetting_ToleranceShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_tolerance = tolerance;
        this.m_needSet = true;
    }

    public WeightFieldInfos getWeightFieldInfos() {
        return this.m_weightFieldInfos;
    }

    public void setWeightFieldInfos(WeightFieldInfos weightFieldInfos) {
        if (weightFieldInfos == null) {
            String string = InternalResource.loadString("weightFieldInfos", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (weightFieldInfos.getCount() <= 0) {
            String string = InternalResource.loadString("weightFieldInfos", "FacilityAnalystSetting_WeightFieldInfoCountShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_weightFieldInfos = weightFieldInfos;
        this.m_needSet = true;
        this.m_needLoadModel = true;
    }

    void copyFrom(FacilityAnalystSetting value) {
        if (value != null && !this.equals(value)) {
            this.setNetworkDataset(value.getNetworkDataset());
            this.setNodeIDField(value.getNodeIDField());
            this.setEdgeIDField(value.getEdgeIDField());
            this.setFNodeIDField(value.getFNodeIDField());
            this.setTNodeIDField(value.getTNodeIDField());
            this.setWeightFieldInfos(value.getWeightFieldInfos());
            this.setTolerance(value.getTolerance());
            this.setBarrierNodes(value.getBarrierNodes());
            this.setBarrierEdges(value.getBarrierEdges());
            this.setDirectionField(value.getDirectionField());
            this.m_needSet = true;
            this.m_needLoadModel = true;
        }
    }

    boolean getNeedSet() {
        return this.m_needSet;
    }

    void setNeedSet(boolean value) {
        this.m_needSet = value;
    }

    boolean getNeedLoadModel() {
        return this.m_needLoadModel;
    }

    void setNeedLoadModel(boolean value) {
        this.m_needLoadModel = value;
    }
}

