/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.InternalHandle;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.MapMatchingResultNative;
import com.supermap.data.GeoLine;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.PrjCoordSys;

public class MapMatchingLikelyResult {
    private Point2D m_pntOnRoad;
    private Double m_dDistanceToRoad;
    private int[] m_edges;
    private Double m_dProbability;
    private Point2D[] m_trackPoints;
    private PrjCoordSys m_prj;

    MapMatchingLikelyResult(Point2D pntOnRoad, double distanceToRoad, int[] edges, double dProbability, Point2D[] tracks, PrjCoordSys prj) {
        this.m_pntOnRoad = pntOnRoad;
        this.m_dDistanceToRoad = distanceToRoad;
        this.m_edges = edges;
        this.m_dProbability = dProbability;
        this.m_trackPoints = tracks;
        this.m_prj = prj;
    }

    public Point2D getRectifiedPoint() {
        return this.m_pntOnRoad;
    }

    public double getDistanceToRoad() {
        return this.m_dDistanceToRoad;
    }

    public double getProbability() {
        return this.m_dProbability;
    }

    public int[] getEdges() {
        return this.m_edges;
    }

    public Point2D[] getTrackPoints() {
        return this.m_trackPoints;
    }

    public GeoLine getTrackLine() {
        if (this.m_trackPoints != null && this.m_trackPoints.length > 1) {
            return new GeoLine(new Point2Ds(this.m_trackPoints));
        }
        return null;
    }

    public double evaluateTruth(GeoLine[] truthEdges) {
        if (truthEdges == null) {
            String string = InternalResource.loadString("truthEdges", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (this.m_trackPoints == null) {
            String string = InternalResource.loadString("TrackPoints", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (truthEdges.length == 0) {
            String string = InternalResource.loadString("truthEdges", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_trackPoints.length == 0) {
            String string = InternalResource.loadString("TrackPoints", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[truthEdges.length];
        for (int i = 0; i < truthEdges.length; ++i) {
            if (truthEdges[i] == null) {
                String string = InternalResource.loadString(String.format("truthEdges[%d]", i), "Global_ArgumentNull", "networkanalyst_resources");
                throw new NullPointerException(string);
            }
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)truthEdges[i]) == 0L) {
                String string = InternalResource.loadString(String.format("truthEdges[%d]", i), "Global_ArgumentObjectHasBeenDisposed", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)truthEdges[i]);
        }
        long l = this.m_prj != null ? InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_prj) : 0L;
        double[] dArray = new double[this.m_trackPoints.length];
        double[] dArray2 = new double[this.m_trackPoints.length];
        for (int i = 0; i < this.m_trackPoints.length; ++i) {
            dArray[i] = this.m_trackPoints[i].x;
            dArray2[i] = this.m_trackPoints[i].y;
        }
        return MapMatchingResultNative.jni_EvaluationTruth(lArray, dArray, dArray2, l);
    }

    public double evaluateError(GeoLine[] truthEdges) {
        if (truthEdges == null) {
            String string = InternalResource.loadString("truthEdges", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (this.m_trackPoints == null) {
            String string = InternalResource.loadString("TrackPoints", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (truthEdges.length == 0) {
            String string = InternalResource.loadString("truthEdges", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_trackPoints.length == 0) {
            String string = InternalResource.loadString("TrackPoints", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[truthEdges.length];
        for (int i = 0; i < truthEdges.length; ++i) {
            if (truthEdges[i] == null) {
                String string = InternalResource.loadString(String.format("truthEdges[%d]", i), "Global_ArgumentNull", "networkanalyst_resources");
                throw new NullPointerException(string);
            }
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)truthEdges[i]) == 0L) {
                String string = InternalResource.loadString(String.format("truthEdges[%d]", i), "Global_ArgumentObjectHasBeenDisposed", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)truthEdges[i]);
        }
        long l = this.m_prj != null ? InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_prj) : 0L;
        double[] dArray = new double[this.m_trackPoints.length];
        double[] dArray2 = new double[this.m_trackPoints.length];
        for (int i = 0; i < this.m_trackPoints.length; ++i) {
            dArray[i] = this.m_trackPoints[i].x;
            dArray2[i] = this.m_trackPoints[i].y;
        }
        return MapMatchingResultNative.jni_EvaluationError(lArray, dArray, dArray2, l);
    }
}

