/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.chart;

import com.supermap.chart.InternalHandleDisposable;
import com.supermap.chart.InternalResource;
import com.supermap.chart.S57DatasetGroupExtInfoNative;
import com.supermap.chart.S57DatasetType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGroup;
import com.supermap.data.DatasetType;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandle;
import com.supermap.data.PrjCoordSys;
import java.util.HashMap;

public class S57DatasetGroupExtInfo
extends InternalHandleDisposable {
    private DatasetGroup m_datasetGroup;

    public S57DatasetGroupExtInfo(DatasetGroup datasetGroup) {
        if (datasetGroup == null) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)datasetGroup);
        this.setHandle(S57DatasetGroupExtInfoNative.jni_New(l), true);
        this.setDatasetGroup(datasetGroup);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            S57DatasetGroupExtInfoNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    public DatasetGroup getDatasetGroup() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return this.m_datasetGroup;
    }

    public void setDatasetGroup(DatasetGroup datasetGroup) {
        if (datasetGroup == null) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_datasetGroup = datasetGroup;
        if (datasetGroup != null) {
            long l = InternalHandle.getHandle((InternalHandle)datasetGroup);
            S57DatasetGroupExtInfoNative.jni_setDatasetGroup(this.getHandle(), l);
        }
    }

    public boolean update() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return S57DatasetGroupExtInfoNative.jni_update(this.getHandle());
    }

    public boolean isChartDatasetGroup() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return S57DatasetGroupExtInfoNative.jni_isChartDatasetGroup(this.getHandle());
    }

    public String getChartCellName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return S57DatasetGroupExtInfoNative.jni_getChartCellName(this.getHandle());
    }

    public void setChartCellName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        S57DatasetGroupExtInfoNative.jni_setChartCellName(this.getHandle(), value);
    }

    public long getChartScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return S57DatasetGroupExtInfoNative.jni_getChartScale(this.getHandle());
    }

    public void setChartScale(long value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        S57DatasetGroupExtInfoNative.jni_setChartScale(this.getHandle(), value);
    }

    public PrjCoordSys getPrjCoordSys() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        PrjCoordSys prjCoordSys = new PrjCoordSys();
        String string = S57DatasetGroupExtInfoNative.jni_getPrjCoordSys(this.getHandle());
        if (prjCoordSys.fromXML(string)) {
            return prjCoordSys;
        }
        return null;
    }

    public void setPrjCoordSys(PrjCoordSys value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        S57DatasetGroupExtInfoNative.jni_setPrjCoordSys(this.getHandle(), value.toXML());
    }

    public Dataset getDSIDDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        String string = S57DatasetGroupExtInfoNative.jni_getFunctionalDatasetName(this.getHandle(), S57DatasetType.S57DSID.value());
        Datasource datasource = this.m_datasetGroup.getDatasource();
        if (datasource == null) {
            return null;
        }
        Dataset dataset = datasource.getDatasets().get(string);
        return dataset;
    }

    public void setDSIDDataset(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (dataset == null) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        String string = dataset.getName();
        S57DatasetGroupExtInfoNative.jni_setFunctionalDatasetName(this.getHandle(), S57DatasetType.S57DSID.value(), string);
    }

    public Dataset getVectorIsolatedDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        String string = S57DatasetGroupExtInfoNative.jni_getFunctionalDatasetName(this.getHandle(), S57DatasetType.S57VI.value());
        Datasource datasource = this.m_datasetGroup.getDatasource();
        if (datasource == null) {
            return null;
        }
        Dataset dataset = datasource.getDatasets().get(string);
        return dataset;
    }

    public void setVectorIsolatedDataset(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (dataset == null) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        String string = dataset.getName();
        S57DatasetGroupExtInfoNative.jni_setFunctionalDatasetName(this.getHandle(), S57DatasetType.S57VI.value(), string);
    }

    public Dataset getVectorConnectedDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        String string = S57DatasetGroupExtInfoNative.jni_getFunctionalDatasetName(this.getHandle(), S57DatasetType.S57VC.value());
        Datasource datasource = this.m_datasetGroup.getDatasource();
        if (datasource == null) {
            return null;
        }
        Dataset dataset = datasource.getDatasets().get(string);
        return dataset;
    }

    public void setVectorConnectedDataset(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (dataset == null) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        String string = dataset.getName();
        S57DatasetGroupExtInfoNative.jni_setFunctionalDatasetName(this.getHandle(), S57DatasetType.S57VC.value(), string);
    }

    public Dataset getVectorEdgeDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        String string = S57DatasetGroupExtInfoNative.jni_getFunctionalDatasetName(this.getHandle(), S57DatasetType.S57VE.value());
        Datasource datasource = this.m_datasetGroup.getDatasource();
        if (datasource == null) {
            return null;
        }
        Dataset dataset = datasource.getDatasets().get(string);
        return dataset;
    }

    public void setVectorEdgeDataset(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (dataset == null) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        String string = dataset.getName();
        S57DatasetGroupExtInfoNative.jni_setFunctionalDatasetName(this.getHandle(), S57DatasetType.S57VE.value(), string);
    }

    public Dataset getFeatureToPointDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        String string = S57DatasetGroupExtInfoNative.jni_getFunctionalDatasetName(this.getHandle(), S57DatasetType.S57FVP.value());
        Datasource datasource = this.m_datasetGroup.getDatasource();
        if (datasource == null) {
            return null;
        }
        Dataset dataset = datasource.getDatasets().get(string);
        return dataset;
    }

    public void setFeatureToPointDataset(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (dataset == null) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        String string = dataset.getName();
        S57DatasetGroupExtInfoNative.jni_setFunctionalDatasetName(this.getHandle(), S57DatasetType.S57FVP.value(), string);
    }

    public Dataset getFeatureToEdgeDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        String string = S57DatasetGroupExtInfoNative.jni_getFunctionalDatasetName(this.getHandle(), S57DatasetType.S57FVE.value());
        Datasource datasource = this.m_datasetGroup.getDatasource();
        if (datasource == null) {
            return null;
        }
        Dataset dataset = datasource.getDatasets().get(string);
        return dataset;
    }

    public void setFeatureToEdgeDataset(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (dataset == null) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        String string = dataset.getName();
        S57DatasetGroupExtInfoNative.jni_setFunctionalDatasetName(this.getHandle(), S57DatasetType.S57FVE.value(), string);
    }

    public Dataset getFeatureRelationShipDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        String string = S57DatasetGroupExtInfoNative.jni_getFunctionalDatasetName(this.getHandle(), S57DatasetType.S57RS.value());
        Datasource datasource = this.m_datasetGroup.getDatasource();
        if (datasource == null) {
            return null;
        }
        Dataset dataset = datasource.getDatasets().get(string);
        return dataset;
    }

    public void setFeatureRelationShipDataset(Dataset dataset) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (dataset == null) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        String string = dataset.getName();
        S57DatasetGroupExtInfoNative.jni_setFunctionalDatasetName(this.getHandle(), S57DatasetType.S57RS.value(), string);
    }

    public HashMap<Integer, Dataset[]> getFeatureDatasets() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        Datasource datasource = this.m_datasetGroup.getDatasource();
        if (datasource == null) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        int n = S57DatasetGroupExtInfoNative.jni_getFeatureDatasetCount(this.getHandle());
        int[] nArray = new int[n];
        String[][] stringArray = S57DatasetGroupExtInfoNative.jni_getFeatureDatasetNames(this.getHandle(), nArray);
        if (stringArray.length != n) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        HashMap<Integer, Dataset[]> hashMap = new HashMap<Integer, Dataset[]>();
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            String[] stringArray2 = stringArray[i];
            Dataset[] datasetArray = new Dataset[stringArray2.length];
            for (int j = 0; j < stringArray2.length; ++j) {
                Dataset dataset;
                String string = stringArray2[j];
                datasetArray[j] = dataset = datasource.getDatasets().get(string);
            }
            hashMap.put(new Integer(n2), datasetArray);
        }
        return hashMap;
    }

    public void setFeatureDatasets(HashMap<Integer, Dataset[]> value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        Object[] objectArray = value.keySet().toArray();
        int n = objectArray.length;
        int[] nArray = new int[n];
        String[][] stringArray = new String[n][];
        for (int i = 0; i < n; ++i) {
            Integer n2 = (Integer)objectArray[i];
            nArray[i] = n2;
            Dataset[] datasetArray = value.get(n2);
            String[] stringArray2 = new String[datasetArray.length];
            for (int j = 0; j < datasetArray.length; ++j) {
                if (datasetArray[j] == null) {
                    String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
                    throw new IllegalArgumentException(string);
                }
                stringArray2[j] = datasetArray[j].getName();
            }
            stringArray[i] = stringArray2;
        }
        S57DatasetGroupExtInfoNative.jni_setFeatureDatasetNames(this.getHandle(), nArray, stringArray);
    }

    public Dataset getFeatureDataset(int code, DatasetType eDatasetType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = eDatasetType.value();
        String string = S57DatasetGroupExtInfoNative.jni_getFeatureDatasetName(this.getHandle(), code, n);
        Datasource datasource = this.m_datasetGroup.getDatasource();
        if (datasource == null) {
            String string2 = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string2);
        }
        return datasource.getDatasets().get(string);
    }

    public boolean setFeatureDataset(Dataset value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return S57DatasetGroupExtInfoNative.jni_setFeatureDatasetName(this.getHandle(), value.getName());
    }

    public void deleteFeature(int code, DatasetType eType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (eType == null) {
            String string = InternalResource.loadString("S57DatasetGroupExtInfo", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        S57DatasetGroupExtInfoNative.jni_deleteFeature(this.getHandle(), code, eType.value());
    }
}

