/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.serializer;

import com.supermap.data.Enum;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldType;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Rectangle2D;
import com.supermap.jsuperpy.JFeature;
import com.supermap.jsuperpy.protos.FeatureMessages;
import com.supermap.jsuperpy.protos.RectMessages;
import com.supermap.jsuperpy.serializer.DataSerializer;
import com.supermap.jsuperpy.serializer.DataSerializers;
import com.supermap.jsuperpy.serializer.impl.BooleanSerializer;
import com.supermap.jsuperpy.serializer.impl.ByteArraySerializer;
import com.supermap.jsuperpy.serializer.impl.ByteSerializer;
import com.supermap.jsuperpy.serializer.impl.DateSerializer;
import com.supermap.jsuperpy.serializer.impl.DoubleSerializer;
import com.supermap.jsuperpy.serializer.impl.FloatSerializer;
import com.supermap.jsuperpy.serializer.impl.IntegerSerializer;
import com.supermap.jsuperpy.serializer.impl.LongSerializer;
import com.supermap.jsuperpy.serializer.impl.ShortSerializer;
import com.supermap.jsuperpy.serializer.impl.StringSerializer;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import supermap.shaded.com.google.protobuf.ByteString;
import supermap.shaded.com.google.protobuf.InvalidProtocolBufferException;

public final class SerializerUtil {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private SerializerUtil() {
    }

    public static DataSerializer getFieldSerializer(FieldType fieldType) {
        if (fieldType == FieldType.BOOLEAN) {
            return new BooleanSerializer();
        }
        if (fieldType == FieldType.BYTE) {
            return new ByteSerializer();
        }
        if (fieldType == FieldType.INT16) {
            return new ShortSerializer();
        }
        if (fieldType == FieldType.INT32) {
            return new IntegerSerializer();
        }
        if (fieldType == FieldType.INT64) {
            return new LongSerializer();
        }
        if (fieldType == FieldType.SINGLE) {
            return new FloatSerializer();
        }
        if (fieldType == FieldType.DOUBLE) {
            return new DoubleSerializer();
        }
        if (fieldType == FieldType.DATETIME) {
            return new DateSerializer();
        }
        if (fieldType == FieldType.LONGBINARY) {
            return new ByteArraySerializer();
        }
        if (fieldType == FieldType.TEXT) {
            return new StringSerializer();
        }
        if (fieldType == FieldType.WTEXT) {
            return new StringSerializer();
        }
        if (fieldType == FieldType.CHAR) {
            return new StringSerializer();
        }
        if (fieldType == FieldType.JSONB) {
            return new StringSerializer();
        }
        return null;
    }

    public static Boolean decodeBoolean(byte[] bytes) {
        if (bytes.length == 0) {
            return null;
        }
        try {
            return Boolean.parseBoolean(new String(bytes, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static Byte decodeByte(byte[] bytes) {
        if (bytes.length == 0) {
            return null;
        }
        int value = SerializerUtil.decodeInt(bytes);
        return (byte)value;
    }

    public static String decodeChar(byte[] bytes) {
        if (bytes.length == 0) {
            return null;
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static Short decodeShort(byte[] bytes) {
        if (bytes.length == 0) {
            return null;
        }
        return ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN).getShort();
    }

    public static Integer decodeInt(byte[] bytes) {
        if (bytes.length == 0) {
            return null;
        }
        return ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN).getInt();
    }

    public static Long decodeLong(byte[] bytes) {
        if (bytes.length == 0) {
            return null;
        }
        return ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN).getLong();
    }

    public static Float decodeFloat(byte[] bytes) {
        if (bytes.length == 0) {
            return null;
        }
        return Float.valueOf(ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN).getFloat());
    }

    public static Double decodeDouble(byte[] bytes) {
        if (bytes.length == 0) {
            return null;
        }
        return ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN).getDouble();
    }

    public static String decodeString(byte[] bytes) {
        if (bytes.length == 0) {
            return "";
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static Date decodeDate(byte[] bytes) {
        if (bytes.length == 0) {
            return null;
        }
        try {
            return dateFormat.parse(SerializerUtil.decodeString(bytes));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Geometry decodeProtoGeometry(FeatureMessages.ProtoGeometry protoGeometry) {
        GeometryType geoType = (GeometryType)Enum.parse(GeometryType.class, (int)protoGeometry.getGeotype());
        GeoLine geo = null;
        if (geoType == GeometryType.GEOPOINT) {
            geo = new GeoPoint(protoGeometry.getPoints(0), protoGeometry.getPoints(1));
        } else if (geoType == GeometryType.GEOLINE) {
            geo = new GeoLine();
            List<Integer> parts = protoGeometry.getPartsList();
            int index = 0;
            for (Integer part : parts) {
                Point2Ds pnts = new Point2Ds();
                for (int i = 0; i < part; ++i) {
                    pnts.add(new Point2D(protoGeometry.getPoints(index), protoGeometry.getPoints(index + 1)));
                    index += 2;
                }
                geo.addPart(pnts);
            }
        } else if (geoType == GeometryType.GEOREGION) {
            geo = new GeoRegion();
            List<Integer> parts = protoGeometry.getPartsList();
            int index = 0;
            for (Integer part : parts) {
                Point2Ds pnts = new Point2Ds();
                Integer partCount = Math.abs(part);
                for (int i = 0; i < partCount; ++i) {
                    pnts.add(new Point2D(protoGeometry.getPoints(index), protoGeometry.getPoints(index + 1)));
                    index += 2;
                }
                ((GeoRegion)geo).addPart(pnts);
            }
        } else {
            throw new IllegalArgumentException("Unsupported geometry type " + geo.getType());
        }
        return geo;
    }

    public static FieldInfo decodeProtoFieldInfo(FeatureMessages.ProtoFieldInfo protoFieldInfo) {
        FieldInfo fieldInfo = new FieldInfo();
        fieldInfo.setType((FieldType)Enum.parse(FieldType.class, (int)protoFieldInfo.getFieldType()));
        fieldInfo.setName(protoFieldInfo.getName());
        String caption = protoFieldInfo.getCaption();
        if (caption != null) {
            fieldInfo.setCaption(caption);
        } else {
            fieldInfo.setCaption(protoFieldInfo.getName());
        }
        String defaultValue = protoFieldInfo.getDefaultValue();
        if (defaultValue != null && !defaultValue.isEmpty()) {
            fieldInfo.setDefaultValue(defaultValue);
        }
        fieldInfo.setMaxLength(protoFieldInfo.getMaxLength());
        fieldInfo.setRequired(protoFieldInfo.getIsRequired());
        fieldInfo.setZeroLengthAllowed(protoFieldInfo.getIsZeroLengthAllowed());
        return fieldInfo;
    }

    public static byte[] encodeByte(Byte value) {
        return ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(value.intValue()).array();
    }

    public static byte[] encodeInt(int value) {
        return ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(value).array();
    }

    public static byte[] encodeDouble(double value) {
        return ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putDouble(value).array();
    }

    public static byte[] encodeFloat(float value) {
        return ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putFloat(value).array();
    }

    public static byte[] encodeLong(long value) {
        return ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(value).array();
    }

    public static byte[] encodeBoolean(boolean value) {
        return SerializerUtil.encodeString(new Boolean(value).toString());
    }

    public static byte[] encodeShort(short value) {
        return ByteBuffer.allocate(2).order(ByteOrder.BIG_ENDIAN).putShort(value).array();
    }

    public static byte[] encodeString(String value) {
        try {
            return value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    public static byte[] encodeDate(Date value) {
        return dateFormat.format(value).getBytes();
    }

    public static byte[] encodeChar(char value) {
        return new String(new char[]{value}).getBytes();
    }

    public static FeatureMessages.ProtoFieldInfo encodeProtoFieldInfo(FieldInfo field) {
        return FeatureMessages.ProtoFieldInfo.newBuilder().setFieldType(field.getType().value()).setName(field.getName()).setCaption(field.getCaption()).setDefaultValue(field.getDefaultValue()).setIsRequired(field.isRequired()).setIsZeroLengthAllowed(field.isZeroLengthAllowed()).setMaxLength(field.getMaxLength()).build();
    }

    public static FeatureMessages.ProtoGeometry encodeProtoGeometry(Geometry geo) {
        FeatureMessages.ProtoGeometry.Builder builder = FeatureMessages.ProtoGeometry.newBuilder().setGeotype(geo.getType().value());
        ArrayList<Integer> parts = new ArrayList<Integer>(8);
        ArrayList<Double> points = new ArrayList<Double>(256);
        if (geo.getType() == GeometryType.GEOPOINT) {
            GeoPoint geoPnt = (GeoPoint)geo;
            parts.add(1);
            points.add(geoPnt.getX());
            points.add(geoPnt.getY());
        } else if (geo.getType() == GeometryType.GEOLINE) {
            GeoLine geoLine = (GeoLine)geo;
            for (int i = 0; i < geoLine.getPartCount(); ++i) {
                Point2Ds part = geoLine.getPart(i);
                parts.add(part.getCount());
                for (int j = 0; j < part.getCount(); ++j) {
                    points.add(part.getItem(j).getX());
                    points.add(part.getItem(j).getY());
                }
            }
        } else if (geo.getType() == GeometryType.GEOREGION) {
            GeoRegion geoRegion = (GeoRegion)geo;
            for (int i = 0; i < geoRegion.getPartCount(); ++i) {
                Point2Ds part = geoRegion.getPart(i);
                parts.add(part.getCount());
                for (int j = 0; j < part.getCount(); ++j) {
                    points.add(part.getItem(j).getX());
                    points.add(part.getItem(j).getY());
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported geometry type " + geo.getType());
        }
        return builder.addAllParts(parts).addAllPoints(points).build();
    }

    public static byte[] serializeGeometry(Geometry geo) {
        return SerializerUtil.encodeProtoGeometry(geo).toByteArray();
    }

    public static Geometry deserializeGeometry(byte[] bytes) throws InvalidProtocolBufferException {
        return SerializerUtil.decodeProtoGeometry(FeatureMessages.ProtoGeometry.parseFrom(bytes));
    }

    public static byte[] serializeGeometryGT(Geometry geo) {
        return SerializerUtil.encodeProtoGeometryGT(geo).toByteArray();
    }

    public static FeatureMessages.ProtoGeometry encodeProtoGeometryGT(Geometry geo) {
        FeatureMessages.ProtoGeometry.Builder builder = FeatureMessages.ProtoGeometry.newBuilder().setGeotype(geo.getType().value());
        ArrayList<Integer> parts = new ArrayList<Integer>(8);
        ArrayList<Double> points = new ArrayList<Double>(256);
        if (geo.getType() == GeometryType.GEOPOINT) {
            GeoPoint geoPnt = (GeoPoint)geo;
            parts.add(1);
            points.add(geoPnt.getX());
            points.add(geoPnt.getY());
        } else if (geo.getType() == GeometryType.GEOLINE) {
            GeoLine geoLine = (GeoLine)geo;
            for (int i = 0; i < geoLine.getPartCount(); ++i) {
                Point2Ds part = geoLine.getPart(i);
                parts.add(part.getCount());
                for (int j = 0; j < part.getCount(); ++j) {
                    points.add(part.getItem(j).getX());
                    points.add(part.getItem(j).getY());
                }
            }
        } else if (geo.getType() == GeometryType.GEOREGION) {
            GeoRegion[] geoSubs;
            GeoRegion geoRegion = (GeoRegion)geo;
            for (GeoRegion geoSub : geoSubs = SerializerUtil.protectedDecomposeRegion(geoRegion)) {
                for (int i = 0; i < geoSub.getPartCount(); ++i) {
                    Point2Ds part = geoSub.getPart(i);
                    if (i == 0) {
                        parts.add(-part.getCount());
                    } else {
                        parts.add(part.getCount());
                    }
                    for (int j = 0; j < part.getCount(); ++j) {
                        points.add(part.getItem(j).getX());
                        points.add(part.getItem(j).getY());
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported geometry type " + geo.getType());
        }
        return builder.addAllParts(parts).addAllPoints(points).build();
    }

    private static GeoRegion[] protectedDecomposeRegion(GeoRegion geoRegion) {
        if (geoRegion.getPartCount() == 1) {
            return new GeoRegion[]{geoRegion};
        }
        return geoRegion.protectedDecompose();
    }

    public static RectMessages.ProtoRect encodeProtoRect(Rectangle2D rect) {
        return RectMessages.ProtoRect.newBuilder().setMinx(rect.getLeft()).setMaxx(rect.getRight()).setMiny(rect.getBottom()).setMaxy(rect.getTop()).build();
    }

    public static Rectangle2D decodeProtoRect(RectMessages.ProtoRect protoRect) {
        return new Rectangle2D(protoRect.getMinx(), protoRect.getMiny(), protoRect.getMaxx(), protoRect.getMaxy());
    }

    public static FeatureMessages.ProtoFeature encodeProtoFeature(JFeature feature) {
        FeatureMessages.ProtoFeature.Builder builder = FeatureMessages.ProtoFeature.newBuilder();
        FieldInfo[] fields = feature.getFieldInfos();
        Object[] values = feature.getValues();
        if (fields != null && values != null && fields.length == values.length) {
            for (int i = 0; i < fields.length; ++i) {
                builder.setFieldInfos(i, SerializerUtil.encodeProtoFieldInfo(fields[i]));
                if (values[i] == null) continue;
                builder.setValues(i, ByteString.copyFrom(DataSerializers.encode(values[i])));
            }
        }
        if (feature.getGeometry() != null) {
            builder.setGeometry(SerializerUtil.encodeProtoGeometry(feature.getGeometry()));
        }
        builder.setFid(feature.getID());
        return builder.build();
    }

    public static JFeature decodeProtoFeature(FeatureMessages.ProtoFeature protoFeature) {
        FeatureMessages.ProtoGeometry protoGeometry = protoFeature.getGeometry();
        Geometry geo = null;
        if (protoGeometry != null) {
            geo = SerializerUtil.decodeProtoGeometry(protoGeometry);
        }
        List<FeatureMessages.ProtoFieldInfo> protoFields = protoFeature.getFieldInfosList();
        FieldInfo[] fieldInfos = new FieldInfo[protoFields.size()];
        for (int i = 0; i < protoFields.size(); ++i) {
            fieldInfos[i] = SerializerUtil.decodeProtoFieldInfo(protoFields.get(i));
        }
        List<ByteString> protoValues = protoFeature.getValuesList();
        Object[] values = new Object[protoFields.size()];
        if (protoValues.size() == fieldInfos.length) {
            for (int i = 0; i < fieldInfos.length; ++i) {
                DataSerializer serializer;
                ByteString protoValue = protoValues.get(i);
                if (protoValue == null || (serializer = SerializerUtil.getFieldSerializer(fieldInfos[i].getType())) == null) continue;
                values[i] = serializer.decode(protoValue.toByteArray());
            }
        }
        return new JFeature(geo, values, fieldInfos, protoFeature.getFid());
    }
}

