/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.serializer.impl;

import com.supermap.jsuperpy.serializer.DataSerializer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LongArraySerializer
extends DataSerializer {
    @Override
    public Class getValueClass() {
        return long[].class;
    }

    @Override
    public String getTypeName() {
        return "lL";
    }

    @Override
    public byte[] encode(Object value) {
        if (value instanceof long[]) {
            long[] values = (long[])value;
            int count = values.length;
            ByteBuffer byteBuffer = ByteBuffer.allocate(count * 8).order(ByteOrder.BIG_ENDIAN);
            for (int i = 0; i < count; ++i) {
                byteBuffer.putLong(values[i]);
            }
            return byteBuffer.array();
        }
        return new byte[0];
    }

    public long[] decode(byte[] bys) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bys);
        long[] values = new long[byteBuffer.limit() / 8];
        for (int i = 0; i < values.length; ++i) {
            values[i] = byteBuffer.getLong();
        }
        return values;
    }
}

