/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.serializer.impl;

import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.jsuperpy.serializer.DataSerializer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Point2DArraySerializer
extends DataSerializer {
    @Override
    public String getTypeName() {
        return "P2L";
    }

    @Override
    public Class getValueClass() {
        return Point2D[].class;
    }

    @Override
    public byte[] encode(Object value) {
        if (value instanceof Point2D[]) {
            Point2D[] p = (Point2D[])value;
            ByteBuffer byteBuffer = ByteBuffer.allocate(p.length * 16).order(ByteOrder.BIG_ENDIAN);
            for (int i = 0; i < p.length; ++i) {
                Point2D pnt = p[i];
                byteBuffer.putDouble(pnt.x);
                byteBuffer.putDouble(pnt.y);
            }
            return byteBuffer.array();
        }
        if (value instanceof Point2Ds) {
            Point2Ds p = (Point2Ds)value;
            ByteBuffer byteBuffer = ByteBuffer.allocate(p.getCount() * 16).order(ByteOrder.BIG_ENDIAN);
            for (int i = 0; i < p.getCount(); ++i) {
                Point2D pnt = p.getItem(i);
                byteBuffer.putDouble(pnt.x);
                byteBuffer.putDouble(pnt.y);
            }
            return byteBuffer.array();
        }
        return new byte[0];
    }

    public Point2D[] decode(byte[] bys) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bys);
        Point2D[] values = new Point2D[byteBuffer.limit() / 16];
        for (int i = 0; i < values.length; ++i) {
            double x = byteBuffer.getDouble();
            double y = byteBuffer.getDouble();
            values[i] = new Point2D(x, y);
        }
        return values;
    }
}

