/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.ClippingType;
import com.supermap.data.ConstraintType;
import com.supermap.data.CoordSysTransMethod;
import com.supermap.data.CoordSysTransParameter;
import com.supermap.data.CoordSysTranslator;
import com.supermap.data.CursorType;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point3D;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.Recordset;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.processing.CacheBuilderOSGBToolNative;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.ObliqueProcessType;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.TextureCompressType;
import com.supermap.data.processing.VertexOptimizationType;
import com.supermap.realspace.CacheFileType;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

public class ObliquePhotogrammetryBuilder
extends InternalHandleDisposable {
    protected boolean m_isModifyCenter = false;
    private static transient Vector m_steppedListeners;
    private static String m_senderMethodName;
    protected Point3D m_centerP = new Point3D(0.0, 0.0, 0.0);
    protected boolean m_isCompressTexture = false;
    protected StorageType m_StorageType = StorageType.Original;
    protected VertexOptimizationType m_GeoTextureCompress = VertexOptimizationType.VO_NONE;
    protected TextureCompressType m_compressType = TextureCompressType.TEXTURECOMPRESS_NONE;
    protected boolean m_isCombineNode = false;
    protected int m_nLevel = -1;
    protected boolean m_textureRemapping = false;
    protected boolean m_isClipping = false;
    protected ClippingType m_clippingType = ClippingType.KEEPINSIDE;
    protected ConstraintType m_constraintType = ConstraintType.SOFTCONSTRAINT;
    protected ArrayList<Geometry> m_clipRegionList = new ArrayList();
    protected DatasetVector m_clipDataset = null;
    protected CacheFileType m_fileType = CacheFileType.S3MB;
    protected PrjCoordSys targetPrjCoordSys = null;
    protected boolean m_isDiscret = false;
    protected String m_strFieldName = "SmID";
    protected DatasetVector m_dsVector = null;

    public ObliquePhotogrammetryBuilder(ObliqueProcessType[] processTypes) {
        block7: for (ObliqueProcessType obliqueProcessType : processTypes) {
            switch (obliqueProcessType.value()) {
                case 0: {
                    this.m_isCombineNode = true;
                    continue block7;
                }
                case 1: {
                    this.m_isCompressTexture = true;
                    continue block7;
                }
                case 2: {
                    this.m_isDiscret = true;
                    continue block7;
                }
                case 3: {
                    this.m_isModifyCenter = true;
                    continue block7;
                }
                case 4: {
                    this.m_isClipping = true;
                }
            }
        }
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    static void steppedCallBack(ObliquePhotogrammetryBuilder source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            m_senderMethodName = "build";
            boolean bl = InternalToolkitProcessing.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent((Object)source, percent, remainTime, title, message, m_senderMethodName, bl);
            ObliquePhotogrammetryBuilder.fireStepped(steppedEvent);
            InternalToolkitProcessing.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    public Point3D getPointCenter() {
        return this.m_centerP;
    }

    public void setPointCenter(Point3D centerP) {
        this.m_centerP = centerP;
    }

    public TextureCompressType getTexCompressType() {
        return this.m_compressType;
    }

    public void setTexCompressType(TextureCompressType type) {
        this.m_compressType = type;
    }

    public int getCombineLevel() {
        return this.m_nLevel;
    }

    public void setCombineLevel(int nLevel) {
        this.m_nLevel = nLevel;
    }

    public DatasetVector getRegionDataset() {
        return this.m_dsVector;
    }

    public void setRegionDataset(DatasetVector dsVector) {
        this.m_dsVector = dsVector;
    }

    public String getFieldName() {
        return this.m_strFieldName;
    }

    public void setFieldName(String strFieldName) {
        this.m_strFieldName = strFieldName;
    }

    public PrjCoordSys getTargetPrjCoordSys() {
        return this.targetPrjCoordSys;
    }

    public void setTargetPrjCoordSys(PrjCoordSys prj) {
        this.targetPrjCoordSys = prj;
    }

    public CacheFileType getFileType() {
        return this.m_fileType;
    }

    public void setFileType(CacheFileType fileType) {
        if (fileType == CacheFileType.OSGB) {
            throw new IllegalArgumentException("Unsupported file type");
        }
        this.m_fileType = fileType;
    }

    public StorageType getStorageType() {
        return this.m_StorageType;
    }

    public void setStorageType(StorageType m_StorageType) {
        this.m_StorageType = m_StorageType;
    }

    public VertexOptimizationType getVertexOptimazationType() {
        return this.m_GeoTextureCompress;
    }

    public void setVertexOptimazationType(VertexOptimizationType m_GeoTextureCompress) {
        this.m_GeoTextureCompress = m_GeoTextureCompress;
    }

    public ClippingType getClippingType() {
        return this.m_clippingType;
    }

    public void setClippingType(ClippingType clippingType) {
        this.m_clippingType = clippingType;
    }

    public ConstraintType getConstraintType() {
        return this.m_constraintType;
    }

    public void setConstraintType(ConstraintType constraintType) {
        this.m_constraintType = constraintType;
    }

    public ArrayList<Geometry> getClipRegionList() {
        return this.m_clipRegionList;
    }

    public void setClipRegionList(ArrayList<Geometry> clipRegionList) {
        this.m_clipRegionList = clipRegionList;
    }

    public void setTextureRemapping(boolean textureRemappingValue) {
        this.m_textureRemapping = textureRemappingValue;
    }

    public boolean getTextureRemapping() {
        return this.m_textureRemapping;
    }

    public DatasetVector getClipDataset() {
        return this.m_clipDataset;
    }

    public void setClipDataset(DatasetVector clipDataset) {
        DatasetType datasetType = clipDataset.getType();
        if (datasetType != DatasetType.REGION && datasetType != DatasetType.REGION3D) {
            throw new IllegalArgumentException("Clip Dataset Type should be Region or Region3D");
        }
        this.m_clipDataset = clipDataset;
        if (this.m_clipDataset != null) {
            PrjCoordSys prjCoordSys = this.m_clipDataset.getPrjCoordSys();
            Recordset recordset = this.m_clipDataset.getRecordset(false, CursorType.STATIC);
            if (prjCoordSys.getType() == PrjCoordSysType.PCS_NON_EARTH) {
                this.m_isClipping = false;
            } else {
                recordset.moveFirst();
                PrjCoordSys prjCoordSys2 = new PrjCoordSys();
                prjCoordSys2.setType(PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE);
                while (!recordset.isEOF()) {
                    Geometry geometry = recordset.getGeometry();
                    if (prjCoordSys.getType() != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE) {
                        CoordSysTranslator.convert((Geometry)geometry, (PrjCoordSys)prjCoordSys, (PrjCoordSys)prjCoordSys2, (CoordSysTransParameter)new CoordSysTransParameter(), (CoordSysTransMethod)CoordSysTransMethod.MTH_MOLODENSKY_ABRIDGED);
                    }
                    this.m_clipRegionList.add(geometry);
                    recordset.moveNext();
                }
            }
        }
    }

    protected boolean[] getProcessTypes() {
        boolean[] blArray = new boolean[]{this.m_isCombineNode, this.m_isCompressTexture, this.m_isDiscret, this.m_isModifyCenter, this.m_isClipping, this.m_textureRemapping};
        return blArray;
    }

    protected int[] getEnumTypes() {
        int n = 515;
        if (this.m_fileType == CacheFileType.OSGB) {
            n = 505;
        } else if (this.m_fileType == CacheFileType.S3M) {
            n = 511;
        }
        int[] nArray = new int[]{n, this.m_compressType.value(), this.m_clippingType.value(), this.m_constraintType.value()};
        return nArray;
    }

    protected long[] getClipRegionAndDiscretHandles() {
        Object object;
        if (this.m_clipDataset != null) {
            object = this.m_clipDataset.getPrjCoordSys();
            Recordset recordset = this.m_clipDataset.getRecordset(false, CursorType.STATIC);
            if (object.getType() == PrjCoordSysType.PCS_NON_EARTH) {
                this.m_isClipping = false;
            } else {
                recordset.moveFirst();
                PrjCoordSys prjCoordSys = new PrjCoordSys();
                prjCoordSys.setType(PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE);
                while (!recordset.isEOF()) {
                    Geometry geometry = recordset.getGeometry();
                    if (object.getType() != PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE) {
                        CoordSysTranslator.convert((Geometry)geometry, (PrjCoordSys)object, (PrjCoordSys)prjCoordSys, (CoordSysTransParameter)new CoordSysTransParameter(), (CoordSysTransMethod)CoordSysTransMethod.MTH_MOLODENSKY_ABRIDGED);
                    }
                    this.m_clipRegionList.add(geometry);
                    recordset.moveNext();
                }
            }
        }
        object = new long[this.m_clipRegionList.size() + 1];
        object[0] = (PrjCoordSys)0L;
        if (this.m_dsVector != null) {
            object[0] = (PrjCoordSys)InternalHandle.getHandle((InternalHandle)this.m_dsVector);
        }
        for (int i = 0; i < this.m_clipRegionList.size(); ++i) {
            object[i + 1] = (PrjCoordSys)InternalHandle.getHandle((InternalHandle)((InternalHandle)this.m_clipRegionList.get(i)));
        }
        return object;
    }

    protected void checkParams() {
        if (this.m_isDiscret && this.m_dsVector == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "processing_resources");
            throw new NullPointerException(string);
        }
        if (this.m_isCombineNode && this.m_nLevel == -1) {
            throw new NullPointerException("Combine Level should bigger than 0");
        }
    }

    public boolean build(String scpPath, String outputFolder, int threadCount) {
        if (!new File(scpPath).exists()) {
            throw new NullPointerException("Input config file non-exist");
        }
        long l = 0L;
        if (this.m_dsVector != null) {
            l = InternalHandle.getHandle((InternalHandle)this.m_dsVector);
        }
        long l2 = 0L;
        if (this.targetPrjCoordSys != null) {
            l2 = InternalHandle.getHandle((InternalHandle)this.targetPrjCoordSys);
        }
        long[] lArray = null;
        if (this.m_clipRegionList != null) {
            lArray = new long[this.m_clipRegionList.size()];
            for (int i = 0; i < this.m_clipRegionList.size(); ++i) {
                long l3;
                lArray[i] = l3 = InternalHandle.getHandle((InternalHandle)((InternalHandle)this.m_clipRegionList.get(i)));
            }
        }
        boolean[] blArray = new boolean[]{this.m_isCombineNode, this.m_isCompressTexture, this.m_isDiscret, this.m_isModifyCenter, this.m_isClipping, this.m_textureRemapping};
        if (this.m_isDiscret && this.m_dsVector == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "processing_resources");
            throw new NullPointerException(string);
        }
        if (this.m_isCombineNode && this.m_nLevel == -1) {
            throw new NullPointerException("Combine Level should bigger than 0");
        }
        int[] nArray = new int[]{this.m_nLevel, 0, 0};
        double[] dArray = new double[]{this.m_centerP.getX(), this.m_centerP.getY(), this.m_centerP.getZ()};
        int n = 505;
        if (this.m_fileType == CacheFileType.S3MB) {
            n = 515;
        } else if (this.m_fileType == CacheFileType.S3M) {
            n = 511;
        }
        return CacheBuilderOSGBToolNative.jni_ProcessOSGB(scpPath, outputFolder, blArray, nArray, this.m_compressType.value(), this.m_clippingType.value(), this.m_constraintType.value(), lArray, l, this.m_strFieldName, dArray, threadCount, n, l2, this.m_StorageType.value(), this.m_GeoTextureCompress.value());
    }

    public void dispose() {
        this.clearHandle();
    }
}

