/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.Rectangle2D;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.TINTileNative;

public class TINTile
extends InternalHandleDisposable {
    private long gridHandle = 0L;

    public TINTile(int row, int column, int level) {
        long l = TINTileNative.jni_New(row, column, level);
        this.setHandle(l, true);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            if (this.gridHandle != 0L) {
                TINTileNative.jni_Close(this.gridHandle);
            }
            TINTileNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    public boolean isValid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isValid()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = TINTileNative.jni_IsValid(this.getHandle());
        return bl;
    }

    public int getRow() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRow()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = TINTileNative.jni_GetRow(this.getHandle());
        return n;
    }

    public void setRow(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRow()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        TINTileNative.jni_SetRow(this.getHandle(), value);
    }

    public int getColumn() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCol()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = TINTileNative.jni_GetCol(this.getHandle());
        return n;
    }

    public void setColumn(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCol()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        TINTileNative.jni_SetCol(this.getHandle(), value);
    }

    public int getLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = TINTileNative.jni_GetLevel(this.getHandle());
        return n;
    }

    public void setLevel(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        TINTileNative.jni_SetLevel(this.getHandle(), value);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        TINTileNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setImageGrid(int rows, int columns, double xmin, double ymin, double xmax, double ymax, double[] grid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageGrid()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.gridHandle = TINTileNative.jni_SetImageGrid(this.getHandle(), rows, columns, xmin, ymin, xmax, ymax, grid);
    }

    public long getImageGrid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageGrid()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.gridHandle;
    }

    public boolean fromStream(byte[] stream) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("fromStream ()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return TINTileNative.jni_Load(this.getHandle(), stream);
    }

    public byte[] toStream() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toStream()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        byte[] byArray = TINTileNative.jni_Save(this.getHandle());
        return byArray;
    }
}

