/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.DatasetGrid;
import com.supermap.data.EncodeType;
import com.supermap.data.GeoRegion;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.processing.CacheBuilderSCTNative;
import com.supermap.data.processing.CompressType;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalGeoRegion;
import com.supermap.data.processing.InternalGeometry;
import com.supermap.data.processing.InternalHandle;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.Tile;
import com.supermap.data.processing.Tiles;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class TerrainCacheBuilder
extends com.supermap.data.processing.InternalHandleDisposable {
    private DatasetGrid m_datasetGird;
    private GeoRegion m_geoRegion;
    private long m_selfEventHandle;
    transient Vector m_steppedListeners;
    private String m_password;
    private static String m_senderMethodName;

    public TerrainCacheBuilder() {
        long l = CacheBuilderSCTNative.jni_New();
        this.setHandle(l, true);
        this.m_selfEventHandle = CacheBuilderSCTNative.jni_NewSelfEventHandle(this);
    }

    public TerrainCacheBuilder(DatasetGrid dataset, String outputFolder) {
        this();
        this.setDataset(dataset);
        this.setOutputFolder(outputFolder);
    }

    public TerrainCacheBuilder(DatasetGrid dataset, String outputFolder, String name) {
        this();
        this.setDataset(dataset);
        this.setOutputFolder(outputFolder);
        this.setCacheName(name);
    }

    public DatasetGrid getDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDataset()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_datasetGird;
    }

    public void setDataset(DatasetGrid datasetGrid) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDataset(DatasetGrid datasetGrid)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (datasetGrid == null) {
            String string = InternalResource.loadString("datasetGrid", "Global_ArgumentNull", "processing_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        if (l == 0L) {
            String string = InternalResource.loadString("datasetGrid", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_datasetGird = datasetGrid;
        CacheBuilderSCTNative.jni_SetDataset(this.getHandle(), l);
    }

    public StorageType getStorageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = CacheBuilderSCTNative.jni_GetStorageType(this.getHandle());
        return (StorageType)InternalEnum.parseUGCValue(StorageType.class, n);
    }

    public void setStorageType(StorageType storageType) {
        if (storageType == null) {
            String string = InternalResource.loadString("storageType", "CacheBuilderS_StorageTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCTNative.jni_SetStorageType(this.getHandle(), storageType.value());
    }

    @Deprecated
    public CompressType getCompressType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCompressType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = CacheBuilderSCTNative.jni_GetCompressType(this.getHandle());
        return (CompressType)InternalEnum.parseUGCValue(CompressType.class, n);
    }

    @Deprecated
    public void setCompressType(CompressType compressType) {
        if (compressType == null) {
            String string = InternalResource.loadString("compressType", "CacheBuilder_CompressTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCompressType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCTNative.jni_SetCompressType(this.getHandle(), compressType.value());
    }

    @Deprecated
    public EncodeType getEncodeType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEncodeType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = CacheBuilderSCTNative.jni_GetEncodeType(this.getHandle());
        return (EncodeType)InternalEnum.parseUGCValue(EncodeType.class, n);
    }

    @Deprecated
    public void setEncodeType(EncodeType encodeType) {
        if (encodeType == null) {
            String string = InternalResource.loadString("encodeType", "CacheBuilder_CompressTypeShouldNotBeNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEncodeTypeType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCTNative.jni_SetEncodeType(this.getHandle(), encodeType.value());
    }

    public String getOutputFolder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_GetOutputFolder(this.getHandle());
    }

    public void setOutputFolder(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputFolder(String value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCTNative.jni_SetOutputFolder(this.getHandle(), value);
    }

    public String getCacheName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_GetCacheName(this.getHandle());
    }

    public void setCacheName(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.trim().length() == 0) {
            String string = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        CacheBuilderSCTNative.jni_SetCacheName(this.getHandle(), value);
    }

    public GeoRegion getClipRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getClipRegion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_geoRegion == null) {
            long l = CacheBuilderSCTNative.jni_GetClipRegion(this.getHandle());
            if (l != 0L) {
                this.m_geoRegion = (GeoRegion)InternalGeometry.createInstance(l);
                com.supermap.data.processing.InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)this.m_geoRegion, false);
                if (this.m_geoRegion.isEmpty()) {
                    this.m_geoRegion = null;
                }
            }
        } else {
            long l = CacheBuilderSCTNative.jni_GetClipRegion(this.getHandle());
            InternalGeoRegion.clearHandle(this.m_geoRegion);
            InternalGeoRegion.refreshHandle(this.m_geoRegion, l);
        }
        return this.m_geoRegion;
    }

    public void setClipRegion(GeoRegion geoRegion) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setClipRegion(GeoRegion geoRegion)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (geoRegion == null) {
            CacheBuilderSCTNative.jni_SetClipRegion(this.getHandle(), 0L);
            this.m_geoRegion = null;
        } else {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion);
            if (l == 0L) {
                String string = InternalResource.loadString("geoRegion", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
                throw new IllegalArgumentException(string);
            }
            CacheBuilderSCTNative.jni_SetClipRegion(this.getHandle(), l);
        }
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion);
    }

    @Deprecated
    public int getBeginLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBeginLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_GetBeginLevel(this.getHandle());
    }

    @Deprecated
    public void setBeginLevel(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBeginLevel(int value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "CacheBuilderSCT_BeginLevelShouldNotBeNegative", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        CacheBuilderSCTNative.jni_SetBeginLevel(this.getHandle(), value);
    }

    @Deprecated
    public int getEndLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEndLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_GetEndLevel(this.getHandle());
    }

    @Deprecated
    public void setEndLevel(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEndLevel(int value)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "CacheBuilderSCT_EndLevelShouldNotBeNegative", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        CacheBuilderSCTNative.jni_SetEndLevel(this.getHandle(), value);
    }

    @Deprecated
    public int getDefaultBeginLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefaultBeginLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_GetDefaultBeginLevel(this.getHandle());
    }

    @Deprecated
    public int getDefaultEndLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefaultEndLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_GetDefaultEndLevel(this.getHandle());
    }

    public int getSampleSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSampleSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_GetSampleSize(this.getHandle());
    }

    public void setSampleSize(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("dispose()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "CacheBuilderSCT_SampleSizeShouldNotBeNegative", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        CacheBuilderSCTNative.jni_SetSampleSize(this.getHandle(), value);
    }

    public PrjCoordSysType getDynamicPrjCoordSysType() {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDynamicProjection()", "Handle_ObjectHasBeenDisposed", "processing_resources");
        }
        PrjCoordSysType prjCoordSysType = (n = CacheBuilderSCTNative.jni_GetDynamicPrjCoordSysType(this.getHandle())) == 1 ? PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE : PrjCoordSysType.PCS_NON_EARTH;
        return prjCoordSysType;
    }

    public void setDynamicPrjCoordSysType(PrjCoordSysType prjType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDynamicProjection(boolean dynamicProjection)", "Handle_ObjectHasBeenDisposed", "processing_resources");
        }
        int n = prjType == PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE ? 1 : 0;
        CacheBuilderSCTNative.jni_SetDynamicPrjCoordSysType(this.getHandle(), n);
    }

    public String getPassword() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPassword()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this.m_password;
    }

    public void setPassword(String password) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPassword()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this.m_password = password;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            CacheBuilderSCTNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasetGird == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_datasetGird) == 0L) {
            String string = InternalResource.loadString("build()", "CacheBuilderSCT_DatasetGridIsNULLOrHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (!this.m_datasetGird.isOpen()) {
            this.m_datasetGird.open();
        }
        if (!this.m_datasetGird.getHasPyramid()) {
            String string = InternalResource.loadString("build()", "CacheBuilderSCT_BuildDatasetGridShouldHasPyramid", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getOutputFolder() == null || this.getOutputFolder().trim().length() == 0) {
            String string = InternalResource.loadString("ouputFolder", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.getEndLevel() - this.getBeginLevel();
        if (n < 0) {
            String string = InternalResource.loadString("build()", "CacheBuilderSCT_BuildEndLevelShouldNoLessThanBeginLevel", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_password == null || this.m_password.trim().length() == 0) {
            return CacheBuilderSCTNative.jni_Build(this.getHandle(), this.m_selfEventHandle);
        }
        return CacheBuilderSCTNative.jni_BuildWithPassword(this.getHandle(), this.m_selfEventHandle, this.m_password);
    }

    public boolean buildWithoutConfigFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasetGird == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_datasetGird) == 0L) {
            String string = InternalResource.loadString("build()", "CacheBuilderSCT_DatasetGridIsNULLOrHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (!this.m_datasetGird.isOpen()) {
            this.m_datasetGird.open();
        }
        if (!this.m_datasetGird.getHasPyramid()) {
            String string = InternalResource.loadString("build()", "CacheBuilderSCT_BuildDatasetGridShouldHasPyramid", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getOutputFolder() == null || this.getOutputFolder().trim().length() == 0) {
            String string = InternalResource.loadString("ouputFolder", "Global_StringIsNullOrEmpty", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.getEndLevel() - this.getBeginLevel();
        if (n < 0) {
            String string = InternalResource.loadString("build()", "CacheBuilderSCT_BuildEndLevelShouldNoLessThanBeginLevel", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = this.m_password == null || this.m_password.trim().length() == 0 ? CacheBuilderSCTNative.jni_BuildWithoutConfigFile(this.getHandle(), this.m_selfEventHandle) : CacheBuilderSCTNative.jni_BuildWithoutConfigFile(this.getHandle(), this.m_selfEventHandle, this.m_password);
        ((Object)((Object)this)).hashCode();
        return bl;
    }

    public boolean computeOutputScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = CacheBuilderSCTNative.jni_ComputeOutputScales(this.getHandle());
        return bl;
    }

    public double[] getDefaultOutputScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefultOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_GetDefaultOutputScales(this.getHandle());
    }

    public HashMap<Double, String> getOutputScaleCaptions() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputScaleCaptions()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = CacheBuilderSCTNative.jni_GetOutputScalesCount(this.getHandle());
        double[] dArray = new double[n];
        String[] stringArray = new String[n];
        HashMap<Double, String> hashMap = new HashMap<Double, String>();
        CacheBuilderSCTNative.jni_GetOutputScaleCaptions(this.getHandle(), dArray, stringArray);
        for (int i = 0; i < n; ++i) {
            hashMap.put(dArray[i], stringArray[i]);
        }
        return hashMap;
    }

    public void setOutputScaleCaptions(HashMap<Double, String> scaleCaptions) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputScaleCaptions()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (scaleCaptions == null) {
            String string = InternalResource.loadString("setOutputScaleCaptions()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = scaleCaptions.size();
        double[] dArray = new double[n];
        String[] stringArray = new String[n];
        Set<Map.Entry<Double, String>> set = scaleCaptions.entrySet();
        Iterator<Map.Entry<Double, String>> iterator = set.iterator();
        Map.Entry<Double, String> entry = null;
        for (int i = 0; i < n; ++i) {
            entry = iterator.next();
            dArray[i] = entry.getKey();
            stringArray[i] = entry.getValue();
        }
        CacheBuilderSCTNative.jni_SetOutputScaleCaptions(this.getHandle(), dArray, stringArray);
    }

    public double[] getOutputScales() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_GetOutputScales(this.getHandle());
    }

    public void setOutputScales(double[] values) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOutputScales()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (!CacheBuilderSCTNative.jni_SetOutputScales(this.getHandle(), values)) {
            String string = InternalResource.loadString("setOutputScales()", "CacheBuilder_IllegalScales", "processing_resources");
            throw new IllegalArgumentException(string);
        }
    }

    @Deprecated
    public boolean computeLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasetGird == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_datasetGird) == 0L) {
            String string = InternalResource.loadString("datasetGrid", "CacheBuilderSCT_DatasetGridIsNULLOrHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_ComputeLevel(this.getHandle());
    }

    @Deprecated
    public String[] computeTerrainFileName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ComputeImageFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasetGird == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_datasetGird) == 0L) {
            String string = InternalResource.loadString("datasetGrid", "CacheBuilderSCT_DatasetGridIsNULLOrHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = CacheBuilderSCTNative.jni_ComputeImageFileName(this.getHandle());
        return InternalToolkitProcessing.splitString(string, ";");
    }

    @Deprecated
    public String[] computeTerrainFileName(int specialLevel) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ComputeImageFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_datasetGird == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_datasetGird) == 0L) {
            String string = InternalResource.loadString("datasetGrid", "CacheBuilderSCT_DatasetGridIsNULLOrHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = CacheBuilderSCTNative.jni_ComputeImageFileName(this.getHandle(), specialLevel);
        return InternalToolkitProcessing.splitString(string, ";");
    }

    public boolean toConfigFile(String fileName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ToFile(String path)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_ToFile(this.getHandle(), fileName);
    }

    public boolean fromConfigFile(String fileName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("FromFile(String path)", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_FromFile(this.getHandle(), fileName);
    }

    public Tile[] getTiles(Rectangle2D tileBounds, double scale) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTiles()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Tiles tiles = null;
        long l = CacheBuilderSCTNative.jni_GetTiles(this.getHandle(), tileBounds.getLeft(), tileBounds.getTop(), tileBounds.getRight(), tileBounds.getBottom(), scale);
        tiles = new Tiles(l);
        Tile[] tileArray = new Tile[tiles.getCount()];
        for (int i = 0; i < tiles.getCount(); ++i) {
            tileArray[i] = tiles.get(i);
        }
        return tileArray;
    }

    public int getProcessThreadsCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getProcessThreadsCount()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_GetProcessThreadsCount(this.getHandle());
    }

    public void setProcessThreadsCount(int threadCount) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setProcessThreadsCount()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCTNative.jni_SetProcessThreadsCount(this.getHandle(), threadCount);
    }

    public int getBlockScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getFactorScale()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return CacheBuilderSCTNative.jni_GetBlockScale(this.getHandle());
    }

    public void setBlockScale(int blockScale) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBlockScale()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        CacheBuilderSCTNative.jni_SetBlockScale(this.getHandle(), blockScale);
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.remove(l);
        }
    }

    protected void fireStepped(SteppedEvent event) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(TerrainCacheBuilder source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            m_senderMethodName = "build";
            boolean bl = InternalToolkitProcessing.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent((Object)source, percent, remainTime, title, message, m_senderMethodName, bl);
            source.fireStepped(steppedEvent);
            InternalToolkitProcessing.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
    }

    protected void clearHandle() {
        this.m_datasetGird = null;
        this.clearSelfEventHandle();
        if (this.m_geoRegion != null) {
            InternalGeoRegion.clearHandle(this.m_geoRegion);
            this.m_geoRegion = null;
        }
        this.setHandle(0L);
    }

    private void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            CacheBuilderSCTNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }
}

