/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.plot;

import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import com.supermap.plot.AnimationDefine;
import com.supermap.plot.AnimationGO;
import com.supermap.plot.AnimationWayNative;
import java.awt.Color;

public class AnimationWay
extends AnimationGO {
    protected AnimationWay() {
    }

    AnimationWay(long handle) {
        this.setHandle(handle, false);
    }

    public void setPathType(AnimationDefine.PathType pathType) {
        AnimationWayNative.jni_SetPathType(this.getHandle(), pathType.value());
    }

    public AnimationDefine.PathType getPathType() {
        int n = AnimationWayNative.jni_GetPathType(this.getHandle());
        return new AnimationDefine.PathType(n, n);
    }

    public boolean addPathPt(Point3D vecPath) {
        return AnimationWayNative.jni_AddPathPt(this.getHandle(), vecPath.getX(), vecPath.getY(), vecPath.getZ());
    }

    public boolean addPathPts(Point3Ds pts3D) {
        int n = pts3D.getCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = pts3D.getItem(i).getX();
            dArray2[i] = pts3D.getItem(i).getY();
            dArray3[i] = pts3D.getItem(i).getZ();
        }
        return AnimationWayNative.jni_AddPathPts(this.getHandle(), dArray, dArray2, dArray3);
    }

    public boolean insertPathPt(int index, Point3D vecPath) {
        return AnimationWayNative.jni_InsertPathPt(this.getHandle(), index, vecPath.getX(), vecPath.getY(), vecPath.getZ());
    }

    public boolean setPathPt(int index, Point3D vecPath) {
        return AnimationWayNative.jni_SetPathPt(this.getHandle(), index, vecPath.getX(), vecPath.getY(), vecPath.getZ());
    }

    public boolean removePathPtAt(int index) {
        return AnimationWayNative.jni_RemovePathPtAt(this.getHandle(), index);
    }

    public int getPathPtCount() {
        return AnimationWayNative.jni_GetPathPtCount(this.getHandle());
    }

    public void removeAllPathPt() {
        AnimationWayNative.jni_RemoveAllPathPt(this.getHandle());
    }

    public void showPathTrack(boolean bShowPathTrack) {
        AnimationWayNative.jni_ShowPathTrack(this.getHandle(), bShowPathTrack);
    }

    public boolean isShowPathTrack() {
        return AnimationWayNative.jni_isShowPathTrack(this.getHandle());
    }

    public void setPathTrackDir(boolean bPathTrack) {
        AnimationWayNative.jni_SetPathTrackDir(this.getHandle(), bPathTrack);
    }

    public boolean getPathTrackDir() {
        return AnimationWayNative.jni_GetPathTrackDir(this.getHandle());
    }

    public void setTrackLineWidth(Double width) {
        AnimationWayNative.jni_SetTrackLineWidth(this.getHandle(), width);
    }

    public double getTrackLineWidth() {
        return AnimationWayNative.jni_GetTrackLineWidth(this.getHandle());
    }

    public void setTrackLineColor(Color nColor) {
        AnimationWayNative.jni_SetTrackLineColor(this.getHandle(), nColor.getRGB());
    }

    public Color getTrackLineColor() {
        int n = AnimationWayNative.jni_GetTrackLineColor(this.getHandle());
        return new Color(n);
    }

    public Point3Ds getAllPathPt() {
        int n = AnimationWayNative.jni_GetPathPtCount(this.getHandle());
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        AnimationWayNative.jni_GetAllPathPt(this.getHandle(), dArray, dArray2, dArray3);
        Point3Ds point3Ds = new Point3Ds();
        for (int i = 0; i < n; ++i) {
            point3Ds.add(new Point3D(dArray[i], dArray2[i], dArray3[i]));
        }
        return point3Ds;
    }
}

