/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.topology;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetTopology;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Recordset;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.TopologyDatasetRelationItem;
import com.supermap.data.TopologyRule;
import com.supermap.data.topology.InternalDatasetVector;
import com.supermap.data.topology.InternalDatasets;
import com.supermap.data.topology.InternalHandle;
import com.supermap.data.topology.InternalResource;
import com.supermap.data.topology.InternalToolkitTolopogy;
import com.supermap.data.topology.TopologyPreprocessOptions;
import com.supermap.data.topology.TopologyValidatorNative;
import com.supermap.data.topology.VertexSnapType;
import java.util.Vector;

public class TopologyValidator {
    private static transient Vector m_steppedListeners;

    private TopologyValidator() {
    }

    public static boolean preprocess(DatasetTopology datasetTopology) {
        if (datasetTopology == null) {
            String string = InternalResource.loadString("datasetTopology", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetTopology);
        if (l == 0L) {
            String string = InternalResource.loadString("datasetTopology", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        return TopologyValidatorNative.jni_preprocess(l);
    }

    public static boolean preprocess(TopologyDatasetRelationItem[] items, double tolerance) {
        int n;
        if (items == null) {
            String string = InternalResource.loadString("items", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = true;
        int n2 = items.length;
        long[] lArray = new long[n2];
        int[] nArray = new int[n2];
        for (n = 0; n < lArray.length; ++n) {
            lArray[n] = InternalHandle.getHandle((com.supermap.data.InternalHandle)items[n].getDataset());
            if (lArray[n] == 0L) {
                bl = false;
                break;
            }
            if (items[n].getDataset().getType() != DatasetType.POINT && items[n].getDataset().getType() != DatasetType.LINE && items[n].getDataset().getType() != DatasetType.REGION) {
                bl = false;
                break;
            }
            nArray[n] = items[n].getPrecisionOrder();
        }
        if (!bl) {
            String string = InternalResource.loadString("items", "TopologyValidator_TopologyDatasetRelationItemInvalid", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        n = 0;
        if (bl) {
            n = TopologyValidatorNative.jni_preprocess1(lArray, nArray, tolerance) ? 1 : 0;
        }
        return n != 0;
    }

    public static boolean preprocess(DatasetVector[] datasetVectors, int[] precisionOrders, double tolerance) {
        if (datasetVectors == null) {
            String string = InternalResource.loadString("datasetVectors", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (precisionOrders == null) {
            String string = InternalResource.loadString("precisionOrders", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVectors.length != precisionOrders.length) {
            String string = InternalResource.loadString("datasetVectors  &  precisionOrders", "TopologyValidator_TheNumberOfTheDatasetVectorsAndPrecisionOrdersIsNoEqual", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVectors.length > 0 && (datasetVectors[0].getType() == DatasetType.POINT3D || datasetVectors[0].getType() == DatasetType.LINE3D || datasetVectors[0].getType() == DatasetType.REGION3D)) {
            TopologyPreprocessOptions topologyPreprocessOptions = new TopologyPreprocessOptions();
            return TopologyValidator.preprocess(datasetVectors, precisionOrders, topologyPreprocessOptions, tolerance);
        }
        TopologyDatasetRelationItem[] topologyDatasetRelationItemArray = new TopologyDatasetRelationItem[datasetVectors.length];
        for (int i = 0; i < topologyDatasetRelationItemArray.length; ++i) {
            if (datasetVectors[i].getType() != DatasetType.POINT && datasetVectors[i].getType() != DatasetType.LINE && datasetVectors[i].getType() != DatasetType.REGION) {
                String string = InternalResource.loadString("datasetVectors", "Global_ArgumentTypeInvalid", "topology_resources");
                throw new IllegalArgumentException(string);
            }
            topologyDatasetRelationItemArray[i] = new TopologyDatasetRelationItem(datasetVectors[i], precisionOrders[i]);
        }
        return TopologyValidator.preprocess(topologyDatasetRelationItemArray, tolerance);
    }

    public static boolean preprocess(DatasetVector[] datasetVectors, int[] precisionOrders, TopologyPreprocessOptions options, double tolerance) {
        int n;
        if (datasetVectors == null) {
            String string = InternalResource.loadString("datasetVectors", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (precisionOrders == null) {
            String string = InternalResource.loadString("precisionOrders", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVectors.length != precisionOrders.length) {
            String string = InternalResource.loadString("datasetVectors  &  precisionOrders", "TopologyValidator_TheNumberOfTheDatasetVectorsAndPrecisionOrdersIsNoEqual", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (options == null) {
            String string = InternalResource.loadString("options", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = true;
        int n2 = datasetVectors.length;
        long[] lArray = new long[n2];
        for (n = 0; n < lArray.length; ++n) {
            if (datasetVectors[n].getType() != DatasetType.POINT && datasetVectors[n].getType() != DatasetType.LINE && datasetVectors[n].getType() != DatasetType.REGION && datasetVectors[n].getType() != DatasetType.POINT3D && datasetVectors[n].getType() != DatasetType.LINE3D && datasetVectors[n].getType() != DatasetType.REGION3D) {
                bl = false;
                break;
            }
            lArray[n] = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectors[n]);
            if (lArray[n] != 0L) continue;
            bl = false;
            break;
        }
        if (!bl) {
            String string = InternalResource.loadString("datasetVectors", "Global_ArgumentTypeInvalid", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        n = 0;
        if (bl) {
            n = TopologyValidatorNative.jni_preprocess2(lArray, precisionOrders, options.areArcsInserted(), options.areVertexArcInserted(), options.areVertexesSnapped(), options.arePolygonsChecked(), options.areVertexAdjusted(), tolerance) ? 1 : 0;
        }
        return n != 0;
    }

    public static boolean preprocess(Recordset[] recordsets, int[] precisionOrders, TopologyPreprocessOptions options, double tolerance) {
        int n;
        if (recordsets == null) {
            String string = InternalResource.loadString("recordsets", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (precisionOrders == null) {
            String string = InternalResource.loadString("precisionOrders", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (recordsets.length != precisionOrders.length) {
            String string = InternalResource.loadString("datasetVectors  &  precisionOrders", "TopologyValidator_TheNumberOfTheDatasetVectorsAndPrecisionOrdersIsNoEqual", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (options == null) {
            String string = InternalResource.loadString("options", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = true;
        int n2 = recordsets.length;
        long[] lArray = new long[n2];
        for (n = 0; n < lArray.length; ++n) {
            if (recordsets[n].getDataset().getType() != DatasetType.POINT && recordsets[n].getDataset().getType() != DatasetType.LINE && recordsets[n].getDataset().getType() != DatasetType.REGION && recordsets[n].getDataset().getType() != DatasetType.POINT3D && recordsets[n].getDataset().getType() != DatasetType.LINE3D && recordsets[n].getDataset().getType() != DatasetType.REGION3D) {
                bl = false;
                break;
            }
            lArray[n] = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordsets[n]);
            if (lArray[n] != 0L) continue;
            bl = false;
            break;
        }
        if (!bl) {
            String string = InternalResource.loadString("recordsets", "Global_ArgumentTypeInvalid", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        n = 0;
        if (bl) {
            n = TopologyValidatorNative.jni_preprocess3(lArray, precisionOrders, options.areArcsInserted(), options.areVertexArcInserted(), options.areVertexesSnapped(), options.arePolygonsChecked(), options.areVertexAdjusted(), tolerance) ? 1 : 0;
        }
        return n != 0;
    }

    public static boolean preprocess(DatasetVector datasetVector, Geometry geometryTarget, TopologyPreprocessOptions options, double tolerance, boolean bStd) {
        if (datasetVector == null) {
            String string = InternalResource.loadString("datasetVector", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryTarget == null) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (options == null) {
            String string = InternalResource.loadString("options", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometryTarget);
        boolean bl = TopologyValidatorNative.jni_preprocess4(l, l2, options.areArcsInserted(), options.areVertexArcInserted(), options.areVertexesSnapped(), options.arePolygonsChecked(), options.areVertexAdjusted(), tolerance, bStd);
        return bl;
    }

    public static boolean preprocess(Recordset recordset, Geometry geometryTarget, TopologyPreprocessOptions options, double tolerance, boolean bStd) {
        if (recordset == null) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryTarget == null) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (options == null) {
            String string = InternalResource.loadString("options", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)recordset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometryTarget);
        boolean bl = TopologyValidatorNative.jni_preprocess5(l, l2, options.areArcsInserted(), options.areVertexArcInserted(), options.areVertexesSnapped(), options.arePolygonsChecked(), options.areVertexAdjusted(), tolerance, bStd);
        return bl;
    }

    public static boolean preprocess(Geometry geometrySource, Geometry geometryTarget, TopologyPreprocessOptions options, double tolerance, boolean bStd) {
        if (geometrySource == null) {
            String string = InternalResource.loadString("recordset", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometryTarget == null) {
            String string = InternalResource.loadString("geometryTarget", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (options == null) {
            String string = InternalResource.loadString("options", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometrySource);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometryTarget);
        boolean bl = TopologyValidatorNative.jni_preprocess6(l, l2, options.areArcsInserted(), options.areVertexArcInserted(), options.areVertexesSnapped(), options.arePolygonsChecked(), options.areVertexAdjusted(), tolerance, bStd);
        return bl;
    }

    public static boolean preprocessAdjustVertex(DatasetVector[] datasetVectors, double tolerance) {
        int n;
        if (datasetVectors == null) {
            String string = InternalResource.loadString("datasetVectors", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = true;
        int n2 = datasetVectors.length;
        long[] lArray = new long[n2];
        for (n = 0; n < lArray.length; ++n) {
            if (datasetVectors[n].getType() != DatasetType.LINE && datasetVectors[n].getType() != DatasetType.REGION) {
                bl = false;
                break;
            }
            lArray[n] = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectors[n]);
            if (lArray[n] != 0L) continue;
            bl = false;
            break;
        }
        if (!bl) {
            String string = InternalResource.loadString("datasetVectors", "Global_ArgumentTypeInvalid", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        n = 0;
        if (bl) {
            n = TopologyValidatorNative.jni_preprocessAdjustVertex(lArray, tolerance) ? 1 : 0;
        }
        return n != 0;
    }

    public static boolean preprocessVertexSnap(DatasetVector[] datasetVectors, VertexSnapType type, double closeNodeTolerance, double tolerance) {
        int n;
        if (datasetVectors == null) {
            String string = InternalResource.loadString("datasetVectors", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = true;
        int n2 = datasetVectors.length;
        long[] lArray = new long[n2];
        for (n = 0; n < lArray.length; ++n) {
            if (datasetVectors[n].getType() != DatasetType.POINT && datasetVectors[n].getType() != DatasetType.LINE && datasetVectors[n].getType() != DatasetType.REGION) {
                bl = false;
                break;
            }
            lArray[n] = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVectors[n]);
            if (lArray[n] != 0L) continue;
            bl = false;
            break;
        }
        if (!bl) {
            String string = InternalResource.loadString("datasetVectors", "Global_ArgumentTypeInvalid", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        n = 0;
        if (bl) {
            n = TopologyValidatorNative.jni_preprocessVertexSnap(lArray, type.value(), closeNodeTolerance, tolerance) ? 1 : 0;
        }
        return n != 0;
    }

    public static boolean validate(DatasetTopology datasetTopology, GeoRegion validateRegion) {
        if (datasetTopology == null) {
            String string = InternalResource.loadString("datasetTopology", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetTopology);
        if (l == 0L) {
            String string = InternalResource.loadString("datasetTopology", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        if (validateRegion != null && (l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)validateRegion)) == 0L) {
            String string = InternalResource.loadString("validateRegion", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = TopologyValidatorNative.jni_validate(l, l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)validateRegion);
        return bl;
    }

    public static DatasetVector validate(DatasetVector sourceDataset, DatasetVector validatingDataset, TopologyRule rule, double tolerance, GeoRegion validateRegion, Datasource outputDatasource, String outputDatasetName) {
        if (sourceDataset == null) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        if (l == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset.getType() != DatasetType.POINT && sourceDataset.getType() != DatasetType.LINE && sourceDataset.getType() != DatasetType.REGION && sourceDataset.getType() != DatasetType.POINT3D && sourceDataset.getType() != DatasetType.LINE3D && sourceDataset.getType() != DatasetType.REGION3D) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentTypeInvalid", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        if (validatingDataset != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)validatingDataset);
            if (l2 == 0L) {
                String string = InternalResource.loadString("validatingDataset", "Handle_ObjectHasBeenDisposed", "topology_resources");
                throw new IllegalArgumentException(string);
            }
            if (sourceDataset.getType() == DatasetType.POINT3D || sourceDataset.getType() == DatasetType.LINE3D || sourceDataset.getType() == DatasetType.REGION3D) {
                if (validatingDataset.getType() != DatasetType.POINT3D && validatingDataset.getType() != DatasetType.LINE3D && validatingDataset.getType() != DatasetType.REGION3D) {
                    String string = InternalResource.loadString("validatingDataset", "Global_ArgumentTypeInvalid", "topology_resources");
                    throw new IllegalArgumentException(string);
                }
            } else if (validatingDataset.getType() != DatasetType.POINT && validatingDataset.getType() != DatasetType.LINE && validatingDataset.getType() != DatasetType.REGION) {
                String string = InternalResource.loadString("validatingDataset", "Global_ArgumentTypeInvalid", "topology_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if (rule == null) {
            String string = InternalResource.loadString("rule", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = 0L;
        if (validateRegion != null && (l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)validateRegion)) == 0L) {
            String string = InternalResource.loadString("validateRegion", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource == null) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (l4 == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l5 = TopologyValidatorNative.jni_validate1(l, l2, rule.value(), tolerance, l3, l4, outputDatasetName);
        DatasetVector datasetVector = null;
        if (l5 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l5, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)validateRegion);
        return datasetVector;
    }

    public static DatasetVector validate(Recordset sourceRecordset, Recordset validatingRecordset, TopologyRule rule, double tolerance, GeoRegion validateRegion, Datasource outputDatasource, String outputDatasetName) {
        if (sourceRecordset == null) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceRecordset);
        if (l == 0L) {
            String string = InternalResource.loadString("sourceRecordset", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceRecordset.getDataset().getType() != DatasetType.POINT && sourceRecordset.getDataset().getType() != DatasetType.LINE && sourceRecordset.getDataset().getType() != DatasetType.REGION && sourceRecordset.getDataset().getType() != DatasetType.POINT3D && sourceRecordset.getDataset().getType() != DatasetType.LINE3D && sourceRecordset.getDataset().getType() != DatasetType.REGION3D) {
            String string = InternalResource.loadString("sourceRecordset", "Global_ArgumentTypeInvalid", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        if (validatingRecordset != null) {
            l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)validatingRecordset);
            if (l2 == 0L) {
                String string = InternalResource.loadString("validatingRecordset", "Handle_ObjectHasBeenDisposed", "topology_resources");
                throw new IllegalArgumentException(string);
            }
            if (sourceRecordset.getDataset().getType() == DatasetType.POINT3D || sourceRecordset.getDataset().getType() == DatasetType.LINE3D || sourceRecordset.getDataset().getType() == DatasetType.REGION3D) {
                if (validatingRecordset.getDataset().getType() != DatasetType.POINT3D && validatingRecordset.getDataset().getType() != DatasetType.LINE3D && validatingRecordset.getDataset().getType() != DatasetType.REGION3D) {
                    String string = InternalResource.loadString("validatingRecordset", "Global_ArgumentTypeInvalid", "topology_resources");
                    throw new IllegalArgumentException(string);
                }
            } else if (validatingRecordset.getDataset().getType() != DatasetType.POINT && validatingRecordset.getDataset().getType() != DatasetType.LINE && validatingRecordset.getDataset().getType() != DatasetType.REGION) {
                String string = InternalResource.loadString("validatingRecordset", "Global_ArgumentTypeInvalid", "topology_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if (rule == null) {
            String string = InternalResource.loadString("rule", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = 0L;
        if (validateRegion != null && (l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)validateRegion)) == 0L) {
            String string = InternalResource.loadString("validateRegion", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (outputDatasource == null) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)outputDatasource);
        if (l4 == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (!outputDatasource.getDatasets().isAvailableDatasetName(outputDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "GlobalDatasetNameInvalid", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l5 = TopologyValidatorNative.jni_validate2(l, l2, rule.value(), tolerance, l3, l4, outputDatasetName);
        DatasetVector datasetVector = null;
        if (l5 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l5, outputDatasource);
            InternalDatasets.add(outputDatasource.getDatasets(), (Dataset)datasetVector);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)sourceRecordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)validatingRecordset);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)validateRegion);
        return datasetVector;
    }

    public static boolean fixTopoError(DatasetVector sourceDataset, DatasetVector validatingDataset, DatasetVector topoErrorDataset) {
        if (sourceDataset == null) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        if (l == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        if (validatingDataset != null && (l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)validatingDataset)) == 0L) {
            String string = InternalResource.loadString("validatingDataset", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (topoErrorDataset == null) {
            String string = InternalResource.loadString("topoErrorDataset", "Global_ArgumentNull", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)topoErrorDataset);
        if (l3 == 0L) {
            String string = InternalResource.loadString("topoErrorDataset", "Handle_ObjectHasBeenDisposed", "topology_resources");
            throw new IllegalArgumentException(string);
        }
        if (topoErrorDataset.getRecordCount() <= 0) {
            return false;
        }
        return TopologyValidatorNative.jni_fixErrorAuto(l, l2, l3);
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "TopologyValidator";
        boolean bl = InternalToolkitTolopogy.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        TopologyValidator.fireStepped(steppedEvent);
        InternalToolkitTolopogy.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }
}

