/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.trafficanalyst;

import com.supermap.analyst.trafficanalyst.InternalResource;
import com.supermap.analyst.trafficanalyst.StopSetting;
import com.supermap.analyst.trafficanalyst.StopSettingsNative;
import com.supermap.data.Datasource;
import java.util.ArrayList;

class StopSettings {
    private ArrayList<StopSetting> m_settings = new ArrayList();

    public StopSettings() {
    }

    public StopSettings(StopSettings stopSettings) {
        StopSetting[] stopSettingArray = stopSettings.toArray();
        this.addRange(stopSettingArray);
    }

    public int getCount() {
        return this.m_settings.size();
    }

    public StopSetting get(int index) {
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.m_settings.get(index);
    }

    public void set(int index, StopSetting transferStopSetting) {
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        this.m_settings.set(index, transferStopSetting);
    }

    public int add(StopSetting transferStopSetting) {
        if (transferStopSetting == null) {
            String string = InternalResource.loadString("transferLineSetting", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this.m_settings.add(transferStopSetting);
        return this.m_settings.size();
    }

    public int addRange(StopSetting[] transferStopSettings) {
        int n;
        if (transferStopSettings == null) {
            String string = InternalResource.loadString("transferLineSettings", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        boolean bl = false;
        for (n = 0; n < transferStopSettings.length; ++n) {
            if (transferStopSettings[n] != null) continue;
            bl = true;
            break;
        }
        if (bl) {
            String string = InternalResource.loadString("transferLineSettings", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        for (n = 0; n < transferStopSettings.length; ++n) {
            this.m_settings.add(transferStopSettings[n]);
        }
        return transferStopSettings.length;
    }

    public boolean remove(int index) {
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        this.m_settings.remove(index);
        return true;
    }

    public int removeRange(int index, int count) {
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n = index + count;
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index+count", "Global_IndexOutOfBounds", "trafficanalyst_resources");
            throw new IndexOutOfBoundsException(string);
        }
        for (int i = n - 1; i >= index; --i) {
            this.m_settings.remove(i);
        }
        return count;
    }

    public void clear() {
        this.m_settings.clear();
    }

    public StopSetting[] toArray() {
        int n = this.m_settings.size();
        StopSetting[] stopSettingArray = new StopSetting[n];
        for (int i = 0; i < stopSettingArray.length; ++i) {
            stopSettingArray[i] = new StopSetting(this.m_settings.get(i));
        }
        return stopSettingArray;
    }

    long setToUGC() {
        int n = this.m_settings.size();
        long l = StopSettingsNative.jni_New();
        for (int i = 0; i < n; ++i) {
            this.m_settings.get(i).setToUGC(l);
        }
        return l;
    }

    void getFromUGC(Datasource ds, long handle) {
        long[] lArray = StopSettingsNative.jni_GetHandls(handle);
        for (int i = 0; i < lArray.length; ++i) {
            StopSetting stopSetting = new StopSetting();
            stopSetting.getFromUGC(ds, lArray[i]);
            this.m_settings.add(stopSetting);
        }
    }
}

