/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.ServiceType;
import com.supermap.analyst.networkanalyst.TransportationAnalystParameterNative;
import com.supermap.data.Point2Ds;

public class TransportationAnalystParameter
extends InternalHandleDisposable {
    private int[] m_nodes = null;
    private Point2Ds m_points = null;
    private String m_weightName = "";
    private int[] m_barrierNodes = null;
    private int[] m_barrierEdges = null;
    private Point2Ds m_barrierPoints = null;
    private String m_turnWeightField = "";
    private boolean m_isRoutesReturn = false;
    private boolean m_isNodesReturn = false;
    private boolean m_isEdgesReturn = false;
    private boolean m_isPathGuidesReturn = false;
    private boolean m_isStopsReturn = false;
    private int[][] m_ucross = null;
    private boolean m_isAlt = false;
    private ServiceType m_nType = ServiceType.SIMPLEAREA;

    public TransportationAnalystParameter() {
        long l = TransportationAnalystParameterNative.jni_New();
        this.setHandle(l, true);
        this.reset();
    }

    void reset() {
        long l = super.getHandle();
        if (l != 0L) {
            TransportationAnalystParameterNative.jni_Reset(l);
        }
    }

    public TransportationAnalystParameter(TransportationAnalystParameter transportationAnalystParameter) {
        long l = TransportationAnalystParameterNative.jni_New();
        this.setHandle(l, true);
        this.reset();
        this.copyFrom(transportationAnalystParameter);
    }

    void copyFrom(TransportationAnalystParameter value) {
        if (value != null) {
            this.setNodes(value.getNodes());
            this.setPoints(value.getPoints());
            this.setWeightName(value.getWeightName());
            this.setBarrierNodes(value.getBarrierNodes());
            this.setBarrierEdges(value.getBarrierEdges());
            this.setBarrierPoints(value.getBarrierPoints());
            this.setTurnWeightField(value.getTurnWeightField());
            this.setNodesReturn(value.isNodesReturn());
            this.setEdgesReturn(value.isEdgesReturn());
            this.setPathGuidesReturn(value.isPathGuidesReturn());
            this.setRoutesReturn(value.isRoutesReturn());
            this.setStopIndexesReturn(value.isStopIndexesReturn());
            this.setUCross(value.getUCross());
            this.setAlternative(value.isAlternative());
        }
    }

    protected long getHandle() {
        long l = super.getHandle();
        if (l != 0L) {
            int n;
            double[] dArray;
            double[] dArray2;
            int n2;
            TransportationAnalystParameterNative.jni_SetIsRoutesReturn(l, this.m_isRoutesReturn);
            TransportationAnalystParameterNative.jni_SetIsNodesReturn(l, this.m_isNodesReturn);
            TransportationAnalystParameterNative.jni_SetIsEdgesReturn(l, this.m_isEdgesReturn);
            TransportationAnalystParameterNative.jni_SetIsPathGuidesReturn(l, this.m_isPathGuidesReturn);
            TransportationAnalystParameterNative.jni_SetIsStopsReturn(l, this.m_isStopsReturn);
            if (this.m_nodes != null && this.m_nodes.length != 0) {
                TransportationAnalystParameterNative.jni_SetNodes(l, this.m_nodes);
            }
            if (this.m_points != null && this.m_points.getCount() != 0) {
                n2 = this.m_points.getCount();
                dArray2 = new double[n2];
                dArray = new double[n2];
                for (n = 0; n < n2; ++n) {
                    dArray2[n] = this.m_points.getItem(n).getX();
                    dArray[n] = this.m_points.getItem(n).getY();
                }
                TransportationAnalystParameterNative.jni_SetPoints(l, dArray2, dArray);
            }
            TransportationAnalystParameterNative.jni_SetWeightName(l, this.m_weightName);
            if (this.m_barrierNodes != null) {
                TransportationAnalystParameterNative.jni_SetBarrierNodes(l, this.m_barrierNodes);
            } else {
                TransportationAnalystParameterNative.jni_SetBarrierNodes(l, new int[0]);
            }
            if (this.m_barrierEdges != null) {
                TransportationAnalystParameterNative.jni_SetBarrierEdges(l, this.m_barrierEdges);
            } else {
                TransportationAnalystParameterNative.jni_SetBarrierEdges(l, new int[0]);
            }
            if (this.m_barrierPoints != null && this.m_barrierPoints.getCount() != 0) {
                n2 = this.m_barrierPoints.getCount();
                dArray2 = new double[n2];
                dArray = new double[n2];
                for (n = 0; n < n2; ++n) {
                    dArray2[n] = this.m_barrierPoints.getItem(n).getX();
                    dArray[n] = this.m_barrierPoints.getItem(n).getY();
                }
                TransportationAnalystParameterNative.jni_SetBarrierPoints(l, dArray2, dArray);
            }
            TransportationAnalystParameterNative.jni_SetTurnWeightField(l, this.m_turnWeightField);
            if (this.m_ucross != null && this.m_ucross.length != 0) {
                TransportationAnalystParameterNative.jni_SetUCross(l, this.m_ucross);
            }
            TransportationAnalystParameterNative.jni_SetServiceType(l, this.m_nType.value());
            TransportationAnalystParameterNative.jni_SetIsAlternative(l, this.m_isAlt);
        }
        return l;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            TransportationAnalystParameterNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    public boolean isRoutesReturn() {
        return this.m_isRoutesReturn;
    }

    public void setRoutesReturn(boolean value) {
        this.m_isRoutesReturn = value;
    }

    public boolean isNodesReturn() {
        return this.m_isNodesReturn;
    }

    public void setNodesReturn(boolean value) {
        this.m_isNodesReturn = value;
    }

    public boolean isEdgesReturn() {
        return this.m_isEdgesReturn;
    }

    public void setEdgesReturn(boolean value) {
        this.m_isEdgesReturn = value;
    }

    public boolean isPathGuidesReturn() {
        return this.m_isPathGuidesReturn;
    }

    public void setPathGuidesReturn(boolean value) {
        this.m_isPathGuidesReturn = value;
    }

    public boolean isStopIndexesReturn() {
        return this.m_isStopsReturn;
    }

    public void setStopIndexesReturn(boolean value) {
        this.m_isStopsReturn = value;
    }

    public int[] getNodes() {
        if (this.m_nodes != null) {
            return (int[])this.m_nodes.clone();
        }
        return new int[0];
    }

    public void setNodes(int[] value) {
        if (value == null) {
            this.m_nodes = null;
        } else {
            int n = value.length;
            this.m_nodes = new int[n];
            for (int i = 0; i < n; ++i) {
                this.m_nodes[i] = value[i];
            }
            if (n > 0) {
                this.m_points = null;
            }
        }
    }

    public Point2Ds getPoints() {
        if (this.m_points != null) {
            return this.m_points.clone();
        }
        return null;
    }

    public void setPoints(Point2Ds value) {
        if (value == null) {
            this.m_points = null;
        } else {
            if (this.m_points == null) {
                this.m_points = new Point2Ds();
            }
            this.m_points.clear();
            this.m_points.addRange(value.toArray());
            int n = value.getCount();
            if (n > 0) {
                this.m_nodes = null;
            }
        }
    }

    public String getWeightName() {
        return this.m_weightName;
    }

    public void setWeightName(String value) {
        this.m_weightName = value;
    }

    public int[] getBarrierNodes() {
        if (this.m_barrierNodes != null) {
            return this.m_barrierNodes;
        }
        return null;
    }

    public void setBarrierNodes(int[] value) {
        if (value == null) {
            this.m_barrierNodes = null;
        } else {
            int n = value.length;
            this.m_barrierNodes = new int[n];
            for (int i = 0; i < n; ++i) {
                this.m_barrierNodes[i] = value[i];
            }
        }
    }

    public int[] getBarrierEdges() {
        if (this.m_barrierEdges != null) {
            return (int[])this.m_barrierEdges.clone();
        }
        return null;
    }

    public Point2Ds getBarrierPoints() {
        if (this.m_barrierPoints != null) {
            return this.m_barrierPoints.clone();
        }
        return null;
    }

    public void setBarrierPoints(Point2Ds value) {
        if (value == null) {
            this.m_barrierPoints = null;
        } else {
            if (this.m_barrierPoints == null) {
                this.m_barrierPoints = new Point2Ds();
            }
            this.m_barrierPoints.clear();
            this.m_barrierPoints.addRange(value.toArray());
        }
    }

    public void setBarrierEdges(int[] value) {
        if (value == null) {
            this.m_barrierEdges = null;
        } else {
            int n = value.length;
            this.m_barrierEdges = new int[n];
            for (int i = 0; i < n; ++i) {
                this.m_barrierEdges[i] = value[i];
            }
        }
    }

    public String getTurnWeightField() {
        return this.m_turnWeightField;
    }

    public void setTurnWeightField(String value) {
        this.m_turnWeightField = value;
    }

    public int[][] getUCross() {
        return this.m_ucross;
    }

    public void setUCross(int[][] value) {
        this.m_ucross = value;
    }

    public ServiceType getServiceType() {
        return this.m_nType;
    }

    public void setServiceType(ServiceType value) {
        this.m_nType = value;
    }

    private boolean isAlternative() {
        return this.m_isAlt;
    }

    private void setAlternative(boolean value) {
        this.m_isAlt = value;
    }
}

