/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.iobjects.process.ml;

import com.supermap.iobjects.process.ml.MLProcess;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

class BaseProcess
implements MLProcess {
    static ReentrantLock lockGPU = new ReentrantLock(true);
    static Boolean isGPU;

    BaseProcess() {
    }

    static String ProduceProcessReturn(boolean result, String outputDatasource, String outputDatasetName) {
        String processReturn;
        if (result) {
            String[] inputDataPathSplit = outputDatasource.split("\\.");
            String inputDataFormat = inputDataPathSplit[inputDataPathSplit.length - 1].toLowerCase();
            processReturn = "sdx --dbType=" + inputDataFormat + " --server=" + outputDatasource + " --dataset=" + outputDatasetName;
        } else {
            processReturn = "false";
        }
        return processReturn;
    }

    static {
        ArrayList<String> processParameters = new ArrayList<String>();
        processParameters.add("python");
        processParameters.add("-c");
        processParameters.add("\"import torch;print(torch.cuda.is_available())\"");
        ProcessBuilder checkGPU = new ProcessBuilder(processParameters);
        try {
            String line;
            Process process = checkGPU.start();
            StringBuilder line_collect = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                line_collect.append("***");
                line_collect.append(line);
            }
            String[] checkResult = line_collect.toString().split("\\*\\*\\*");
            isGPU = Boolean.parseBoolean(checkResult[checkResult.length - 1]);
            if (isGPU.booleanValue()) {
                System.out.println("Process is running on GPU!");
            } else {
                System.out.println("Process is running on CPU!");
            }
            reader.close();
        }
        catch (IOException e) {
            System.out.println("Python env not ready!");
        }
    }
}

