/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy;

import com.supermap.data.Workspace;
import com.supermap.jsuperpy.HeartBeatClient;
import com.supermap.jsuperpy.RegisterWorkspace;
import java.io.DataOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import py4j.CallbackClient;
import py4j.GatewayServer;
import py4j.Py4JPythonClient;

public final class LaunchGateway {
    private static GatewayServer m_gatewayServer;
    private static boolean m_start;

    private LaunchGateway() {
    }

    public static void startServer() {
        LaunchGateway.startServer(null, -1, true);
    }

    public static int getGatewayServerPort() {
        if (m_gatewayServer != null) {
            return m_gatewayServer.getListeningPort();
        }
        return -1;
    }

    public static GatewayServer getGatewayServer() {
        return m_gatewayServer;
    }

    public static void startServer(String callbackHost, int callbackPort, boolean isDesktopMode) {
        if (!m_start) {
            try {
                if (!isDesktopMode && (callbackHost == null || callbackPort < 0 || callbackHost.isEmpty())) {
                    throw new RuntimeException("required callback address and port when is not desktop mode.");
                }
                CallbackClient cbClient = new CallbackClient(25334, InetAddress.getByName("127.0.0.1"), 2L, TimeUnit.SECONDS, SocketFactory.getDefault(), false);
                m_gatewayServer = new GatewayServer((Object)new LaunchGateway(), 0, 0, 0, null, (Py4JPythonClient)cbClient);
                m_gatewayServer.start();
                m_start = true;
                if (!isDesktopMode) {
                    int boundPort = m_gatewayServer.getListeningPort();
                    Socket callbackSocket = new Socket(callbackHost, callbackPort);
                    DataOutputStream dos = new DataOutputStream(callbackSocket.getOutputStream());
                    dos.writeInt(boundPort);
                    dos.close();
                    callbackSocket.close();
                }
                System.out.println("[SuperMap]: Start Java Gateway Service Successful, Gateway Service port bind " + m_gatewayServer.getListeningPort());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void resetPythonPort(String address, int port) {
        if (port > 0) {
            try {
                if (port != 25334) {
                    m_gatewayServer.resetCallbackClient(InetAddress.getByName(address), port);
                } else {
                    System.out.println("SuperMap: No need to reset python call back port");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(e.getMessage());
            }
        }
    }

    public static boolean startHeartBeatClient(String address, int port) {
        Thread d = new Thread(new HeartBeatClient(address, port));
        d.setDaemon(true);
        d.start();
        return true;
    }

    public static GatewayServer getGatawayServer() {
        return m_gatewayServer;
    }

    public static Workspace getWorkspace() {
        return RegisterWorkspace.getWorkspace();
    }

    public static Workspace newPythonWorkspace() {
        return RegisterWorkspace.newPythonWorkspace();
    }

    public static boolean closePythonWorkspace() {
        if (RegisterWorkspace.isCreatedByPython()) {
            return RegisterWorkspace.closeWorkspace();
        }
        return false;
    }

    public static void setWorkspaceNull() {
        RegisterWorkspace.setWorkspace(null);
    }

    public static boolean isCreateByPython() {
        return RegisterWorkspace.isCreatedByPython();
    }

    static {
        m_start = false;
    }
}

