/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.Scene;
import com.supermap.realspace.SceneNative;
import com.supermap.realspace.SliderNative;
import com.supermap.realspace.ValueChangedEvent;
import com.supermap.realspace.ValueChangedListener;
import java.awt.Point;
import java.util.Vector;

public class Slider
extends InternalHandle {
    private boolean m_visible = true;
    private boolean m_isTextVisible = true;
    transient Vector<ValueChangedListener> m_valueChangedListeners;

    public Slider(Scene scene, String name) {
        long l = SceneNative.jni_AddSlider(InternalHandle.getHandle((com.supermap.data.InternalHandle)scene), name);
        this.setHandle(l);
        SliderNative.jni_NewSelfEventHandle(this.getHandle(), this);
    }

    static void valueChangedCallBack(Slider slider, double value) {
        if (slider.getHandle() == 0L) {
            String string = InternalResource.loadString("Slider", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        ValueChangedEvent valueChangedEvent = new ValueChangedEvent((Object)slider, value);
        slider.fireValueChanged(valueChangedEvent);
    }

    private void fireValueChanged(ValueChangedEvent event) {
        if (this.m_valueChangedListeners != null) {
            Vector<ValueChangedListener> vector = this.m_valueChangedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).valueChanged(event);
            }
        }
    }

    public void setVisible(boolean visible) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SliderNative.jni_SetVisible(this.getHandle(), visible);
    }

    public boolean isVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SliderNative.jni_IsVisible(this.getHandle());
    }

    public void setTextVisible(boolean visible) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTextVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SliderNative.jni_SetTextVisible(this.getHandle(), visible);
    }

    public boolean isTextVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTextVisible()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SliderNative.jni_IsTextVisible(this.getHandle());
    }

    public void setValue(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setValue()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SliderNative.jni_SetValue(this.getHandle(), value);
    }

    public double getValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getValue()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SliderNative.jni_GetValue(this.getHandle());
    }

    public void setLocation(Point point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLocation()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SliderNative.jni_SetLocation(this.getHandle(), point.x, point.y);
    }

    public Point getLocation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLocation()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[2];
        SliderNative.jni_GetLocation(this.getHandle(), nArray);
        return new Point(nArray[0], nArray[1]);
    }

    public void setStartText(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStartText()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SliderNative.jni_SetStartText(this.getHandle(), value);
    }

    public String getStartText() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStartText()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SliderNative.jni_GetStartText(this.getHandle());
    }

    public void setEndText(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEndText()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SliderNative.jni_SetEndText(this.getHandle(), value);
    }

    public String getEndText() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEndText()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SliderNative.jni_GetEndText(this.getHandle());
    }

    public void setCurrentText(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCurrentText()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SliderNative.jni_SetCurrentText(this.getHandle(), value);
    }

    public String getCurrentText() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCurrentText()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SliderNative.jni_GetCurrentText(this.getHandle());
    }

    public synchronized void addValueChangedListener(ValueChangedListener l) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addValueChangedListener()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_valueChangedListeners == null) {
            this.m_valueChangedListeners = new Vector();
        }
        if (!this.m_valueChangedListeners.contains(l)) {
            this.m_valueChangedListeners.add(l);
        }
    }

    public synchronized void removeValueChangedListener(ValueChangedListener l) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeValueChangedListener()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_valueChangedListeners != null && this.m_valueChangedListeners.contains(l)) {
            this.m_valueChangedListeners.remove(l);
        }
    }
}

