/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.addressmatching;

import com.supermap.analyst.addressmatching.AddressMatchNative;
import com.supermap.analyst.addressmatching.AddressMatchResults;
import com.supermap.analyst.addressmatching.InternalHandleDisposable;
import com.supermap.analyst.addressmatching.InternalResource;

public class AddressSearchResult
extends InternalHandleDisposable {
    private int m_count;

    AddressSearchResult(long handle) {
        this.setHandle(handle, true);
        this.m_count = AddressMatchNative.jni_GetResultCount(handle);
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            AddressMatchNative.jni_Delete2(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        return this.m_count;
    }

    public AddressMatchResults get(int resultCount, int startPosition) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("match1(String searchAddress)", "Handle_ObjectHasBeenDisposed", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (resultCount <= 0) {
            String string = InternalResource.loadString("resultCount", "Global_ShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        if (startPosition < 0) {
            String string = InternalResource.loadString("startPosition", "Global_ShouldGreaterThanZero", "addressmatching_resources");
            throw new IllegalStateException(string);
        }
        long l = AddressMatchNative.jni_GetMatchResults1(this.getHandle(), resultCount, startPosition);
        AddressMatchResults addressMatchResults = null;
        if (l != 0L) {
            addressMatchResults = new AddressMatchResults(l, null);
        }
        return addressMatchResults;
    }
}

